/*      */ package org.jboss.metadata.ejb.jboss;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.Collections;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import javax.ejb.TransactionAttributeType;
/*      */ import javax.ejb.TransactionManagementType;
/*      */ import javax.xml.bind.annotation.XmlElement;
/*      */ import javax.xml.bind.annotation.XmlTransient;
/*      */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*      */ import org.jboss.metadata.common.ejb.IEnterpriseBeanMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*      */ import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodInterfaceType;
/*      */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*      */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.AnnotationsMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.IgnoreDependencyMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.JndiRefsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.Environment;
/*      */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*      */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.TransactionManagementTypeAdapter;
/*      */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*      */ import org.jboss.metadata.javaee.support.NamedMetaData;
/*      */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptionGroup;
/*      */ import org.jboss.metadata.javaee.support.NonNullLinkedHashSet;
/*      */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*      */ 
/*      */ @JBossXmlModelGroup(kind="choice", particles={@org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="session"), type=JBossSessionBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="entity"), type=JBossEntityBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="message-driven"), type=JBossMessageDrivenBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="consumer"), type=JBossConsumerBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="ejb"), type=JBossGenericBeanMetaData.class), @org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="service"), type=JBossServiceBeanMetaData.class)})
/*      */ public abstract class JBossEnterpriseBeanMetaData extends NamedMetaDataWithDescriptionGroup
/*      */   implements Environment, IEnterpriseBeanMetaData<JBossAssemblyDescriptorMetaData, JBossEnterpriseBeansMetaData, JBossEnterpriseBeanMetaData, JBossMetaData>
/*      */ {
/*      */   private static final long serialVersionUID = 6909774842926430193L;
/*      */   private JBossEnterpriseBeansMetaData enterpriseBeansMetaData;
/*      */   private String mappedName;
/*      */   private String ejbClass;
/*      */   private String localJndiName;
/*      */   private boolean exceptionOnRollback;
/*  123 */   private boolean timerPersistence = true;
/*      */   private String configurationName;
/*      */   private InvokerBindingsMetaData invokers;
/*      */   private transient InvokerBindingsMetaData determinedInvokers;
/*      */   private IORSecurityConfigMetaData iorSecurityConfig;
/*      */   private String securityProxy;
/*      */   private JBossEnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*      */   private MethodAttributesMetaData methodAttributes;
/*      */   private String securityDomain;
/*      */   private Set<String> depends;
/*      */   private AnnotationsMetaData annotations;
/*      */   private IgnoreDependencyMetaData ignoreDependency;
/*      */   private String aopDomainName;
/*      */   private PoolConfigMetaData poolConfig;
/*      */   private JndiRefsMetaData jndiRefs;
/*      */   private SecurityIdentityMetaData securityIdentity;
/*      */   private transient ContainerTransactionsMetaData cachedContainerTransactions;
/*      */   private transient ConcurrentHashMap<Method, TransactionAttributeType> methodTx;
/*      */   private TransactionManagementType transactionType;
/*      */ 
/*      */   public static JBossEnterpriseBeanMetaData newBean(EnterpriseBeanMetaData bean)
/*      */   {
/*  187 */     JBossEnterpriseBeanMetaData jbean = null;
/*  188 */     if ((bean instanceof EntityBeanMetaData))
/*  189 */       jbean = new JBossEntityBeanMetaData();
/*  190 */     if ((bean instanceof MessageDrivenBeanMetaData))
/*  191 */       jbean = new JBossMessageDrivenBeanMetaData();
/*  192 */     if ((bean instanceof SessionBeanMetaData))
/*  193 */       jbean = new JBossSessionBeanMetaData();
/*  194 */     return jbean;
/*      */   }
/*      */ 
/*      */   public JBossEnterpriseBeansMetaData getEnterpriseBeansMetaData()
/*      */   {
/*  212 */     return this.enterpriseBeansMetaData;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public void setEnterpriseBeansMetaData(JBossEnterpriseBeansMetaData enterpriseBeansMetaData)
/*      */   {
/*  223 */     assert (enterpriseBeansMetaData != null) : "enterpriseBeansMetaData is null";
/*      */ 
/*  225 */     this.enterpriseBeansMetaData = enterpriseBeansMetaData;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public JBossMetaData getJBossMetaData()
/*      */   {
/*  236 */     if (this.enterpriseBeansMetaData == null)
/*  237 */       return null;
/*  238 */     return this.enterpriseBeansMetaData.getEjbJarMetaData();
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public JBossMetaData getJBossMetaDataWithCheck()
/*      */   {
/*  249 */     JBossMetaData jbossMetaData = getJBossMetaData();
/*  250 */     if (jbossMetaData == null)
/*  251 */       throw new IllegalStateException("This bean is not a part of a deployment " + this);
/*  252 */     return jbossMetaData;
/*      */   }
/*      */ 
/*      */   public Environment getJndiEnvironmentRefsGroup()
/*      */   {
/*  262 */     return this.jndiEnvironmentRefsGroup;
/*      */   }
/*      */ 
/*      */   @XmlElement(type=JBossEnvironmentRefsGroupMetaData.class)
/*      */   public void setJndiEnvironmentRefsGroup(Environment env) {
/*  268 */     if (env == null)
/*  269 */       throw new IllegalArgumentException("Null jndiEnvironmentRefsGroup");
/*  270 */     JBossEnvironmentRefsGroupMetaData jenv = (JBossEnvironmentRefsGroupMetaData)env;
/*  271 */     if (this.jndiEnvironmentRefsGroup != null)
/*  272 */       this.jndiEnvironmentRefsGroup.merge(jenv, null, null, "jboss.xml", "ejb-jar.xml", false);
/*      */     else
/*  274 */       this.jndiEnvironmentRefsGroup = jenv;
/*      */   }
/*      */ 
/*      */   public String getEjbName()
/*      */   {
/*  284 */     return getName();
/*      */   }
/*      */ 
/*      */   public void setEjbName(String ejbName)
/*      */   {
/*  295 */     setName(ejbName);
/*      */   }
/*      */ 
/*      */   public String getEjbClass()
/*      */   {
/*  300 */     return this.ejbClass;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public JBossMetaData getEjbJarMetaData() {
/*  306 */     return this.enterpriseBeansMetaData.getEjbJarMetaData();
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public ContainerTransactionsMetaData getContainerTransactions()
/*      */   {
/*  317 */     if (this.cachedContainerTransactions != null)
/*  318 */       return this.cachedContainerTransactions;
/*  319 */     JBossAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/*  320 */     if (assemblyDescriptor == null)
/*  321 */       return null;
/*  322 */     return assemblyDescriptor.getContainerTransactionsByEjbName(getEjbName());
/*      */   }
/*      */ 
/*      */   public TransactionAttributeType getMethodTransactionType(String methodName, Class<?>[] params, MethodInterfaceType iface)
/*      */   {
/*  336 */     TransactionAttributeType result = null;
/*      */ 
/*  338 */     ContainerTransactionsMetaData containerTransactions = getContainerTransactions();
/*  339 */     if ((containerTransactions == null) || (containerTransactions.isEmpty())) {
/*  340 */       return result;
/*      */     }
/*  342 */     ContainerTransactionMetaData bestMatchTransaction = null;
/*  343 */     MethodMetaData bestMatch = null;
/*  344 */     for (ContainerTransactionMetaData transaction : containerTransactions)
/*      */     {
/*  346 */       MethodMetaData match = transaction.bestMatch(methodName, params, iface, bestMatch);
/*  347 */       if (match != bestMatch)
/*      */       {
/*  349 */         bestMatchTransaction = transaction;
/*  350 */         bestMatch = match;
/*      */       }
/*      */     }
/*      */ 
/*  354 */     if (bestMatchTransaction != null) {
/*  355 */       result = bestMatchTransaction.getTransAttribute();
/*      */     }
/*  357 */     return result;
/*      */   }
/*      */ 
/*      */   public TransactionAttributeType getMethodTransactionType(Method m, MethodInterfaceType iface)
/*      */   {
/*  369 */     if (m == null) {
/*  370 */       return TransactionAttributeType.SUPPORTS;
/*      */     }
/*  372 */     TransactionAttributeType result = null;
/*  373 */     if (this.methodTx != null)
/*      */     {
/*  375 */       result = (TransactionAttributeType)this.methodTx.get(m);
/*  376 */       if (result != null) {
/*  377 */         return result;
/*      */       }
/*      */     }
/*  380 */     result = getMethodTransactionType(m.getName(), m.getParameterTypes(), iface);
/*      */ 
/*  383 */     if (result == null) {
/*  384 */       result = TransactionAttributeType.REQUIRED;
/*      */     }
/*  386 */     if (this.methodTx == null)
/*  387 */       this.methodTx = new ConcurrentHashMap();
/*  388 */     this.methodTx.put(m, result);
/*  389 */     return result;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public ExcludeListMetaData getExcludeList()
/*      */   {
/*  400 */     JBossAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/*  401 */     if (assemblyDescriptor == null)
/*  402 */       return null;
/*  403 */     return assemblyDescriptor.getExcludeListByEjbName(getEjbName());
/*      */   }
/*      */ 
/*      */   public String getMappedName()
/*      */   {
/*  408 */     return this.mappedName;
/*      */   }
/*      */ 
/*      */   public void setEjbClass(String ejbClass)
/*      */   {
/*  413 */     this.ejbClass = ejbClass;
/*      */   }
/*      */ 
/*      */   public void setMappedName(String mappedName)
/*      */   {
/*  418 */     this.mappedName = mappedName;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isConsumer()
/*      */   {
/*  429 */     return false;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isService()
/*      */   {
/*  440 */     return false;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isSession()
/*      */   {
/*  451 */     return false;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isMessageDriven()
/*      */   {
/*  462 */     return false;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isEntity()
/*      */   {
/*  473 */     return false;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isCMT()
/*      */   {
/*  484 */     TransactionManagementType type = getTransactionType();
/*  485 */     if (type == null) {
/*  486 */       return true;
/*      */     }
/*  488 */     return type == TransactionManagementType.CONTAINER;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean isBMT()
/*      */   {
/*  499 */     return !isCMT();
/*      */   }
/*      */ 
/*      */   public TransactionManagementType getTransactionType()
/*      */   {
/*  504 */     return this.transactionType;
/*      */   }
/*      */ 
/*      */   @XmlJavaTypeAdapter(TransactionManagementTypeAdapter.class)
/*      */   public void setTransactionType(TransactionManagementType transactionType) {
/*  510 */     this.transactionType = transactionType;
/*      */   }
/*      */ 
/*      */   public String getLocalJndiName()
/*      */   {
/*  520 */     return this.localJndiName;
/*      */   }
/*      */ 
/*      */   public void setLocalJndiName(String localJndiName)
/*      */   {
/*  531 */     if (localJndiName == null)
/*  532 */       throw new IllegalArgumentException("Null localJndiName");
/*  533 */     this.localJndiName = localJndiName;
/*      */   }
/*      */ 
/*      */   public String determineLocalJndiName()
/*      */   {
/*  543 */     if (this.localJndiName != null) {
/*  544 */       return this.localJndiName;
/*      */     }
/*  546 */     String ejbName = getEjbName();
/*      */ 
/*  548 */     return "local/" + ejbName + '@' + System.identityHashCode(ejbName);
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public String getContainerObjectNameJndiName()
/*      */   {
/*  559 */     return getLocalJndiName();
/*      */   }
/*      */ 
/*      */   public boolean isExceptionOnRollback()
/*      */   {
/*  569 */     return this.exceptionOnRollback;
/*      */   }
/*      */ 
/*      */   public void setExceptionOnRollback(boolean exceptionOnRollback)
/*      */   {
/*  579 */     this.exceptionOnRollback = exceptionOnRollback;
/*      */   }
/*      */ 
/*      */   public boolean isTimerPersistence()
/*      */   {
/*  589 */     return this.timerPersistence;
/*      */   }
/*      */ 
/*      */   public void setTimerPersistence(boolean timerPersistence)
/*      */   {
/*  599 */     this.timerPersistence = timerPersistence;
/*      */   }
/*      */ 
/*      */   public String getConfigurationName()
/*      */   {
/*  609 */     return this.configurationName;
/*      */   }
/*      */ 
/*      */   public void setConfigurationName(String configurationName)
/*      */   {
/*  620 */     if (configurationName == null)
/*  621 */       throw new IllegalArgumentException("Null configurationName");
/*  622 */     this.configurationName = configurationName;
/*      */   }
/*      */ 
/*      */   public String determineConfigurationName()
/*      */   {
/*  632 */     if (this.configurationName != null) {
/*  633 */       return this.configurationName;
/*      */     }
/*  635 */     return getDefaultConfigurationName();
/*      */   }
/*      */ 
/*      */   public ContainerConfigurationMetaData determineContainerConfiguration()
/*      */   {
/*  645 */     String name = determineConfigurationName();
/*  646 */     ContainerConfigurationMetaData result = getJBossMetaDataWithCheck().getContainerConfiguration(name);
/*  647 */     if (result == null)
/*  648 */       throw new IllegalStateException("Container configuration not found: " + name + " available: " + getJBossMetaDataWithCheck().getContainerConfigurations());
/*  649 */     return result;
/*      */   }
/*      */ 
/*      */   public void setPoolConfig(PoolConfigMetaData poolConfig)
/*      */   {
/*  654 */     this.poolConfig = poolConfig;
/*      */   }
/*      */ 
/*      */   public abstract String getDefaultConfigurationName();
/*      */ 
/*      */   public String getSecurityProxy()
/*      */   {
/*  671 */     return this.securityProxy;
/*      */   }
/*      */ 
/*      */   public void setSecurityProxy(String securityProxy)
/*      */   {
/*  682 */     if (securityProxy == null)
/*  683 */       throw new IllegalArgumentException("Null securityProxy");
/*  684 */     this.securityProxy = securityProxy;
/*      */   }
/*      */ 
/*      */   public String getSecurityDomain()
/*      */   {
/*  694 */     return this.securityDomain;
/*      */   }
/*      */ 
/*      */   @XmlElement(required=false)
/*      */   public void setSecurityDomain(String securityDomain)
/*      */   {
/*  706 */     if (securityDomain == null)
/*  707 */       throw new IllegalArgumentException("Null securityDomain");
/*  708 */     this.securityDomain = securityDomain;
/*      */   }
/*      */ 
/*      */   public Set<String> getDepends()
/*      */   {
/*  718 */     return this.depends;
/*      */   }
/*      */ 
/*      */   @XmlElement
/*      */   public void setDepends(Set<String> depends)
/*      */   {
/*  730 */     if (depends == null)
/*  731 */       throw new IllegalArgumentException("Null depends");
/*  732 */     this.depends = depends;
/*      */   }
/*      */ 
/*      */   public Set<String> determineAllDepends()
/*      */   {
/*  742 */     NonNullLinkedHashSet result = new NonNullLinkedHashSet();
/*      */ 
/*  744 */     Set depends = getDepends();
/*  745 */     if (depends != null) {
/*  746 */       result.addAll(depends);
/*      */     }
/*  748 */     ContainerConfigurationMetaData containerConfigurationMetaData = determineContainerConfiguration();
/*  749 */     if (containerConfigurationMetaData != null)
/*      */     {
/*  751 */       depends = containerConfigurationMetaData.getDepends();
/*  752 */       if (depends != null) {
/*  753 */         result.addAll(depends);
/*      */       }
/*      */     }
/*  756 */     return result;
/*      */   }
/*      */ 
/*      */   public InvokerBindingsMetaData getInvokerBindings()
/*      */   {
/*  766 */     return this.invokers;
/*      */   }
/*      */ 
/*      */   public void setInvokerBindings(InvokerBindingsMetaData invokers)
/*      */   {
/*  777 */     if (invokers == null)
/*  778 */       throw new IllegalArgumentException("Null invokers");
/*  779 */     this.invokers = invokers;
/*      */   }
/*      */ 
/*      */   public InvokerBindingsMetaData determineInvokerBindings()
/*      */   {
/*  790 */     if (this.determinedInvokers != null) {
/*  791 */       return this.determinedInvokers;
/*      */     }
/*      */ 
/*  794 */     if (this.invokers != null)
/*      */     {
/*  796 */       this.determinedInvokers = this.invokers;
/*  797 */       return this.determinedInvokers;
/*      */     }
/*      */ 
/*  801 */     ContainerConfigurationMetaData containerConfiguration = determineContainerConfiguration();
/*  802 */     Set invokerProxyBindingNames = containerConfiguration.getInvokerProxyBindingNames();
/*      */     String jndiName;
/*  803 */     if ((invokerProxyBindingNames != null) && (!invokerProxyBindingNames.isEmpty()))
/*      */     {
/*  805 */       this.determinedInvokers = new InvokerBindingsMetaData();
/*      */ 
/*  808 */       jndiName = getDefaultInvokerJndiName();
/*  809 */       for (String name : invokerProxyBindingNames)
/*      */       {
/*  811 */         InvokerBindingMetaData invoker = new InvokerBindingMetaData();
/*  812 */         invoker.setInvokerProxyBindingName(name);
/*  813 */         if (jndiName != null)
/*  814 */           invoker.setJndiName(jndiName);
/*  815 */         this.determinedInvokers.add(invoker);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  820 */       this.determinedInvokers = getDefaultInvokers();
/*      */     }
/*  822 */     return this.determinedInvokers;
/*      */   }
/*      */ 
/*      */   public InvokerBindingMetaData determineInvokerBinding(String invokerName)
/*      */   {
/*  834 */     InvokerBindingMetaData binding = (InvokerBindingMetaData)determineInvokerBindings().get(invokerName);
/*  835 */     if (binding == null)
/*  836 */       throw new IllegalStateException("No such binding: " + invokerName + " available: " + this.determinedInvokers);
/*  837 */     return binding;
/*      */   }
/*      */ 
/*      */   protected String getDefaultInvokerJndiName()
/*      */   {
/*  847 */     return null;
/*      */   }
/*      */ 
/*      */   protected InvokerBindingsMetaData getDefaultInvokers()
/*      */   {
/*  857 */     InvokerBindingsMetaData bindings = new InvokerBindingsMetaData();
/*  858 */     InvokerBindingMetaData binding = new InvokerBindingMetaData();
/*  859 */     binding.setInvokerProxyBindingName(getDefaultInvokerName());
/*  860 */     String jndiName = getDefaultInvokerJndiName();
/*  861 */     if (jndiName != null)
/*  862 */       binding.setJndiName(getDefaultInvokerJndiName());
/*  863 */     bindings.add(binding);
/*  864 */     return bindings;
/*      */   }
/*      */ 
/*      */   protected abstract String getDefaultInvokerName();
/*      */ 
/*      */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*      */   {
/*  876 */     return (EJBLocalReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbLocalReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public EJBLocalReferencesMetaData getEjbLocalReferences() {
/*  882 */     EJBLocalReferencesMetaData refs = null;
/*  883 */     if (this.jndiEnvironmentRefsGroup != null)
/*  884 */       refs = this.jndiEnvironmentRefsGroup.getEjbLocalReferences();
/*  885 */     return refs;
/*      */   }
/*      */ 
/*      */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*      */   {
/*  890 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public EJBReferencesMetaData getEjbReferences() {
/*  896 */     EJBReferencesMetaData refs = null;
/*  897 */     if (this.jndiEnvironmentRefsGroup != null)
/*  898 */       refs = this.jndiEnvironmentRefsGroup.getEjbReferences();
/*  899 */     return refs;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/*  905 */     AnnotatedEJBReferencesMetaData refs = null;
/*  906 */     if (this.jndiEnvironmentRefsGroup != null)
/*  907 */       refs = this.jndiEnvironmentRefsGroup.getAnnotatedEjbReferences();
/*  908 */     return refs;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public EnvironmentEntriesMetaData getEnvironmentEntries() {
/*  914 */     EnvironmentEntriesMetaData env = null;
/*  915 */     if (this.jndiEnvironmentRefsGroup != null)
/*  916 */       env = this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/*  917 */     return env;
/*      */   }
/*      */ 
/*      */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*      */   {
/*  922 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*      */   }
/*      */ 
/*      */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*      */   {
/*  927 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public MessageDestinationReferencesMetaData getMessageDestinationReferences() {
/*  933 */     MessageDestinationReferencesMetaData refs = null;
/*  934 */     if (this.jndiEnvironmentRefsGroup != null)
/*  935 */       refs = this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/*  936 */     return refs;
/*      */   }
/*      */ 
/*      */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*      */   {
/*  941 */     return (PersistenceContextReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceContextRefs());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public PersistenceContextReferencesMetaData getPersistenceContextRefs() {
/*  947 */     PersistenceContextReferencesMetaData refs = null;
/*  948 */     if (this.jndiEnvironmentRefsGroup != null)
/*  949 */       refs = this.jndiEnvironmentRefsGroup.getPersistenceContextRefs();
/*  950 */     return refs;
/*      */   }
/*      */ 
/*      */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*      */   {
/*  955 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs() {
/*  961 */     PersistenceUnitReferencesMetaData refs = null;
/*  962 */     if (this.jndiEnvironmentRefsGroup != null)
/*  963 */       refs = this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/*  964 */     return refs;
/*      */   }
/*      */ 
/*      */   public PoolConfigMetaData getPoolConfig()
/*      */   {
/*  969 */     return this.poolConfig;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public LifecycleCallbacksMetaData getPostConstructs() {
/*  975 */     LifecycleCallbacksMetaData lcs = null;
/*  976 */     if (this.jndiEnvironmentRefsGroup != null)
/*  977 */       lcs = this.jndiEnvironmentRefsGroup.getPostConstructs();
/*  978 */     return lcs;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public LifecycleCallbacksMetaData getPreDestroys() {
/*  984 */     LifecycleCallbacksMetaData lcs = null;
/*  985 */     if (this.jndiEnvironmentRefsGroup != null)
/*  986 */       lcs = this.jndiEnvironmentRefsGroup.getPreDestroys();
/*  987 */     return lcs;
/*      */   }
/*      */ 
/*      */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*      */   {
/*  992 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences() {
/*  998 */     ResourceEnvironmentReferencesMetaData refs = null;
/*  999 */     if (this.jndiEnvironmentRefsGroup != null)
/* 1000 */       refs = this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/* 1001 */     return refs;
/*      */   }
/*      */ 
/*      */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*      */   {
/* 1006 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public ResourceReferencesMetaData getResourceReferences() {
/* 1012 */     ResourceReferencesMetaData refs = null;
/* 1013 */     if (this.jndiEnvironmentRefsGroup != null)
/* 1014 */       refs = this.jndiEnvironmentRefsGroup.getResourceReferences();
/* 1015 */     return refs;
/*      */   }
/*      */ 
/*      */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*      */   {
/* 1020 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, getServiceReferences());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public ServiceReferencesMetaData getServiceReferences() {
/* 1026 */     ServiceReferencesMetaData refs = null;
/* 1027 */     if (this.jndiEnvironmentRefsGroup != null)
/* 1028 */       refs = this.jndiEnvironmentRefsGroup.getServiceReferences();
/* 1029 */     return refs;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public SecurityRoleRefsMetaData getSecurityRoleRefs()
/*      */   {
/* 1040 */     return new SecurityRoleRefsMetaData();
/*      */   }
/*      */ 
/*      */   public AnnotationsMetaData getAnnotations()
/*      */   {
/* 1050 */     return this.annotations;
/*      */   }
/*      */ 
/*      */   @XmlElement(name="annotation")
/*      */   public void setAnnotations(AnnotationsMetaData annotations)
/*      */   {
/* 1062 */     if (annotations == null)
/* 1063 */       throw new IllegalArgumentException("Null annotations");
/* 1064 */     this.annotations = annotations;
/*      */   }
/*      */ 
/*      */   public String getAopDomainName()
/*      */   {
/* 1074 */     return this.aopDomainName;
/*      */   }
/*      */ 
/*      */   public void setAopDomainName(String aopDomainName)
/*      */   {
/* 1085 */     if (aopDomainName == null)
/* 1086 */       throw new IllegalArgumentException("Null aopDomainName");
/* 1087 */     this.aopDomainName = aopDomainName;
/*      */   }
/*      */ 
/*      */   public JndiRefsMetaData getJndiRefs()
/*      */   {
/* 1097 */     return this.jndiRefs;
/*      */   }
/*      */ 
/*      */   @XmlElement(name="jndi-ref")
/*      */   public void setJndiRefs(JndiRefsMetaData jndiRefs)
/*      */   {
/* 1109 */     if (jndiRefs == null)
/* 1110 */       throw new IllegalArgumentException("Null jndiRefs");
/* 1111 */     this.jndiRefs = jndiRefs;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public SecurityRoleMetaData getSecurityRole(String roleName)
/*      */   {
/* 1123 */     JBossAssemblyDescriptorMetaData assemblyDescriptor = getJBossMetaDataWithCheck().getAssemblyDescriptor();
/* 1124 */     if (assemblyDescriptor == null) {
/* 1125 */       return null;
/*      */     }
/* 1127 */     return assemblyDescriptor.getSecurityRole(roleName);
/*      */   }
/*      */ 
/*      */   public Set<String> getSecurityRolePrincipals(String roleName)
/*      */   {
/* 1138 */     JBossAssemblyDescriptorMetaData assemblyDescriptor = getJBossMetaDataWithCheck().getAssemblyDescriptor();
/* 1139 */     if (assemblyDescriptor == null) {
/* 1140 */       return null;
/*      */     }
/* 1142 */     return assemblyDescriptor.getSecurityRolePrincipals(roleName);
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public MethodPermissionsMetaData getMethodPermissions()
/*      */   {
/* 1153 */     JBossAssemblyDescriptorMetaData assemblyDescriptor = getAssemblyDescriptor();
/* 1154 */     if (assemblyDescriptor == null)
/* 1155 */       return null;
/* 1156 */     return assemblyDescriptor.getMethodPermissionsByEjbName(getEjbName());
/*      */   }
/*      */ 
/*      */   public Set<String> getMethodPermissions(String methodName, Class<?>[] params, MethodInterfaceType interfaceType)
/*      */   {
/* 1174 */     Set result = null;
/*      */ 
/* 1176 */     JBossMetaData jbossMetaData = getJBossMetaDataWithCheck();
/*      */ 
/* 1180 */     ExcludeListMetaData excluded = getExcludeList();
/* 1181 */     if ((excluded != null) && (excluded.matches(methodName, params, interfaceType)))
/*      */     {
/* 1187 */       if (result == null)
/* 1188 */         result = new HashSet();
/* 1189 */       result.add("<NOBODY>");
/* 1190 */       return result;
/*      */     }
/*      */ 
/* 1194 */     MethodPermissionsMetaData permissions = getMethodPermissions();
/* 1195 */     if (permissions != null)
/*      */     {
/* 1197 */       for (MethodPermissionMetaData permission : permissions)
/*      */       {
/* 1199 */         if (permission.isNotChecked(methodName, params, interfaceType))
/*      */         {
/* 1201 */           if (result == null)
/* 1202 */             result = new HashSet();
/* 1203 */           result.clear();
/* 1204 */           result.add("<ANYBODY>");
/* 1205 */           break;
/*      */         }
/* 1207 */         if (permission.matches(methodName, params, interfaceType))
/*      */         {
/* 1209 */           Set roles = permission.getRoles();
/* 1210 */           if (roles != null)
/*      */           {
/* 1212 */             if (result == null)
/* 1213 */               result = new HashSet();
/* 1214 */             for (String roleName : roles)
/*      */             {
/* 1217 */               Set principals = getSecurityRolePrincipals(roleName);
/* 1218 */               if (principals != null)
/*      */               {
/* 1220 */                 for (String principal : principals)
/*      */                 {
/* 1222 */                   result.add(principal);
/*      */                 }
/*      */               }
/*      */ 
/* 1226 */               result.add(roleName);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1233 */     if ((!jbossMetaData.isExcludeMissingMethods()) && (result == null))
/*      */     {
/* 1235 */       result = new HashSet();
/* 1236 */       result.add("<ANYBODY>");
/*      */     }
/*      */ 
/* 1239 */     if (result == null)
/* 1240 */       result = Collections.emptySet();
/* 1241 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean hasMethodPermissions(String methodName, Class<?>[] params, MethodInterfaceType interfaceType)
/*      */   {
/* 1257 */     ExcludeListMetaData excluded = getExcludeList();
/* 1258 */     if ((excluded != null) && (excluded.matches(methodName, params, interfaceType))) {
/* 1259 */       return true;
/*      */     }
/*      */ 
/* 1262 */     MethodPermissionsMetaData permissions = getMethodPermissions();
/* 1263 */     if (permissions != null)
/*      */     {
/* 1265 */       for (MethodPermissionMetaData permission : permissions)
/*      */       {
/* 1267 */         if (permission.matches(methodName, params, interfaceType)) {
/* 1268 */           return true;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1273 */     return false;
/*      */   }
/*      */ 
/*      */   public IORSecurityConfigMetaData getIorSecurityConfig()
/*      */   {
/* 1283 */     return this.iorSecurityConfig;
/*      */   }
/*      */ 
/*      */   public void setIorSecurityConfig(IORSecurityConfigMetaData iorSecurityConfig)
/*      */   {
/* 1294 */     if (iorSecurityConfig == null)
/* 1295 */       throw new IllegalArgumentException("Null iorSecurityConfig");
/* 1296 */     this.iorSecurityConfig = iorSecurityConfig;
/*      */   }
/*      */ 
/*      */   public IgnoreDependencyMetaData getIgnoreDependency()
/*      */   {
/* 1306 */     return this.ignoreDependency;
/*      */   }
/*      */ 
/*      */   public void setIgnoreDependency(IgnoreDependencyMetaData ignoreDependency)
/*      */   {
/* 1317 */     if (ignoreDependency == null)
/* 1318 */       throw new IllegalArgumentException("Null ignoreDependency");
/* 1319 */     this.ignoreDependency = ignoreDependency;
/*      */   }
/*      */ 
/*      */   public MethodAttributesMetaData getMethodAttributes()
/*      */   {
/* 1329 */     return this.methodAttributes;
/*      */   }
/*      */ 
/*      */   public void setMethodAttributes(MethodAttributesMetaData methodAttributes)
/*      */   {
/* 1340 */     if (methodAttributes == null)
/* 1341 */       throw new IllegalArgumentException("Null methodAttributes");
/* 1342 */     this.methodAttributes = methodAttributes;
/*      */   }
/*      */ 
/*      */   public boolean isMethodReadOnly(String methodName)
/*      */   {
/* 1353 */     if (this.methodAttributes == null)
/* 1354 */       return false;
/* 1355 */     return this.methodAttributes.isMethodReadOnly(methodName);
/*      */   }
/*      */ 
/*      */   public boolean isMethodReadOnly(Method method)
/*      */   {
/* 1366 */     if (method == null)
/* 1367 */       return false;
/* 1368 */     return isMethodReadOnly(method.getName());
/*      */   }
/*      */ 
/*      */   public int getMethodTransactionTimeout(String methodName)
/*      */   {
/* 1379 */     if (this.methodAttributes == null)
/* 1380 */       return 0;
/* 1381 */     return this.methodAttributes.getMethodTransactionTimeout(methodName);
/*      */   }
/*      */ 
/*      */   public int getMethodTransactionTimeout(Method method)
/*      */   {
/* 1392 */     if (method == null)
/* 1393 */       return 0;
/* 1394 */     return getMethodTransactionTimeout(method.getName());
/*      */   }
/*      */ 
/*      */   public SecurityIdentityMetaData getSecurityIdentity()
/*      */   {
/* 1404 */     return this.securityIdentity;
/*      */   }
/*      */ 
/*      */   public void setSecurityIdentity(SecurityIdentityMetaData securityIdentity)
/*      */   {
/* 1415 */     if (securityIdentity == null)
/* 1416 */       throw new IllegalArgumentException("Null securityIdentity");
/* 1417 */     this.securityIdentity = securityIdentity;
/*      */   }
/*      */ 
/*      */   public void merge(NamedMetaData override, NamedMetaData original)
/*      */   {
/* 1423 */     throw new RuntimeException("wrong merge method called");
/*      */   }
/*      */ 
/*      */   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original)
/*      */   {
/* 1428 */     merge(override, original, "jboss.xml", "ejb-jar.xml", true);
/*      */   }
/*      */ 
/*      */   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original, String overrideFile, String overridenFile, boolean mustOverride)
/*      */   {
/* 1433 */     super.merge(override, original);
/* 1434 */     if ((override != null) && (override.getEjbClass() != null))
/* 1435 */       setEjbClass(override.getEjbClass());
/* 1436 */     else if ((original != null) && (original.getEjbClass() != null))
/* 1437 */       setEjbClass(original.getEjbClass());
/* 1438 */     if ((override != null) && (override.getName() != null))
/* 1439 */       setName(override.getName());
/* 1440 */     else if ((original != null) && (original.getName() != null))
/* 1441 */       setName(original.getName());
/* 1442 */     if ((override != null) && (override.getMappedName() != null))
/* 1443 */       setMappedName(override.getMappedName());
/* 1444 */     else if ((original != null) && (original.getMappedName() != null)) {
/* 1445 */       setMappedName(original.getMappedName());
/*      */     }
/*      */ 
/* 1448 */     if ((override != null) && (override.transactionType != null))
/* 1449 */       this.transactionType = override.transactionType;
/* 1450 */     else if ((original != null) && (original.getTransactionType() != null)) {
/* 1451 */       this.transactionType = original.getTransactionType();
/*      */     }
/* 1453 */     if (override != null)
/*      */     {
/* 1455 */       if (override.aopDomainName != null)
/* 1456 */         setAopDomainName(override.aopDomainName);
/* 1457 */       if (override.configurationName != null)
/* 1458 */         setConfigurationName(override.configurationName);
/* 1459 */       if (override.annotations != null)
/* 1460 */         setAnnotations(override.annotations);
/* 1461 */       if (override.depends != null)
/* 1462 */         setDepends(override.depends);
/* 1463 */       setExceptionOnRollback(override.exceptionOnRollback);
/* 1464 */       if (override.ignoreDependency != null)
/* 1465 */         setIgnoreDependency(override.ignoreDependency);
/* 1466 */       if (override.invokers != null)
/* 1467 */         setInvokerBindings(override.invokers);
/* 1468 */       if (override.iorSecurityConfig != null)
/* 1469 */         setIorSecurityConfig(override.iorSecurityConfig);
/* 1470 */       if (override.securityProxy != null) {
/* 1471 */         setSecurityProxy(override.securityProxy);
/*      */       }
/*      */     }
/* 1474 */     if (this.jndiEnvironmentRefsGroup == null)
/* 1475 */       this.jndiEnvironmentRefsGroup = new JBossEnvironmentRefsGroupMetaData();
/* 1476 */     Environment env = original != null ? original.getJndiEnvironmentRefsGroup() : null;
/* 1477 */     JBossEnvironmentRefsGroupMetaData jenv = null;
/* 1478 */     ResourceManagersMetaData resourceMgrs = getJBossMetaData().getResourceManagers();
/* 1479 */     if (override != null)
/*      */     {
/* 1481 */       ResourceManagersMetaData resourceMgrsOverride = override.getJBossMetaData().getResourceManagers();
/* 1482 */       if (resourceMgrsOverride != null)
/* 1483 */         resourceMgrs = resourceMgrsOverride;
/* 1484 */       jenv = override.jndiEnvironmentRefsGroup;
/*      */     }
/* 1486 */     this.jndiEnvironmentRefsGroup.merge(jenv, env, resourceMgrs, overridenFile, overrideFile, mustOverride);
/*      */ 
/* 1489 */     InvokerBindingsMetaData invokerBindings = getInvokerBindings();
/*      */     Iterator i$;
/* 1490 */     if ((invokerBindings != null) && (!invokerBindings.isEmpty()))
/*      */     {
/* 1492 */       for (i$ = invokerBindings.iterator(); i$.hasNext(); ) { invokerBinding = (InvokerBindingMetaData)i$.next();
/*      */ 
/* 1494 */         if (invokerBinding.getEjbRefs() != null)
/*      */         {
/* 1496 */           for (InvokerBindingMetaData.EjbRef ejbRef : invokerBinding.getEjbRefs())
/*      */           {
/* 1498 */             EJBReferenceMetaData targetEjbRef = this.jndiEnvironmentRefsGroup.getEjbReferenceByName(ejbRef.getEjbRefName());
/* 1499 */             if (targetEjbRef == null)
/* 1500 */               throw new IllegalStateException("ejb-ref " + ejbRef.getEjbRefName() + " found on invoker " + invokerBinding.getName() + " but it does not exist for ejb: " + getName());
/* 1501 */             targetEjbRef.addInvokerBinding(invokerBinding.getName(), ejbRef.getJndiName());
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     InvokerBindingMetaData invokerBinding;
/* 1508 */     SecurityIdentityMetaData jbossSecurityIdentity = null;
/* 1509 */     if ((override != null) && (override.getSecurityIdentity() != null))
/* 1510 */       jbossSecurityIdentity = override.getSecurityIdentity();
/* 1511 */     SecurityIdentityMetaData originalSecurityIdentity = null;
/* 1512 */     if (original != null)
/* 1513 */       originalSecurityIdentity = original.getSecurityIdentity();
/* 1514 */     if ((jbossSecurityIdentity != null) || (originalSecurityIdentity != null))
/*      */     {
/* 1516 */       if (this.securityIdentity == null)
/* 1517 */         this.securityIdentity = new SecurityIdentityMetaData();
/* 1518 */       this.securityIdentity.merge(jbossSecurityIdentity, originalSecurityIdentity);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected JBossAssemblyDescriptorMetaData getAssemblyDescriptor()
/*      */   {
/* 1529 */     JBossMetaData ejbJar = getEjbJarMetaData();
/* 1530 */     if (ejbJar == null)
/* 1531 */       return null;
/* 1532 */     return ejbJar.getAssemblyDescriptor();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData
 * JD-Core Version:    0.6.0
 */