/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.common.ejb.IAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImpl;
/*     */ import org.jboss.metadata.javaee.support.JavaEEMetaDataUtil;
/*     */ 
/*     */ @XmlType(name="jboss-assembly-descriptorType")
/*     */ public class JBossAssemblyDescriptorMetaData extends IdMetaDataImpl
/*     */   implements IAssemblyDescriptorMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 5638920200035141015L;
/*     */   private SecurityRolesMetaData securityRoles;
/*     */   private MethodPermissionsMetaData methodPermissions;
/*     */   private ContainerTransactionsMetaData containerTransactions;
/*     */   private InterceptorBindingsMetaData interceptorBindings;
/*     */   private MessageDestinationsMetaData messageDestinations;
/*     */   private ExcludeListMetaData excludeList;
/*     */   private ApplicationExceptionsMetaData applicationExceptions;
/*     */ 
/*     */   public SecurityRoleMetaData getSecurityRole(String roleName)
/*     */   {
/*  91 */     return (SecurityRoleMetaData)this.securityRoles.get(roleName);
/*     */   }
/*     */ 
/*     */   public SecurityRolesMetaData getSecurityRoles()
/*     */   {
/* 100 */     return this.securityRoles;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role")
/*     */   public void setSecurityRoles(SecurityRolesMetaData securityRoles)
/*     */   {
/* 112 */     if (securityRoles == null)
/* 113 */       throw new IllegalArgumentException("Null securityRoles");
/* 114 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ 
/*     */   public MethodPermissionsMetaData getMethodPermissions()
/*     */   {
/* 124 */     return this.methodPermissions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method-permission")
/*     */   public void setMethodPermissions(MethodPermissionsMetaData methodPermissions)
/*     */   {
/* 136 */     if (methodPermissions == null)
/* 137 */       throw new IllegalArgumentException("Null methodPermissions");
/* 138 */     this.methodPermissions = methodPermissions;
/*     */   }
/*     */ 
/*     */   public MethodPermissionsMetaData getMethodPermissionsByEjbName(String ejbName)
/*     */   {
/* 150 */     if (ejbName == null) {
/* 151 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 153 */     if (this.methodPermissions == null)
/* 154 */       return null;
/* 155 */     return this.methodPermissions.getMethodPermissionsByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public ContainerTransactionsMetaData getContainerTransactions()
/*     */   {
/* 165 */     return this.containerTransactions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="container-transaction")
/*     */   public void setContainerTransactions(ContainerTransactionsMetaData containerTransactions)
/*     */   {
/* 177 */     if (containerTransactions == null)
/* 178 */       throw new IllegalArgumentException("Null containerTransactions");
/* 179 */     this.containerTransactions = containerTransactions;
/*     */   }
/*     */ 
/*     */   public ContainerTransactionsMetaData getContainerTransactionsByEjbName(String ejbName)
/*     */   {
/* 191 */     if (ejbName == null) {
/* 192 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 194 */     if (this.containerTransactions == null)
/* 195 */       return null;
/* 196 */     return this.containerTransactions.getContainerTransactionsByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public InterceptorBindingsMetaData getInterceptorBindings()
/*     */   {
/* 206 */     return this.interceptorBindings;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="interceptor-binding", required=false)
/*     */   public void setInterceptorBindings(InterceptorBindingsMetaData interceptorBindings)
/*     */   {
/* 218 */     if (interceptorBindings == null)
/* 219 */       throw new IllegalArgumentException("Null interceptorBindings");
/* 220 */     this.interceptorBindings = interceptorBindings;
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeList()
/*     */   {
/* 230 */     return this.excludeList;
/*     */   }
/*     */ 
/*     */   public void setExcludeList(ExcludeListMetaData excludeList)
/*     */   {
/* 241 */     if (excludeList == null)
/* 242 */       throw new IllegalArgumentException("Null excludeList");
/* 243 */     this.excludeList = excludeList;
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeListByEjbName(String ejbName)
/*     */   {
/* 255 */     if (ejbName == null) {
/* 256 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 258 */     if (this.excludeList == null)
/* 259 */       return null;
/* 260 */     return this.excludeList.getExcludeListByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public ApplicationExceptionsMetaData getApplicationExceptions()
/*     */   {
/* 270 */     return this.applicationExceptions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="application-exception", required=false)
/*     */   public void setApplicationExceptions(ApplicationExceptionsMetaData applicationExceptions)
/*     */   {
/* 282 */     if (applicationExceptions == null)
/* 283 */       throw new IllegalArgumentException("Null applicationExceptions");
/* 284 */     this.applicationExceptions = applicationExceptions;
/*     */   }
/*     */ 
/*     */   public Set<String> getSecurityRolePrincipals(String name)
/*     */   {
/* 296 */     if (this.securityRoles == null)
/* 297 */       return null;
/* 298 */     SecurityRoleMetaData securityRole = (SecurityRoleMetaData)this.securityRoles.get(name);
/* 299 */     if (securityRole == null)
/* 300 */       return null;
/* 301 */     return securityRole.getPrincipals();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public SecurityRolesMetaData getSecurityRolesByPrincipal(String userName)
/*     */   {
/* 314 */     if (userName == null)
/* 315 */       throw new IllegalArgumentException("Null userName");
/* 316 */     if (this.securityRoles == null)
/* 317 */       return null;
/* 318 */     return this.securityRoles.getSecurityRolesByPrincipal(userName);
/*     */   }
/*     */ 
/*     */   public Set<String> getSecurityRoleNamesByPrincipal(String userName)
/*     */   {
/* 330 */     if (userName == null)
/* 331 */       throw new IllegalArgumentException("Null userName");
/* 332 */     if (this.securityRoles == null)
/* 333 */       return Collections.emptySet();
/* 334 */     return this.securityRoles.getSecurityRoleNamesByPrincipal(userName);
/*     */   }
/*     */ 
/*     */   public Map<String, Set<String>> getPrincipalVersusRolesMap()
/*     */   {
/* 343 */     if (this.securityRoles == null)
/* 344 */       return null;
/* 345 */     return this.securityRoles.getPrincipalVersusRolesMap();
/*     */   }
/*     */ 
/*     */   public MessageDestinationsMetaData getMessageDestinations()
/*     */   {
/* 355 */     return this.messageDestinations;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-destination")
/*     */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations)
/*     */   {
/* 367 */     if (messageDestinations == null)
/* 368 */       throw new IllegalArgumentException("Null messageDestinations");
/* 369 */     this.messageDestinations = messageDestinations;
/*     */   }
/*     */ 
/*     */   public MessageDestinationMetaData getMessageDestination(String name)
/*     */   {
/* 380 */     if (this.messageDestinations == null)
/* 381 */       return null;
/* 382 */     return (MessageDestinationMetaData)this.messageDestinations.get(name);
/*     */   }
/*     */ 
/*     */   public void merge(JBossAssemblyDescriptorMetaData override, AssemblyDescriptorMetaData original)
/*     */   {
/* 387 */     super.merge(override, original);
/* 388 */     JBossAssemblyDescriptorMetaData merged = this;
/*     */ 
/* 390 */     if ((override != null) && (override.applicationExceptions != null))
/* 391 */       setApplicationExceptions(override.applicationExceptions);
/* 392 */     else if ((original != null) && (original.getApplicationExceptions() != null))
/* 393 */       setApplicationExceptions(original.getApplicationExceptions());
/* 394 */     if ((override != null) && (override.containerTransactions != null))
/* 395 */       setContainerTransactions(override.containerTransactions);
/* 396 */     else if ((original != null) && (original.getContainerTransactions() != null))
/* 397 */       setContainerTransactions(original.getContainerTransactions());
/* 398 */     if ((override != null) && (override.excludeList != null))
/* 399 */       setExcludeList(override.excludeList);
/* 400 */     else if ((original != null) && (original.getExcludeList() != null))
/* 401 */       setExcludeList(original.getExcludeList());
/* 402 */     if ((override != null) && (override.interceptorBindings != null))
/* 403 */       setInterceptorBindings(override.interceptorBindings);
/* 404 */     else if ((original != null) && (original.getInterceptorBindings() != null))
/* 405 */       setInterceptorBindings(original.getInterceptorBindings());
/* 406 */     if ((override != null) && (override.methodPermissions != null))
/* 407 */       setMethodPermissions(override.methodPermissions);
/* 408 */     else if ((original != null) && (original.getMethodPermissions() != null)) {
/* 409 */       setMethodPermissions(original.getMethodPermissions());
/*     */     }
/* 411 */     SecurityRolesMetaData securityRolesMetaData = null;
/* 412 */     SecurityRolesMetaData jbossSecurityRolesMetaData = null;
/* 413 */     MessageDestinationsMetaData messageDestinationsMetaData = null;
/* 414 */     MessageDestinationsMetaData jbossMessageDestinationsMetaData = null;
/* 415 */     if (override != null)
/*     */     {
/* 417 */       jbossMessageDestinationsMetaData = override.getMessageDestinations();
/* 418 */       jbossSecurityRolesMetaData = override.getSecurityRoles();
/*     */     }
/* 420 */     if (original != null)
/*     */     {
/* 422 */       securityRolesMetaData = original.getSecurityRoles();
/* 423 */       messageDestinationsMetaData = original.getMessageDestinations();
/*     */     }
/*     */ 
/* 426 */     if ((jbossSecurityRolesMetaData == null) || (jbossSecurityRolesMetaData.isEmpty()))
/*     */     {
/* 428 */       if (securityRolesMetaData != null)
/* 429 */         merged.setSecurityRoles(securityRolesMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 433 */       SecurityRolesMetaData mergedSecurityRolesMetaData = new SecurityRolesMetaData();
/* 434 */       mergedSecurityRolesMetaData = (SecurityRolesMetaData)JavaEEMetaDataUtil.mergeJBossXml(mergedSecurityRolesMetaData, securityRolesMetaData, jbossSecurityRolesMetaData, "security-role", false);
/* 435 */       if ((mergedSecurityRolesMetaData != null) && (!mergedSecurityRolesMetaData.isEmpty())) {
/* 436 */         merged.setSecurityRoles(mergedSecurityRolesMetaData);
/*     */       }
/*     */     }
/* 439 */     if ((jbossMessageDestinationsMetaData == null) || (jbossMessageDestinationsMetaData.isEmpty()))
/*     */     {
/* 441 */       if ((messageDestinationsMetaData != null) && (jbossMessageDestinationsMetaData == null))
/* 442 */         merged.setMessageDestinations(messageDestinationsMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 446 */       MessageDestinationsMetaData mergedMessageDestinationsMetaData = new MessageDestinationsMetaData();
/* 447 */       mergedMessageDestinationsMetaData = (MessageDestinationsMetaData)JavaEEMetaDataUtil.mergeJBossXml(mergedMessageDestinationsMetaData, messageDestinationsMetaData, jbossMessageDestinationsMetaData, "message-destination", true);
/* 448 */       if ((mergedMessageDestinationsMetaData != null) && (!mergedMessageDestinationsMetaData.isEmpty()))
/* 449 */         merged.setMessageDestinations(mergedMessageDestinationsMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void merge(JBossAssemblyDescriptorMetaData override, IAssemblyDescriptorMetaData assembly)
/*     */   {
/* 461 */     AssemblyDescriptorMetaData original = (AssemblyDescriptorMetaData)assembly;
/* 462 */     merge(override, original);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData
 * JD-Core Version:    0.6.0
 */