/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.annotation.javaee.Descriptions;
/*     */ 
/*     */ public class ContainerConfigurationsMetaDataWrapper extends ContainerConfigurationsMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private ContainerConfigurationsMetaData primary;
/*     */   private ContainerConfigurationsMetaData defaults;
/*  42 */   private HashMap<String, ContainerConfigurationMetaData> merged = new HashMap();
/*     */ 
/*     */   ContainerConfigurationsMetaDataWrapper(ContainerConfigurationsMetaData primary, ContainerConfigurationsMetaData defaults)
/*     */   {
/*  52 */     this.primary = primary;
/*  53 */     this.defaults = defaults;
/*  54 */     if (defaults == null) {
/*  55 */       throw new IllegalStateException("defaults cannot be null");
/*     */     }
/*  57 */     for (String key : defaults.keySet())
/*     */     {
/*  59 */       ContainerConfigurationMetaData md = (ContainerConfigurationMetaData)defaults.get(key);
/*     */ 
/*  66 */       ContainerConfigurationMetaData parent = null;
/*  67 */       String extendsName = md.getExtendsName();
/*  68 */       if (extendsName != null)
/*     */       {
/*  71 */         parent = (ContainerConfigurationMetaData)this.merged.get(extendsName);
/*  72 */         if (parent == null)
/*  73 */           parent = (ContainerConfigurationMetaData)defaults.get(extendsName);
/*  74 */         if (parent == null) {
/*  75 */           throw new IllegalStateException("Failed to find parent configuration: " + extendsName + " among: " + defaults.keySet());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*  86 */       md = new ContainerConfigurationMetaDataWrapper(md, parent);
/*  87 */       this.merged.put(key, md);
/*     */     }
/*     */ 
/*  90 */     if (primary != null)
/*     */     {
/*  92 */       for (String key : primary.keySet())
/*     */       {
/*  94 */         ContainerConfigurationMetaData md = (ContainerConfigurationMetaData)primary.get(key);
/*     */ 
/* 101 */         ContainerConfigurationMetaData parent = null;
/*     */ 
/* 103 */         String extendsName = md.getExtendsName();
/* 104 */         if (extendsName != null)
/*     */         {
/* 106 */           parent = (ContainerConfigurationMetaData)primary.get(extendsName);
/* 107 */           if (parent == null)
/* 108 */             parent = (ContainerConfigurationMetaData)this.merged.get(extendsName);
/* 109 */           if (parent == null)
/* 110 */             parent = (ContainerConfigurationMetaData)defaults.get(extendsName);
/* 111 */           if (parent == null)
/*     */           {
/* 113 */             throw new IllegalStateException("Failed to find parent configuration: " + extendsName + " among defaults: " + defaults.keySet() + " config: " + primary.keySet());
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 119 */           parent = (ContainerConfigurationMetaData)this.merged.get(key);
/* 120 */           if (parent == null) {
/* 121 */             parent = (ContainerConfigurationMetaData)defaults.get(key);
/*     */           }
/*     */         }
/* 124 */         md = new ContainerConfigurationMetaDataWrapper(md, parent);
/* 125 */         this.merged.put(key, md);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean containsKey(String key)
/*     */   {
/* 132 */     return this.merged.containsKey(key);
/*     */   }
/*     */ 
/*     */   public ContainerConfigurationMetaData get(String key)
/*     */   {
/* 137 */     ContainerConfigurationMetaData ccmd = (ContainerConfigurationMetaData)this.merged.get(key);
/* 138 */     return ccmd;
/*     */   }
/*     */ 
/*     */   public Descriptions getDescriptions()
/*     */   {
/* 143 */     Descriptions descriptions = null;
/* 144 */     if (this.primary != null)
/* 145 */       descriptions = this.primary.getDescriptions();
/* 146 */     if (descriptions == null)
/* 147 */       descriptions = this.defaults.getDescriptions();
/* 148 */     return descriptions;
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/* 153 */     String id = this.primary != null ? this.primary.getId() : null;
/* 154 */     if (id == null)
/* 155 */       id = this.defaults.getId();
/* 156 */     return id;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 161 */     boolean isEmpty = this.merged.isEmpty();
/* 162 */     return isEmpty;
/*     */   }
/*     */ 
/*     */   public Iterator<ContainerConfigurationMetaData> iterator()
/*     */   {
/* 167 */     return this.merged.values().iterator();
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/* 172 */     return this.merged.keySet();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 179 */     return this.merged.size();
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 184 */     return this.merged.values().toArray();
/*     */   }
/*     */ 
/*     */   public <X> X[] toArray(X[] a)
/*     */   {
/* 189 */     return this.merged.values().toArray(a);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 194 */     return this.merged.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.ContainerConfigurationsMetaDataWrapper
 * JD-Core Version:    0.6.0
 */