/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @XmlType(name="container-configurationType", propOrder={"descriptions", "containerName", "extendsName", "callLogging", "invokerProxyBindingNames", "syncOnCommitOnly", "insertAfterEjbPostCreate", "ejbStoreOnClean", "storeNotFlushed", "instancePool", "instanceCache", "persistenceManager", "webClassLoader", "lockingPolicy", "commitOption", "optiondRefreshRate", "securityDomain", "clusterConfig", "depends", "containerPoolConf", "containerCacheConf", "containerInterceptors"})
/*     */ public class ContainerConfigurationMetaData extends NamedMetaDataWithDescriptions
/*     */ {
/*     */   public static final String CMP_2x = "Standard CMP 2.x EntityBean";
/*     */   public static final String CMP_1x = "Standard CMP EntityBean";
/*     */   public static final String BMP = "Standard BMP EntityBean";
/*     */   public static final String STATELESS = "Standard Stateless SessionBean";
/*     */   public static final String STATEFUL = "Standard Stateful SessionBean";
/*     */   public static final String MESSAGE_DRIVEN = "Standard Message Driven Bean";
/*     */   public static final String MESSAGE_INFLOW_DRIVEN = "Standard Message Inflow Driven Bean";
/*     */   public static final String CLUSTERED_CMP_2x = "Clustered CMP 2.x EntityBean";
/*     */   public static final String CLUSTERED_CMP_1x = "Clustered CMP EntityBean";
/*     */   public static final String CLUSTERED_BMP = "Clustered BMP EntityBean";
/*     */   public static final String CLUSTERED_STATEFUL = "Clustered Stateful SessionBean";
/*     */   public static final String CLUSTERED_STATELESS = "Clustered Stateless SessionBean";
/*     */   private static final long serialVersionUID = 5189417462407375043L;
/*     */   private String extendsName;
/*     */   private boolean callLogging;
/*     */   private Set<String> invokerProxyBindingNames;
/*     */   private boolean syncOnCommitOnly;
/*     */   private boolean insertAfterEjbPostCreate;
/*     */   private boolean ejbStoreOnClean;
/* 111 */   private boolean storeNotFlushed = true;
/*     */   private String instancePool;
/*     */   private String instanceCache;
/*     */   private String persistenceManager;
/*     */   private String webClassLoader;
/*     */   private String lockingPolicy;
/*     */   private Element containerPoolConf;
/*     */   private Element containerCacheConf;
/*     */   private Element containerInterceptorsConf;
/* 136 */   private CommitOption commitOption = CommitOption.A;
/*     */ 
/* 139 */   private long optiondRefreshRateMillis = 0L;
/*     */   private String securityDomain;
/*     */   private ClusterConfigMetaData clusterConfig;
/*     */   private Set<String> depends;
/*     */   private boolean commitOptionWasSet;
/*     */   private boolean callLoggingWasSet;
/*     */   private boolean ejbStoreOnCleanWasSet;
/*     */   private boolean insertAfterEjbPostCreateWasSet;
/*     */   private boolean storeNotFlushedWasSet;
/*     */   private boolean syncOnCommitOnlyWasSet;
/*     */ 
/*     */   public String getContainerName()
/*     */   {
/* 164 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setContainerName(String containerName)
/*     */   {
/* 175 */     setName(containerName);
/*     */   }
/*     */ 
/*     */   public String getExtendsName()
/*     */   {
/* 185 */     return this.extendsName;
/*     */   }
/*     */ 
/*     */   @XmlAttribute(name="extends")
/*     */   public void setExtendsName(String extendsName)
/*     */   {
/* 197 */     if (extendsName == null)
/* 198 */       throw new IllegalArgumentException("Null extendsName");
/* 199 */     this.extendsName = extendsName;
/*     */   }
/*     */ 
/*     */   public boolean isCallLogging()
/*     */   {
/* 209 */     return this.callLogging;
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean callLoggingWasSet() {
/* 214 */     return this.callLoggingWasSet;
/*     */   }
/*     */ 
/*     */   public void setCallLogging(boolean callLogging)
/*     */   {
/* 224 */     this.callLogging = callLogging;
/* 225 */     this.callLoggingWasSet = true;
/*     */   }
/*     */ 
/*     */   public boolean isSyncOnCommitOnly()
/*     */   {
/* 235 */     return this.syncOnCommitOnly;
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean syncOnCommitOnlyWasSet() {
/* 240 */     return this.syncOnCommitOnlyWasSet;
/*     */   }
/*     */ 
/*     */   public void setSyncOnCommitOnly(boolean syncOnCommitOnly)
/*     */   {
/* 250 */     this.syncOnCommitOnly = syncOnCommitOnly;
/* 251 */     this.syncOnCommitOnlyWasSet = true;
/*     */   }
/*     */ 
/*     */   public boolean isInsertAfterEjbPostCreate()
/*     */   {
/* 261 */     return this.insertAfterEjbPostCreate;
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean insertAfterEjbPostCreateWasSet() {
/* 266 */     return this.insertAfterEjbPostCreateWasSet;
/*     */   }
/*     */ 
/*     */   public void setInsertAfterEjbPostCreate(boolean insertAfterEjbPostCreate)
/*     */   {
/* 276 */     this.insertAfterEjbPostCreate = insertAfterEjbPostCreate;
/* 277 */     this.insertAfterEjbPostCreateWasSet = true;
/*     */   }
/*     */ 
/*     */   public boolean isEjbStoreOnClean()
/*     */   {
/* 287 */     return this.ejbStoreOnClean;
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean ejbStoreOnCleanWasSet() {
/* 292 */     return this.ejbStoreOnCleanWasSet;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="call-ejb-store-on-clean")
/*     */   public void setEjbStoreOnClean(boolean ejbStoreOnClean)
/*     */   {
/* 303 */     this.ejbStoreOnClean = ejbStoreOnClean;
/* 304 */     this.ejbStoreOnCleanWasSet = true;
/*     */   }
/*     */ 
/*     */   public boolean isStoreNotFlushed()
/*     */   {
/* 314 */     return this.storeNotFlushed;
/*     */   }
/*     */   @XmlTransient
/*     */   public boolean storeNotFlushedWasSet() {
/* 319 */     return this.storeNotFlushedWasSet;
/*     */   }
/*     */ 
/*     */   public void setStoreNotFlushed(boolean storeNotFlushed)
/*     */   {
/* 330 */     this.storeNotFlushed = storeNotFlushed;
/* 331 */     this.storeNotFlushedWasSet = true;
/*     */   }
/*     */ 
/*     */   public String getInstancePool()
/*     */   {
/* 341 */     return this.instancePool;
/*     */   }
/*     */ 
/*     */   public void setInstancePool(String instancePool)
/*     */   {
/* 352 */     if (instancePool == null)
/* 353 */       throw new IllegalArgumentException("Null instancePool");
/* 354 */     this.instancePool = instancePool;
/*     */   }
/*     */ 
/*     */   public String getInstanceCache()
/*     */   {
/* 364 */     return this.instanceCache;
/*     */   }
/*     */ 
/*     */   public void setInstanceCache(String instanceCache)
/*     */   {
/* 375 */     if (instanceCache == null)
/* 376 */       throw new IllegalArgumentException("Null instanceCache");
/* 377 */     this.instanceCache = instanceCache;
/*     */   }
/*     */ 
/*     */   public String getPersistenceManager()
/*     */   {
/* 387 */     return this.persistenceManager;
/*     */   }
/*     */ 
/*     */   public void setPersistenceManager(String persistenceManager)
/*     */   {
/* 398 */     if (persistenceManager == null)
/* 399 */       throw new IllegalArgumentException("Null persistenceManager");
/* 400 */     this.persistenceManager = persistenceManager;
/*     */   }
/*     */ 
/*     */   public String getWebClassLoader()
/*     */   {
/* 410 */     return this.webClassLoader;
/*     */   }
/*     */ 
/*     */   @XmlElement(defaultValue="org.jboss.web.WebClassLoader")
/*     */   public void setWebClassLoader(String webClassLoader)
/*     */   {
/* 422 */     if (webClassLoader == null)
/* 423 */       throw new IllegalArgumentException("Null webClassLoader");
/* 424 */     this.webClassLoader = webClassLoader;
/*     */   }
/*     */ 
/*     */   public String getLockingPolicy()
/*     */   {
/* 434 */     return this.lockingPolicy;
/*     */   }
/*     */ 
/*     */   @XmlElement(defaultValue="org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock")
/*     */   public void setLockingPolicy(String lockingPolicy)
/*     */   {
/* 446 */     if (lockingPolicy == null)
/* 447 */       throw new IllegalArgumentException("Null lockingPolicy");
/* 448 */     this.lockingPolicy = lockingPolicy;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 458 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 469 */     if (securityDomain == null)
/* 470 */       throw new IllegalArgumentException("Null securityDomain");
/* 471 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public CommitOption getCommitOption()
/*     */   {
/* 481 */     return this.commitOption;
/*     */   }
/*     */   @XmlTransient
/*     */   boolean commitOptionWasSet() {
/* 486 */     return this.commitOptionWasSet;
/*     */   }
/*     */ 
/*     */   public void setCommitOption(CommitOption commitOption)
/*     */   {
/* 497 */     if (commitOption == null)
/* 498 */       throw new IllegalArgumentException("Null commitOption");
/* 499 */     this.commitOption = commitOption;
/* 500 */     this.commitOptionWasSet = true;
/*     */   }
/*     */ 
/*     */   public long getOptiondRefreshRateMillis()
/*     */   {
/* 510 */     return this.optiondRefreshRateMillis;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public void setOptiondRefreshRateMillis(long optiondRefreshRateMillis)
/*     */   {
/* 522 */     if (optiondRefreshRateMillis <= 0L)
/* 523 */       throw new IllegalArgumentException("optionD-refresh-rate must be positive got " + optiondRefreshRateMillis);
/* 524 */     this.optiondRefreshRateMillis = optiondRefreshRateMillis;
/*     */   }
/*     */ 
/*     */   public int getOptiondRefreshRate()
/*     */   {
/* 534 */     return (int)this.optiondRefreshRateMillis / 1000;
/*     */   }
/*     */ 
/*     */   public void setOptiondRefreshRate(int optionDRefreshRateSeconds)
/*     */   {
/* 545 */     if (optionDRefreshRateSeconds <= 0)
/* 546 */       throw new IllegalArgumentException("optionD-refresh-rate must be positive got " + optionDRefreshRateSeconds);
/* 547 */     setOptiondRefreshRateMillis(optionDRefreshRateSeconds * 1000);
/*     */   }
/*     */ 
/*     */   public Element getContainerPoolConf()
/*     */   {
/* 553 */     return this.containerPoolConf;
/*     */   }
/*     */ 
/*     */   public void setContainerPoolConf(Element containerPoolConf)
/*     */   {
/* 558 */     this.containerPoolConf = containerPoolConf;
/*     */   }
/*     */ 
/*     */   public Element getContainerCacheConf()
/*     */   {
/* 563 */     return this.containerCacheConf;
/*     */   }
/*     */ 
/*     */   public void setContainerCacheConf(Element containerCacheConf)
/*     */   {
/* 568 */     this.containerCacheConf = containerCacheConf;
/*     */   }
/*     */ 
/*     */   public Element getContainerInterceptors()
/*     */   {
/* 573 */     return this.containerInterceptorsConf;
/*     */   }
/*     */ 
/*     */   public void setContainerInterceptors(Element containerInterceptorsConf)
/*     */   {
/* 578 */     this.containerInterceptorsConf = containerInterceptorsConf;
/*     */   }
/*     */ 
/*     */   public Set<String> getDepends()
/*     */   {
/* 588 */     return this.depends;
/*     */   }
/*     */ 
/*     */   public void setDepends(Set<String> depends)
/*     */   {
/* 600 */     if (depends == null)
/* 601 */       throw new IllegalArgumentException("Null depends");
/* 602 */     this.depends = depends;
/*     */   }
/*     */ 
/*     */   public Set<String> getInvokerProxyBindingNames()
/*     */   {
/* 612 */     return this.invokerProxyBindingNames;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="invoker-proxy-binding-name")
/*     */   public void setInvokerProxyBindingNames(Set<String> invokerProxyBindingNames)
/*     */   {
/* 624 */     if (invokerProxyBindingNames == null)
/* 625 */       throw new IllegalArgumentException("Null invokerProxyBindingNames");
/* 626 */     this.invokerProxyBindingNames = invokerProxyBindingNames;
/*     */   }
/*     */ 
/*     */   public String getDefaultInvokerName()
/*     */   {
/* 637 */     String name = null;
/* 638 */     if ((this.invokerProxyBindingNames != null) && (!this.invokerProxyBindingNames.isEmpty()))
/* 639 */       name = (String)this.invokerProxyBindingNames.iterator().next();
/* 640 */     return name;
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData getClusterConfig()
/*     */   {
/* 650 */     return this.clusterConfig;
/*     */   }
/*     */ 
/*     */   public void setClusterConfig(ClusterConfigMetaData clusterConfig)
/*     */   {
/* 661 */     if (clusterConfig == null)
/* 662 */       throw new IllegalArgumentException("Null clusterConfig");
/* 663 */     this.clusterConfig = clusterConfig;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData
 * JD-Core Version:    0.6.0
 */