/*    */ package org.jboss.metadata.ear.spec;
/*    */ 
/*    */ import javax.xml.bind.annotation.XmlElement;
/*    */ import javax.xml.bind.annotation.XmlTransient;
/*    */ import javax.xml.bind.annotation.XmlType;
/*    */ import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
/*    */ import org.jboss.metadata.javaee.support.NamedMetaData;
/*    */ import org.jboss.xb.annotations.JBossXmlChildren;
/*    */ 
/*    */ @XmlType(name="moduleType")
/*    */ @JBossXmlChildren({@org.jboss.xb.annotations.JBossXmlChild(name="connector", type=ConnectorModuleMetaData.class), @org.jboss.xb.annotations.JBossXmlChild(name="ejb", type=EjbModuleMetaData.class), @org.jboss.xb.annotations.JBossXmlChild(name="java", type=JavaModuleMetaData.class), @org.jboss.xb.annotations.JBossXmlChild(name="web", type=WebModuleMetaData.class), @org.jboss.xb.annotations.JBossXmlChild(name="service", type=ServiceModuleMetaData.class), @org.jboss.xb.annotations.JBossXmlChild(name="har", type=ServiceModuleMetaData.class)})
/*    */ public class ModuleMetaData extends NamedMetaData
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/*    */   private AbstractModule module;
/*    */   private String altDD;
/*    */ 
/*    */   public AbstractModule getValue()
/*    */   {
/* 59 */     return this.module;
/*    */   }
/*    */ 
/*    */   public void setValue(AbstractModule value) {
/* 63 */     this.module = value;
/*    */ 
/* 65 */     super.setName(value.getFileName());
/*    */   }
/*    */ 
/*    */   public String getAlternativeDD() {
/* 69 */     return this.altDD;
/*    */   }
/*    */   @XmlElement(name="alt-dd")
/*    */   public void setAlternativeDD(String altDD) {
/* 74 */     this.altDD = altDD;
/*    */   }
/*    */ 
/*    */   @XmlTransient
/*    */   public String getFileName() {
/* 80 */     String fileName = null;
/* 81 */     if (this.module != null)
/* 82 */       fileName = this.module.getFileName();
/* 83 */     return fileName;
/*    */   }
/*    */   @XmlTransient
/*    */   public ModuleType getType() {
/* 88 */     ModuleType type = ModuleType.Client;
/* 89 */     if ((this.module instanceof EjbModuleMetaData))
/* 90 */       type = ModuleType.Ejb;
/* 91 */     else if ((this.module instanceof ConnectorModuleMetaData))
/* 92 */       type = ModuleType.Connector;
/* 93 */     else if ((this.module instanceof JavaModuleMetaData))
/* 94 */       type = ModuleType.Client;
/* 95 */     else if ((this.module instanceof WebModuleMetaData))
/* 96 */       type = ModuleType.Web;
/* 97 */     else if ((this.module instanceof ServiceModuleMetaData))
/* 98 */       type = ModuleType.Service;
/* 99 */     return type;
/*    */   }
/*    */ 
/*    */   public static enum ModuleType
/*    */   {
/* 55 */     Connector, Client, Ejb, Service, Web;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ear.spec.ModuleMetaData
 * JD-Core Version:    0.6.0
 */