/*     */ package org.jboss.metadata.ear.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class EarMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private ModulesMetaData modules;
/*     */   private SecurityRolesMetaData securityRoles;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/*  60 */     this.dtdPublicId = publicId;
/*  61 */     this.dtdSystemId = systemId;
/*     */ 
/*  63 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("1.3")))
/*  64 */       setVersion("1.3");
/*  65 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("1.3")))
/*  66 */       setVersion("1.3");
/*  67 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("1.2")))
/*  68 */       setVersion("1.2");
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/*  77 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/*  86 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public boolean isEE5()
/*     */   {
/*  95 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEE14()
/*     */   {
/* 103 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEE13()
/*     */   {
/* 111 */     return (this.dtdPublicId != null) && (this.dtdPublicId.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN"));
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 121 */     return this.version;
/*     */   }
/*     */ 
/*     */   @XmlAttribute
/*     */   public void setVersion(String version)
/*     */   {
/* 133 */     if (version == null)
/* 134 */       throw new IllegalArgumentException("Null version");
/* 135 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public ModulesMetaData getModules()
/*     */   {
/* 145 */     return this.modules;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="module")
/*     */   public void setModules(ModulesMetaData modules)
/*     */   {
/* 154 */     this.modules = modules;
/*     */   }
/*     */ 
/*     */   public SecurityRolesMetaData getSecurityRoles()
/*     */   {
/* 162 */     return this.securityRoles;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role")
/*     */   public void setSecurityRoles(SecurityRolesMetaData securityRoles)
/*     */   {
/* 171 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ear.spec.EarMetaData
 * JD-Core Version:    0.6.0
 */