/*     */ package org.jboss.metadata.ear.jboss;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.ear.spec.Ear5xMetaData;
/*     */ import org.jboss.metadata.ear.spec.EarMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModulesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class JBossAppMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private String securityDomain;
/*     */   private LoaderRepositoryMetaData loaderRepository;
/*     */   private String unauthenticatedPrincipal;
/*     */   private ModulesMetaData modules;
/*     */   private SecurityRolesMetaData securityRoles;
/*     */   private String libraryDirectory;
/*     */   private String jmxName;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/*  68 */     this.dtdPublicId = publicId;
/*  69 */     this.dtdSystemId = systemId;
/*     */ 
/*  71 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.0")))
/*  72 */       setVersion("3.0");
/*  73 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.2")))
/*  74 */       setVersion("3.2");
/*  75 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("4.0")))
/*  76 */       setVersion("4.0");
/*  77 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("4.2")))
/*  78 */       setVersion("4.2");
/*  79 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("5.0")))
/*  80 */       setVersion("5.0");
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/*  89 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/*  98 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public LoaderRepositoryMetaData getLoaderRepository()
/*     */   {
/* 103 */     return this.loaderRepository;
/*     */   }
/*     */ 
/*     */   public void setLoaderRepository(LoaderRepositoryMetaData loaderRepository) {
/* 107 */     this.loaderRepository = loaderRepository;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain() {
/* 111 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain) {
/* 115 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public SecurityRolesMetaData getSecurityRoles() {
/* 119 */     return this.securityRoles;
/*     */   }
/*     */   @XmlElement(name="security-role")
/*     */   public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
/* 124 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ 
/*     */   public String getUnauthenticatedPrincipal() {
/* 128 */     return this.unauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public void setUnauthenticatedPrincipal(String unauthenticatedPrincipal) {
/* 132 */     this.unauthenticatedPrincipal = unauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public String getVersion() {
/* 136 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version) {
/* 140 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getLibraryDirectory()
/*     */   {
/* 145 */     return this.libraryDirectory;
/*     */   }
/*     */ 
/*     */   public void setLibraryDirectory(String libraryDirectory) {
/* 149 */     this.libraryDirectory = libraryDirectory;
/*     */   }
/*     */ 
/*     */   public String getJmxName()
/*     */   {
/* 154 */     return this.jmxName;
/*     */   }
/*     */ 
/*     */   public void setJmxName(String jmxName) {
/* 158 */     this.jmxName = jmxName;
/*     */   }
/*     */ 
/*     */   public ModulesMetaData getModules()
/*     */   {
/* 167 */     return this.modules;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="module")
/*     */   public void setModules(ModulesMetaData modules)
/*     */   {
/* 176 */     this.modules = modules;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public synchronized ModuleMetaData getModule(String name) {
/* 182 */     return (ModuleMetaData)this.modules.get(name);
/*     */   }
/*     */ 
/*     */   public void merge(JBossAppMetaData override, EarMetaData original)
/*     */   {
/* 187 */     super.merge(override, original);
/* 188 */     Ear5xMetaData original5x = null;
/* 189 */     if ((original instanceof Ear5xMetaData)) {
/* 190 */       original5x = (Ear5xMetaData)original;
/*     */     }
/* 192 */     if (override != null)
/*     */     {
/* 194 */       if (override.dtdPublicId != null)
/* 195 */         this.dtdPublicId = override.dtdPublicId;
/* 196 */       if (override.dtdSystemId != null)
/* 197 */         this.dtdSystemId = override.dtdSystemId;
/* 198 */       if (override.version != null)
/* 199 */         this.version = override.version;
/* 200 */       if (override.securityDomain != null)
/* 201 */         setSecurityDomain(override.securityDomain);
/* 202 */       if (override.loaderRepository != null)
/* 203 */         setLoaderRepository(override.loaderRepository);
/* 204 */       if (override.unauthenticatedPrincipal != null)
/* 205 */         setUnauthenticatedPrincipal(override.unauthenticatedPrincipal);
/* 206 */       if (override.unauthenticatedPrincipal != null)
/* 207 */         setUnauthenticatedPrincipal(override.unauthenticatedPrincipal);
/* 208 */       if (override.libraryDirectory != null)
/* 209 */         setLibraryDirectory(override.libraryDirectory);
/* 210 */       else if ((original5x != null) && (original5x.getLibraryDirectory() != null))
/* 211 */         setLibraryDirectory(original5x.getLibraryDirectory());
/* 212 */       if (override.jmxName != null)
/* 213 */         setJmxName(override.jmxName);
/*     */     }
/* 215 */     else if ((original5x != null) && (original5x.getLibraryDirectory() != null)) {
/* 216 */       setLibraryDirectory(original5x.getLibraryDirectory());
/*     */     }
/* 218 */     if (this.modules == null)
/* 219 */       this.modules = new ModulesMetaData();
/* 220 */     ModulesMetaData overrideModules = null;
/* 221 */     ModulesMetaData originalModules = null;
/* 222 */     if (override != null)
/* 223 */       overrideModules = override.getModules();
/* 224 */     if (original != null)
/* 225 */       originalModules = original.getModules();
/* 226 */     this.modules.merge(overrideModules, originalModules);
/*     */ 
/* 228 */     SecurityRolesMetaData securityRolesMetaData = null;
/* 229 */     SecurityRolesMetaData overrideSecurityRolesMetaData = null;
/* 230 */     if (original != null)
/* 231 */       securityRolesMetaData = original.getSecurityRoles();
/* 232 */     if (override != null)
/* 233 */       overrideSecurityRolesMetaData = override.getSecurityRoles();
/* 234 */     if (this.securityRoles == null)
/* 235 */       this.securityRoles = new SecurityRolesMetaData();
/* 236 */     this.securityRoles.merge(overrideSecurityRolesMetaData, securityRolesMetaData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ear.jboss.JBossAppMetaData
 * JD-Core Version:    0.6.0
 */