/*     */ package org.jboss.metadata.client.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class ApplicationClientMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */   implements RemoteEnvironment
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private RemoteEnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private String callbackHandler;
/*     */   private boolean metadataComplete;
/*     */   private MessageDestinationsMetaData messageDestinations;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/*  85 */     this.dtdPublicId = publicId;
/*  86 */     this.dtdSystemId = systemId;
/*     */ 
/*  88 */     if (this.dtdPublicId != null)
/*     */     {
/*  90 */       if (this.dtdPublicId.contains("1.2"))
/*  91 */         setVersion("1.2");
/*  92 */       if (this.dtdPublicId.contains("1.3"))
/*  93 */         setVersion("1.3");
/*     */     }
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/* 103 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/* 112 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 118 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version) {
/* 122 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public boolean isMetadataComplete()
/*     */   {
/* 128 */     return this.metadataComplete;
/*     */   }
/*     */   @XmlAttribute(name="metadata-complete")
/*     */   public void setMetadataComplete(boolean metadataComplete) {
/* 133 */     this.metadataComplete = metadataComplete;
/*     */   }
/*     */ 
/*     */   public String getCallbackHandler()
/*     */   {
/* 138 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*     */   {
/* 143 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*     */   }
/*     */ 
/*     */   public EJBReferencesMetaData getEjbReferences()
/*     */   {
/* 148 */     if (this.jndiEnvironmentRefsGroup != null)
/* 149 */       return this.jndiEnvironmentRefsGroup.getEjbReferences();
/* 150 */     return null;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/* 156 */     AnnotatedEJBReferencesMetaData refs = null;
/* 157 */     if (this.jndiEnvironmentRefsGroup != null)
/* 158 */       refs = this.jndiEnvironmentRefsGroup.getAnnotatedEjbReferences();
/* 159 */     return refs;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*     */   {
/* 164 */     if (this.jndiEnvironmentRefsGroup != null)
/* 165 */       return this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/* 166 */     return null;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*     */   {
/* 171 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*     */   }
/*     */ 
/*     */   public RemoteEnvironmentRefsGroupMetaData getJndiEnvironmentRefsGroup()
/*     */   {
/* 176 */     return this.jndiEnvironmentRefsGroup;
/*     */   }
/*     */ 
/*     */   public MessageDestinationMetaData getMessageDestinationByName(String name)
/*     */   {
/* 187 */     if (this.messageDestinations == null)
/* 188 */       return null;
/* 189 */     return (MessageDestinationMetaData)this.messageDestinations.get(name);
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*     */   {
/* 194 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*     */   {
/* 199 */     if (this.jndiEnvironmentRefsGroup != null)
/* 200 */       return this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/* 201 */     return null;
/*     */   }
/*     */ 
/*     */   public MessageDestinationsMetaData getMessageDestinations()
/*     */   {
/* 211 */     return this.messageDestinations;
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*     */   {
/* 216 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*     */   {
/* 221 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*     */   {
/* 226 */     if (this.jndiEnvironmentRefsGroup != null)
/* 227 */       return this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/* 228 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostConstructs()
/*     */   {
/* 233 */     if (this.jndiEnvironmentRefsGroup != null)
/* 234 */       return this.jndiEnvironmentRefsGroup.getPostConstructs();
/* 235 */     return null;
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPreDestroys()
/*     */   {
/* 240 */     if (this.jndiEnvironmentRefsGroup != null)
/* 241 */       return this.jndiEnvironmentRefsGroup.getPreDestroys();
/* 242 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*     */   {
/* 247 */     if (this.jndiEnvironmentRefsGroup != null)
/* 248 */       return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/* 249 */     return null;
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*     */   {
/* 254 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, getServiceReferences());
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences() {
/* 258 */     if (this.jndiEnvironmentRefsGroup != null)
/* 259 */       return this.jndiEnvironmentRefsGroup.getServiceReferences();
/* 260 */     return null;
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*     */   {
/* 265 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*     */   }
/*     */ 
/*     */   public ResourceReferencesMetaData getResourceReferences()
/*     */   {
/* 270 */     if (this.jndiEnvironmentRefsGroup != null)
/* 271 */       return this.jndiEnvironmentRefsGroup.getResourceReferences();
/* 272 */     return null;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(String callbackHandler)
/*     */   {
/* 277 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setJndiEnvironmentRefsGroup(RemoteEnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup)
/*     */   {
/* 282 */     if (jndiEnvironmentRefsGroup == null)
/* 283 */       throw new IllegalArgumentException("Null jndiEnvironmentRefsGroup");
/* 284 */     this.jndiEnvironmentRefsGroup = jndiEnvironmentRefsGroup;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-destination")
/*     */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations)
/*     */   {
/* 296 */     if (messageDestinations == null)
/* 297 */       throw new IllegalArgumentException("Null messageDestinations");
/* 298 */     this.messageDestinations = messageDestinations;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.client.spec.ApplicationClientMetaData
 * JD-Core Version:    0.6.0
 */