/*     */ package org.jboss.metadata.client.jboss;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.client.spec.ApplicationClientMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImpl;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class JBossClientMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */   implements RemoteEnvironment
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String jndiName;
/*     */   private JBossEnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*     */   private List<String> depends;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private String callbackHandler;
/*     */   private boolean metaDataComplete;
/*     */   private MessageDestinationsMetaData messageDestinations;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/* 100 */     this.dtdPublicId = publicId;
/* 101 */     this.dtdSystemId = systemId;
/*     */ 
/* 103 */     if (this.dtdPublicId != null)
/*     */     {
/* 105 */       if (this.dtdPublicId.contains("3.0"))
/* 106 */         setVersion("3.0");
/* 107 */       if (this.dtdPublicId.contains("3.2"))
/* 108 */         setVersion("3.2");
/* 109 */       if (this.dtdPublicId.contains("4.0"))
/* 110 */         setVersion("4.0");
/* 111 */       if (this.dtdPublicId.contains("4.2"))
/* 112 */         setVersion("4.2");
/* 113 */       if (this.dtdPublicId.contains("5.0"))
/* 114 */         setVersion("5.0");
/*     */     }
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/* 124 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/* 133 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 139 */     return this.version;
/*     */   }
/*     */   @XmlAttribute(name="version")
/*     */   public void setVersion(String version) {
/* 144 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public boolean isMetadataComplete()
/*     */   {
/* 150 */     return this.metaDataComplete;
/*     */   }
/*     */ 
/*     */   public void setMetadataComplete(boolean metaDataComplete) {
/* 154 */     this.metaDataComplete = metaDataComplete;
/*     */   }
/*     */ 
/*     */   public String getCallbackHandler() {
/* 158 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(String callbackHandler) {
/* 162 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   public List<String> getDepends()
/*     */   {
/* 167 */     return this.depends;
/*     */   }
/*     */ 
/*     */   public void setDepends(List<String> depends) {
/* 171 */     this.depends = depends;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 176 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName) {
/* 180 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public Environment getJndiEnvironmentRefsGroup()
/*     */   {
/* 185 */     return this.jndiEnvironmentRefsGroup;
/*     */   }
/*     */   @XmlElement(type=JBossEnvironmentRefsGroupMetaData.class)
/*     */   public void setJndiEnvironmentRefsGroup(Environment jndiEnvironmentRefsGroup) {
/* 190 */     if (jndiEnvironmentRefsGroup == null)
/* 191 */       throw new IllegalArgumentException("jndiEnvironmentRefsGroup is null");
/* 192 */     this.jndiEnvironmentRefsGroup = ((JBossEnvironmentRefsGroupMetaData)jndiEnvironmentRefsGroup);
/*     */   }
/*     */ 
/*     */   public MessageDestinationsMetaData getMessageDestinations()
/*     */   {
/* 199 */     return this.messageDestinations;
/*     */   }
/*     */ 
/*     */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations)
/*     */   {
/* 204 */     this.messageDestinations = messageDestinations;
/*     */   }
/*     */ 
/*     */   public EJBReferenceMetaData getEjbReferenceByName(String name) {
/* 208 */     if (this.jndiEnvironmentRefsGroup == null)
/* 209 */       return null;
/* 210 */     return this.jndiEnvironmentRefsGroup.getEjbReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public EJBReferencesMetaData getEjbReferences()
/*     */   {
/* 215 */     if (this.jndiEnvironmentRefsGroup == null)
/* 216 */       return null;
/* 217 */     return this.jndiEnvironmentRefsGroup.getEjbReferences();
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences() {
/* 223 */     AnnotatedEJBReferencesMetaData refs = null;
/* 224 */     if (this.jndiEnvironmentRefsGroup != null)
/* 225 */       refs = this.jndiEnvironmentRefsGroup.getAnnotatedEjbReferences();
/* 226 */     return refs;
/*     */   }
/*     */ 
/*     */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*     */   {
/* 231 */     if (this.jndiEnvironmentRefsGroup == null)
/* 232 */       return null;
/* 233 */     return this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/*     */   }
/*     */ 
/*     */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*     */   {
/* 238 */     if (this.jndiEnvironmentRefsGroup == null)
/* 239 */       return null;
/* 240 */     return this.jndiEnvironmentRefsGroup.getEnvironmentEntryByName(name);
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*     */   {
/* 245 */     if (this.jndiEnvironmentRefsGroup == null)
/* 246 */       return null;
/* 247 */     return this.jndiEnvironmentRefsGroup.getMessageDestinationReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*     */   {
/* 252 */     if (this.jndiEnvironmentRefsGroup == null)
/* 253 */       return null;
/* 254 */     return this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*     */   {
/* 259 */     if (this.jndiEnvironmentRefsGroup == null)
/* 260 */       return null;
/* 261 */     return this.jndiEnvironmentRefsGroup.getPersistenceUnitReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*     */   {
/* 266 */     if (this.jndiEnvironmentRefsGroup == null)
/* 267 */       return null;
/* 268 */     return this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPostConstructs()
/*     */   {
/* 273 */     if (this.jndiEnvironmentRefsGroup == null)
/* 274 */       return null;
/* 275 */     return this.jndiEnvironmentRefsGroup.getPostConstructs();
/*     */   }
/*     */ 
/*     */   public LifecycleCallbacksMetaData getPreDestroys()
/*     */   {
/* 280 */     if (this.jndiEnvironmentRefsGroup == null)
/* 281 */       return null;
/* 282 */     return this.jndiEnvironmentRefsGroup.getPreDestroys();
/*     */   }
/*     */ 
/*     */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*     */   {
/* 287 */     if (this.jndiEnvironmentRefsGroup == null)
/* 288 */       return null;
/* 289 */     return this.jndiEnvironmentRefsGroup.getServiceReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public ServiceReferencesMetaData getServiceReferences()
/*     */   {
/* 294 */     if (this.jndiEnvironmentRefsGroup == null)
/* 295 */       return null;
/* 296 */     return this.jndiEnvironmentRefsGroup.getServiceReferences();
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*     */   {
/* 301 */     if (this.jndiEnvironmentRefsGroup == null)
/* 302 */       return null;
/* 303 */     return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*     */   {
/* 308 */     if (this.jndiEnvironmentRefsGroup == null)
/* 309 */       return null;
/* 310 */     return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/*     */   }
/*     */ 
/*     */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*     */   {
/* 315 */     if (this.jndiEnvironmentRefsGroup == null)
/* 316 */       return null;
/* 317 */     return this.jndiEnvironmentRefsGroup.getResourceReferenceByName(name);
/*     */   }
/*     */ 
/*     */   public ResourceReferencesMetaData getResourceReferences()
/*     */   {
/* 322 */     if (this.jndiEnvironmentRefsGroup == null)
/* 323 */       return null;
/* 324 */     return this.jndiEnvironmentRefsGroup.getResourceReferences();
/*     */   }
/*     */ 
/*     */   public void merge(IdMetaData override, IdMetaData original)
/*     */   {
/* 330 */     throw new RuntimeException("wrong merge method called");
/*     */   }
/*     */ 
/*     */   public void merge(IdMetaDataImpl override, IdMetaDataImpl original)
/*     */   {
/* 336 */     throw new RuntimeException("wrong merge method called");
/*     */   }
/*     */ 
/*     */   public void merge(JBossClientMetaData jboss, ApplicationClientMetaData spec, boolean mustOverride)
/*     */   {
/* 346 */     super.merge(jboss, spec);
/*     */ 
/* 348 */     RemoteEnvironmentRefsGroupMetaData jbossEnv = null;
/* 349 */     RemoteEnvironmentRefsGroupMetaData specEnv = null;
/* 350 */     MessageDestinationsMetaData jbossMsgs = null;
/* 351 */     MessageDestinationsMetaData specMsgs = null;
/* 352 */     if (jboss != null)
/*     */     {
/* 354 */       if (jboss.depends != null)
/* 355 */         setDepends(jboss.depends);
/* 356 */       if (jboss.jndiName != null)
/* 357 */         setJndiName(jboss.jndiName);
/* 358 */       else if ((jboss.getDescriptionGroup() != null) && (jboss.getDescriptionGroup().getDisplayName() != null))
/* 359 */         setJndiName(jboss.getDescriptionGroup().getDisplayName());
/* 360 */       if (jboss.dtdPublicId != null)
/* 361 */         this.dtdPublicId = jboss.dtdPublicId;
/* 362 */       if (jboss.dtdSystemId != null)
/* 363 */         this.dtdSystemId = jboss.dtdSystemId;
/* 364 */       if (jboss.version != null)
/* 365 */         this.version = jboss.version;
/* 366 */       jbossEnv = jboss.jndiEnvironmentRefsGroup;
/* 367 */       jbossMsgs = jboss.getMessageDestinations();
/*     */     }
/* 369 */     if (spec != null)
/*     */     {
/* 371 */       specEnv = spec.getJndiEnvironmentRefsGroup();
/* 372 */       specMsgs = spec.getMessageDestinations();
/* 373 */       if ((this.jndiName == null) && (spec.getDescriptionGroup() != null) && (spec.getDescriptionGroup().getDisplayName() != null))
/* 374 */         setJndiName(spec.getDescriptionGroup().getDisplayName());
/* 375 */       this.metaDataComplete = spec.isMetadataComplete();
/* 376 */       specMsgs = spec.getMessageDestinations();
/*     */     }
/*     */ 
/* 379 */     if ((jboss != null) && (jboss.callbackHandler != null))
/* 380 */       setCallbackHandler(jboss.callbackHandler);
/* 381 */     else if ((spec != null) && (spec.getCallbackHandler() != null)) {
/* 382 */       setCallbackHandler(spec.getCallbackHandler());
/*     */     }
/* 384 */     if (this.jndiEnvironmentRefsGroup == null)
/* 385 */       this.jndiEnvironmentRefsGroup = new JBossEnvironmentRefsGroupMetaData();
/* 386 */     this.jndiEnvironmentRefsGroup.merge(jbossEnv, specEnv, "jboss-client.xml", "application-client.xml", false);
/*     */ 
/* 389 */     ResourceEnvironmentReferencesMetaData resEnvRefs = this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/*     */ 
/* 392 */     this.messageDestinations = MessageDestinationsMetaData.merge(jbossMsgs, specMsgs, "jboss-client.xml", "application-client.xml");
/*     */ 
/* 397 */     if ((this.messageDestinations != null) && (resEnvRefs != null))
/*     */     {
/* 399 */       for (MessageDestinationMetaData md : this.messageDestinations)
/*     */       {
/* 401 */         if (md.getMappedName() == null)
/*     */         {
/* 403 */           ResourceEnvironmentReferenceMetaData ref = (ResourceEnvironmentReferenceMetaData)resEnvRefs.get(md.getMessageDestinationName());
/* 404 */           if (ref != null) {
/* 405 */             md.setMappedName(ref.getMappedName());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 414 */     HashMap resourceEnvReferenceLinks = new HashMap();
/*     */     ResourceEnvironmentReferencesMetaData specEnvRefs;
/*     */     MessageDestinationReferencesMetaData msgRefs;
/* 426 */     if (specEnv != null)
/*     */     {
/* 428 */       specEnvRefs = specEnv.getResourceEnvironmentReferences();
/* 429 */       MessageDestinationReferencesMetaData specMsgRefs = specEnv.getMessageDestinationReferences();
/* 430 */       msgRefs = this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/* 431 */       if (msgRefs == null)
/*     */       {
/* 433 */         msgRefs = new MessageDestinationReferencesMetaData();
/* 434 */         this.jndiEnvironmentRefsGroup.setMessageDestinationReferences(msgRefs);
/*     */       }
/* 436 */       if (specMsgRefs != null) {
/* 437 */         for (MessageDestinationReferenceMetaData ref : specMsgRefs)
/*     */         {
/* 439 */           ref = (MessageDestinationReferenceMetaData)ref.clone();
/* 440 */           String link = ref.getLink();
/* 441 */           if (link != null)
/*     */           {
/* 443 */             ArrayList linkedRefs = (ArrayList)resourceEnvReferenceLinks.get(link);
/* 444 */             if (linkedRefs == null)
/*     */             {
/* 446 */               linkedRefs = new ArrayList();
/* 447 */               resourceEnvReferenceLinks.put(link, linkedRefs);
/*     */             }
/* 449 */             linkedRefs.add(ref);
/*     */           }
/* 451 */           msgRefs.add(ref);
/*     */         }
/*     */       }
/*     */ 
/* 455 */       if ((resEnvRefs != null) && (specEnvRefs != null))
/* 456 */         for (ResourceEnvironmentReferenceMetaData ref : resEnvRefs)
/*     */         {
/* 458 */           String resRefName = ref.getResourceEnvRefName();
/* 459 */           ResourceEnvironmentReferenceMetaData specRef = (ResourceEnvironmentReferenceMetaData)specEnvRefs.get(resRefName);
/* 460 */           if (specRef == null)
/*     */           {
/* 463 */             ArrayList linkedRefs = (ArrayList)resourceEnvReferenceLinks.get(resRefName);
/* 464 */             if (linkedRefs != null)
/*     */             {
/* 466 */               for (MessageDestinationReferenceMetaData mref : linkedRefs)
/*     */               {
/* 468 */                 if (mref.getIgnoreDependency() != null)
/* 469 */                   ref.setIgnoreDependency(mref.getIgnoreDependency());
/* 470 */                 if (mref.getType() != null)
/* 471 */                   ref.setType(mref.getType());
/* 472 */                 mref.setMappedName(ref.getMappedName());
/*     */               }
/*     */             }
/* 475 */             else if (msgRefs.containsKey(resRefName))
/*     */             {
/* 477 */               MessageDestinationReferenceMetaData mref = (MessageDestinationReferenceMetaData)msgRefs.get(resRefName);
/* 478 */               mref.setMappedName(ref.getMappedName());
/*     */             }
/*     */             else
/*     */             {
/* 482 */               throw new IllegalStateException("resource-env-ref " + resRefName + " found in jboss-client.xml but not in application-client.xml");
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 488 */             ref.merge(null, specRef);
/*     */           }
/*     */         }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.client.jboss.JBossClientMetaData
 * JD-Core Version:    0.6.0
 */