/*    */ package org.jboss.metadata.annotation.creator.web;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
/*    */ import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*    */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*    */ import org.jboss.metadata.web.spec.ServletsMetaData;
/*    */ import org.jboss.metadata.web.spec.WebMetaData;
/*    */ 
/*    */ public class WebComponentProcessor extends AbstractComponentProcessor<WebMetaData>
/*    */   implements Processor<WebMetaData, Class<?>>
/*    */ {
/*    */   public WebComponentProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 47 */     super(finder);
/*    */ 
/* 49 */     addTypeProcessor(new RunAsProcessor(finder));
/*    */ 
/* 51 */     addTypeProcessor(new DeclareRolesProcessor(finder));
/*    */   }
/*    */ 
/*    */   public void process(WebMetaData metaData, Class<?> type)
/*    */   {
/* 57 */     super.process(metaData, type);
/*    */ 
/* 59 */     EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
/* 60 */     super.process(env, type);
/* 61 */     metaData.setJndiEnvironmentRefsGroup(env);
/*    */ 
/* 64 */     ServletsMetaData servlets = metaData.getServlets();
/* 65 */     if (servlets == null)
/*    */     {
/* 67 */       servlets = new ServletsMetaData();
/* 68 */       metaData.setServlets(servlets);
/*    */     }
/* 70 */     super.processClass(servlets, type);
/*    */ 
/* 72 */     SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
/* 73 */     if (securityRoles == null)
/*    */     {
/* 75 */       securityRoles = new SecurityRolesMetaData();
/* 76 */       metaData.setSecurityRoles(securityRoles);
/*    */     }
/* 78 */     super.processClass(securityRoles, type);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.web.WebComponentProcessor
 * JD-Core Version:    0.6.0
 */