/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.HashSet;
/*    */ import javax.annotation.security.RolesAllowed;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodsMetaData;
/*    */ 
/*    */ public class RolesAllowedProcessor<T extends AnnotatedElement> extends AbstractFinderUser
/*    */   implements Processor<MethodPermissionsMetaData, T>
/*    */ {
/*    */   public RolesAllowedProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 53 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(MethodPermissionsMetaData metaData, T type)
/*    */   {
/* 59 */     RolesAllowed allowed = (RolesAllowed)this.finder.getAnnotation(type, RolesAllowed.class);
/* 60 */     if (allowed == null) {
/* 61 */       return;
/*    */     }
/* 63 */     Method method = null;
/* 64 */     if ((type instanceof Method)) {
/* 65 */       method = (Method)type;
/*    */     }
/* 67 */     String ejbName = (String)EjbNameThreadLocal.ejbName.get();
/* 68 */     MethodMetaData mmd = ProcessorUtils.createMethod(ejbName, method);
/* 69 */     MethodPermissionMetaData perm = new MethodPermissionMetaData();
/* 70 */     MethodsMetaData methods = perm.getMethods();
/* 71 */     if (methods == null)
/*    */     {
/* 73 */       methods = new MethodsMetaData();
/* 74 */       perm.setMethods(methods);
/*    */     }
/* 76 */     HashSet roles = new HashSet();
/* 77 */     for (String role : allowed.value())
/* 78 */       roles.add(role);
/* 79 */     perm.setRoles(roles);
/* 80 */     Descriptions descriptions = ProcessorUtils.getDescription("@RolesAllowed for: " + type);
/* 81 */     mmd.setDescriptions(descriptions);
/* 82 */     methods.add(mmd);
/* 83 */     metaData.add(perm);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.RolesAllowedProcessor
 * JD-Core Version:    0.6.0
 */