/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.Remove;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*    */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*    */ import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
/*    */ import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionType;
/*    */ 
/*    */ public class RemoveProcessor extends AbstractFinderUser
/*    */   implements Creator<Method, RemoveMethodMetaData>, Processor<SessionBeanMetaData, Method>
/*    */ {
/*    */   public RemoveProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 53 */     super(finder);
/*    */   }
/*    */ 
/*    */   public RemoveMethodMetaData create(Method method)
/*    */   {
/* 58 */     Remove remove = (Remove)this.finder.getAnnotation(method, Remove.class);
/* 59 */     if (remove == null) {
/* 60 */       return null;
/*    */     }
/* 62 */     RemoveMethodMetaData metaData = new RemoveMethodMetaData();
/* 63 */     NamedMethodMetaData beanMethod = new NamedMethodMetaData();
/* 64 */     beanMethod.setMethodName(method.getName());
/* 65 */     metaData.setBeanMethod(beanMethod);
/* 66 */     metaData.setRetainIfException(remove.retainIfException());
/*    */ 
/* 68 */     MethodParametersMetaData methodParams = ProcessorUtils.getMethodParameters(method);
/* 69 */     beanMethod.setMethodParams(methodParams);
/*    */ 
/* 71 */     return metaData;
/*    */   }
/*    */ 
/*    */   public void process(SessionBeanMetaData bean, Method method)
/*    */   {
/* 76 */     RemoveMethodMetaData removeMethod = create(method);
/* 77 */     if (removeMethod == null) {
/* 78 */       return;
/*    */     }
/* 80 */     if (bean.getSessionType() != SessionType.Stateful) {
/* 81 */       throw new IllegalArgumentException("Remove annotation is only valid on a stateful bean");
/*    */     }
/* 83 */     if (bean.getRemoveMethods() == null) {
/* 84 */       bean.setRemoveMethods(new RemoveMethodsMetaData());
/*    */     }
/* 86 */     bean.getRemoveMethods().add(removeMethod);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.RemoveProcessor
 * JD-Core Version:    0.6.0
 */