/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.annotation.security.PermitAll;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodsMetaData;
/*    */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*    */ 
/*    */ public class PermitAllProcessor<T extends AnnotatedElement> extends AbstractFinderUser
/*    */   implements Processor<MethodPermissionsMetaData, T>
/*    */ {
/*    */   public PermitAllProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 52 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(MethodPermissionsMetaData metaData, T type)
/*    */   {
/* 58 */     PermitAll permit = (PermitAll)this.finder.getAnnotation(type, PermitAll.class);
/* 59 */     if (permit == null) {
/* 60 */       return;
/*    */     }
/* 62 */     Method method = null;
/* 63 */     if ((type instanceof Method)) {
/* 64 */       method = (Method)type;
/*    */     }
/* 66 */     String ejbName = (String)EjbNameThreadLocal.ejbName.get();
/* 67 */     MethodMetaData mmd = ProcessorUtils.createMethod(ejbName, method);
/* 68 */     MethodPermissionMetaData perm = new MethodPermissionMetaData();
/* 69 */     MethodsMetaData methods = perm.getMethods();
/* 70 */     if (methods == null)
/*    */     {
/* 72 */       methods = new MethodsMetaData();
/* 73 */       perm.setMethods(methods);
/*    */     }
/* 75 */     perm.setUnchecked(new EmptyMetaData());
/* 76 */     Descriptions descriptions = ProcessorUtils.getDescription("@PermitAll for: " + type);
/* 77 */     mmd.setDescriptions(descriptions);
/* 78 */     methods.add(mmd);
/* 79 */     metaData.add(perm);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.PermitAllProcessor
 * JD-Core Version:    0.6.0
 */