/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.interceptor.ExcludeClassInterceptors;
/*    */ import javax.interceptor.ExcludeDefaultInterceptors;
/*    */ import javax.interceptor.Interceptors;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
/*    */ import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*    */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*    */ 
/*    */ public class InterceptorsProcessor<T extends AnnotatedElement> extends AbstractFinderUser
/*    */   implements Processor<InterceptorBindingsMetaData, T>
/*    */ {
/*    */   public InterceptorsProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 54 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(InterceptorBindingsMetaData metaData, T type)
/*    */   {
/* 59 */     Interceptors interceptors = (Interceptors)this.finder.getAnnotation(type, Interceptors.class);
/* 60 */     if (interceptors == null)
/* 61 */       return;
/* 62 */     ExcludeClassInterceptors excludeClass = (ExcludeClassInterceptors)this.finder.getAnnotation(type, ExcludeClassInterceptors.class);
/* 63 */     ExcludeDefaultInterceptors excludeDefaults = (ExcludeDefaultInterceptors)this.finder.getAnnotation(type, ExcludeDefaultInterceptors.class);
/*    */ 
/* 65 */     Method method = null;
/* 66 */     if ((type instanceof Method)) {
/* 67 */       method = (Method)type;
/*    */     }
/* 69 */     String ejbName = (String)EjbNameThreadLocal.ejbName.get();
/* 70 */     InterceptorBindingMetaData interceptor = new InterceptorBindingMetaData();
/* 71 */     interceptor.setEjbName(ejbName);
/* 72 */     interceptor.setExcludeClassInterceptors(excludeClass != null);
/* 73 */     interceptor.setExcludeDefaultInterceptors(excludeDefaults != null);
/* 74 */     if (method != null)
/*    */     {
/* 76 */       NamedMethodMetaData namedMethod = new NamedMethodMetaData();
/* 77 */       namedMethod.setMethodName(method.getName());
/* 78 */       MethodParametersMetaData methodParams = ProcessorUtils.getMethodParameters(method);
/* 79 */       namedMethod.setMethodParams(methodParams);
/* 80 */       interceptor.setMethod(namedMethod);
/*    */     }
/* 82 */     InterceptorClassesMetaData classes = new InterceptorClassesMetaData();
/* 83 */     for (Class c : interceptors.value())
/*    */     {
/* 85 */       classes.add(c.getName());
/*    */     }
/* 87 */     interceptor.setInterceptorClasses(classes);
/*    */ 
/* 89 */     Descriptions descriptions = ProcessorUtils.getDescription("@Interceptors for: " + type);
/* 90 */     interceptor.setDescriptions(descriptions);
/* 91 */     metaData.add(interceptor);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.InterceptorsProcessor
 * JD-Core Version:    0.6.0
 */