/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.annotation.security.DenyAll;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodsMetaData;
/*    */ 
/*    */ public class DenyAllProcessor extends AbstractFinderUser
/*    */   implements Processor<ExcludeListMetaData, Method>
/*    */ {
/* 49 */   private static final Logger log = Logger.getLogger(DenyAllProcessor.class);
/*    */ 
/*    */   public DenyAllProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 53 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(ExcludeListMetaData metaData, Method method)
/*    */   {
/* 58 */     DenyAll deny = (DenyAll)this.finder.getAnnotation(method, DenyAll.class);
/* 59 */     if (deny == null) {
/* 60 */       return;
/*    */     }
/* 62 */     MethodsMetaData methods = metaData.getMethods();
/* 63 */     if (methods == null)
/*    */     {
/* 65 */       methods = new MethodsMetaData();
/* 66 */       metaData.setMethods(methods);
/*    */     }
/* 68 */     String ejbName = (String)EjbNameThreadLocal.ejbName.get();
/* 69 */     if (ejbName == null)
/* 70 */       ejbName = "*";
/* 71 */     MethodMetaData mmd = ProcessorUtils.createMethod(ejbName, method);
/* 72 */     Descriptions descriptions = ProcessorUtils.getDescription("@DenyAll for: " + method);
/* 73 */     mmd.setDescriptions(descriptions);
/* 74 */     log.trace("add " + mmd);
/* 75 */     methods.add(mmd);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.DenyAllProcessor
 * JD-Core Version:    0.6.0
 */