/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.interceptor.AroundInvoke;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
/*    */ import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ 
/*    */ public class AroundInvokeProcessor extends AbstractFinderUser
/*    */   implements Creator<Method, AroundInvokeMetaData>, Processor<SessionBeanMetaData, Method>
/*    */ {
/*    */   public AroundInvokeProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 49 */     super(finder);
/*    */   }
/*    */ 
/*    */   public AroundInvokeMetaData create(Method method)
/*    */   {
/* 54 */     AroundInvoke init = (AroundInvoke)this.finder.getAnnotation(method, AroundInvoke.class);
/* 55 */     if (init == null) {
/* 56 */       return null;
/*    */     }
/* 58 */     AroundInvokeMetaData metaData = new AroundInvokeMetaData();
/* 59 */     String className = method.getDeclaringClass().getName();
/* 60 */     metaData.setClassName(className);
/* 61 */     metaData.setMethodName(method.getName());
/* 62 */     return metaData;
/*    */   }
/*    */ 
/*    */   public void process(SessionBeanMetaData bean, Method method)
/*    */   {
/* 67 */     AroundInvokeMetaData metaData = create(method);
/* 68 */     if (metaData == null) {
/* 69 */       return;
/*    */     }
/* 71 */     AroundInvokesMetaData invokes = bean.getAroundInvokes();
/* 72 */     if (invokes == null)
/*    */     {
/* 74 */       invokes = new AroundInvokesMetaData();
/* 75 */       bean.setAroundInvokes(invokes);
/*    */     }
/* 77 */     invokes.add(metaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.AroundInvokeProcessor
 * JD-Core Version:    0.6.0
 */