/*     */ package org.jboss.metadata.annotation.creator.ejb;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.ejb.TransactionManagement;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import org.jboss.metadata.annotation.creator.Creator;
/*     */ import org.jboss.metadata.annotation.creator.Processor;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionImpl;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionsImpl;
/*     */ 
/*     */ public abstract class AbstractSessionBeanProcessor extends AbstractEnterpriseBeanProcessor<SessionBeanMetaData>
/*     */   implements Creator<Class<?>, SessionBeanMetaData>, Processor<EjbJar3xMetaData, Class<?>>
/*     */ {
/*     */   private List<Processor<SessionBeanMetaData, Class<?>>> topLevelProcessors;
/*     */ 
/*     */   protected AbstractSessionBeanProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  53 */     super(finder);
/*     */ 
/*  57 */     this.topLevelProcessors = new ArrayList();
/*  58 */     this.topLevelProcessors.add(new LocalHomeProcessor(finder));
/*     */ 
/*  60 */     addTypeProcessor(new LocalProcessor(finder));
/*  61 */     addTypeProcessor(new RemoteProcessor(finder));
/*  62 */     addTypeProcessor(new RemoteHomeProcessor(finder));
/*     */ 
/*  64 */     addMethodProcessor(new InitProcessor(finder));
/*  65 */     addMethodProcessor(new TimeoutProcessor(finder));
/*  66 */     addMethodProcessor(new AroundInvokeProcessor(finder));
/*     */   }
/*     */ 
/*     */   public abstract SessionBeanMetaData create(Class<?> paramClass);
/*     */ 
/*     */   protected SessionBeanMetaData create(Class<?> beanClass, String name, String mappedName, String description) {
/*  73 */     SessionBeanMetaData bean = new SessionBeanMetaData();
/*  74 */     bean.setEjbClass(beanClass.getName());
/*     */     String ejbName;
/*     */     String ejbName;
/*  76 */     if ((name == null) || (name.length() == 0))
/*  77 */       ejbName = beanClass.getSimpleName();
/*     */     else
/*  79 */       ejbName = name;
/*  80 */     bean.setEjbName(ejbName);
/*  81 */     if ((mappedName != null) && (mappedName.length() > 0))
/*  82 */       bean.setMappedName(mappedName);
/*  83 */     if ((description != null) && (description.length() > 0))
/*     */     {
/*  85 */       DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
/*  86 */       DescriptionsImpl descriptions = new DescriptionsImpl();
/*  87 */       DescriptionImpl descriptionImpl = new DescriptionImpl();
/*  88 */       descriptionImpl.setDescription(description);
/*  89 */       descriptions.add(descriptionImpl);
/*  90 */       descriptionGroup.setDescriptions(descriptions);
/*  91 */       bean.setDescriptionGroup(descriptionGroup);
/*     */     }
/*     */ 
/*  94 */     TransactionManagement txMgmt = (TransactionManagement)this.finder.getAnnotation(beanClass, TransactionManagement.class);
/*  95 */     TransactionManagementType txType = TransactionManagementType.CONTAINER;
/*  96 */     if (txMgmt != null)
/*  97 */       txType = txMgmt.value();
/*  98 */     bean.setTransactionType(txType);
/*     */ 
/* 100 */     processTopLevel(bean, beanClass);
/*     */ 
/* 102 */     return bean;
/*     */   }
/*     */ 
/*     */   private void processTopLevel(SessionBeanMetaData bean, Class<?> cls)
/*     */   {
/* 107 */     for (Processor processor : this.topLevelProcessors)
/*     */     {
/* 109 */       processor.process(bean, cls);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.AbstractSessionBeanProcessor
 * JD-Core Version:    0.6.0
 */