/*     */ package org.jboss.metadata.annotation.creator;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collections;
/*     */ import java.util.Set;
/*     */ import org.jboss.annotation.javaee.Descriptions;
/*     */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionImpl;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionsImpl;
/*     */ import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
/*     */ 
/*     */ public class ProcessorUtils
/*     */ {
/*     */   public static <E extends AnnotatedElement> Set<ResourceInjectionTargetMetaData> getInjectionTargets(String name, E element)
/*     */   {
/*  46 */     Set injectionTargets = null;
/*  47 */     if (!(element instanceof Class))
/*     */     {
/*  50 */       ResourceInjectionTargetMetaData target = new ResourceInjectionTargetMetaData();
/*  51 */       target.setInjectionTargetClass(getDeclaringClass(element));
/*  52 */       target.setInjectionTargetName(name);
/*  53 */       injectionTargets = Collections.singleton(target);
/*     */     }
/*  55 */     return injectionTargets;
/*     */   }
/*     */ 
/*     */   public static <E extends AnnotatedElement> String getName(E element)
/*     */   {
/*  60 */     String name = element.getClass().getSimpleName();
/*  61 */     if ((element instanceof Class))
/*     */     {
/*  63 */       Class c = (Class)element;
/*  64 */       name = c.getSimpleName();
/*     */     }
/*  66 */     else if ((element instanceof Field))
/*     */     {
/*  68 */       Field f = (Field)element;
/*  69 */       name = f.getName();
/*     */     }
/*  71 */     else if ((element instanceof Method))
/*     */     {
/*  73 */       Method m = (Method)element;
/*  74 */       name = m.getName();
/*     */     }
/*  76 */     return name;
/*     */   }
/*     */ 
/*     */   public static <E extends AnnotatedElement> String getDeclaringClass(E element)
/*     */   {
/*  81 */     String c = null;
/*  82 */     if ((element instanceof Field))
/*     */     {
/*  84 */       Field f = (Field)element;
/*  85 */       c = f.getDeclaringClass().getName();
/*     */     }
/*  87 */     else if ((element instanceof Method))
/*     */     {
/*  89 */       Method m = (Method)element;
/*  90 */       c = m.getDeclaringClass().getName();
/*     */     }
/*  92 */     return c;
/*     */   }
/*     */ 
/*     */   public static MethodMetaData createMethod(String ejbName, Method method)
/*     */   {
/*  97 */     MethodMetaData methodMetaData = new MethodMetaData();
/*  98 */     methodMetaData.setEjbName(ejbName);
/*  99 */     if (method == null) {
/* 100 */       methodMetaData.setMethodName("*");
/*     */     }
/*     */     else {
/* 103 */       methodMetaData.setMethodName(method.getName());
/* 104 */       MethodParametersMetaData methodParameters = getMethodParameters(method);
/* 105 */       if (methodParameters != null)
/* 106 */         methodMetaData.setMethodParams(methodParameters);
/*     */     }
/* 108 */     return methodMetaData;
/*     */   }
/*     */ 
/*     */   public static MethodParametersMetaData getMethodParameters(Method method)
/*     */   {
/* 113 */     MethodParametersMetaData metaData = new MethodParametersMetaData();
/* 114 */     for (Class parameterType : method.getParameterTypes())
/*     */     {
/* 116 */       metaData.add(parameterType.getName());
/*     */     }
/* 118 */     return metaData;
/*     */   }
/*     */ 
/*     */   public static Descriptions getDescription(String description)
/*     */   {
/* 123 */     DescriptionsImpl descriptions = null;
/* 124 */     if (description.length() > 0)
/*     */     {
/* 126 */       DescriptionImpl di = new DescriptionImpl();
/* 127 */       di.setDescription(description);
/* 128 */       descriptions = new DescriptionsImpl();
/* 129 */       descriptions.add(di);
/*     */     }
/* 131 */     return descriptions;
/*     */   }
/*     */ 
/*     */   public static DescriptionGroupMetaData getDescriptionGroup(String description) {
/* 135 */     DescriptionGroupMetaData dg = null;
/* 136 */     if (description.length() > 0)
/*     */     {
/* 138 */       dg = new DescriptionGroupMetaData();
/* 139 */       Descriptions descriptions = getDescription(description);
/* 140 */       dg.setDescriptions(descriptions);
/*     */     }
/* 142 */     return dg;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ProcessorUtils
 * JD-Core Version:    0.6.0
 */