/*    */ package org.jboss.metadata.annotation.creator;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.annotation.PostConstruct;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*    */ 
/*    */ public class PostConstructMethodProcessor extends AbstractLifeCycleMethodProcessor
/*    */   implements Processor<EnvironmentRefsGroupMetaData, Method>
/*    */ {
/*    */   public PostConstructMethodProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 50 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(EnvironmentRefsGroupMetaData metaData, Method element)
/*    */   {
/* 55 */     PostConstruct annotation = (PostConstruct)this.finder.getAnnotation(element, PostConstruct.class);
/* 56 */     if (annotation == null) {
/* 57 */       return;
/*    */     }
/* 59 */     LifecycleCallbackMetaData callback = super.create(element);
/* 60 */     LifecycleCallbacksMetaData postConstructs = metaData.getPostConstructs();
/* 61 */     if (postConstructs == null)
/*    */     {
/* 63 */       postConstructs = new LifecycleCallbacksMetaData();
/* 64 */       metaData.setPostConstructs(postConstructs);
/*    */     }
/* 66 */     postConstructs.add(callback);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.PostConstructMethodProcessor
 * JD-Core Version:    0.6.0
 */