/*    */ package org.jboss.metadata.annotation.creator;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.annotation.security.DeclareRoles;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*    */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*    */ 
/*    */ public class DeclareRolesProcessor extends AbstractFinderUser
/*    */   implements Processor<SecurityRolesMetaData, Class>
/*    */ {
/*    */   public DeclareRolesProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 45 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(SecurityRolesMetaData metaData, Class element)
/*    */   {
/* 50 */     DeclareRoles roles = (DeclareRoles)this.finder.getAnnotation(element, DeclareRoles.class);
/* 51 */     if (roles == null) {
/* 52 */       return;
/*    */     }
/* 54 */     for (String role : roles.value())
/*    */     {
/* 56 */       SecurityRoleMetaData sr = new SecurityRoleMetaData();
/* 57 */       sr.setRoleName(role);
/* 58 */       Descriptions descriptions = ProcessorUtils.getDescription("DeclareRoles(" + roles.value() + ") on class: " + element.getName());
/* 59 */       sr.setDescriptions(descriptions);
/* 60 */       metaData.add(sr);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.DeclareRolesProcessor
 * JD-Core Version:    0.6.0
 */