/*    */ package org.jboss.metadata.annotation.creator;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.annotation.security.RunAs;
/*    */ import org.jboss.annotation.javaee.Descriptions;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*    */ 
/*    */ public class AbstractRunAsProcessor extends AbstractFinderUser
/*    */   implements Creator<Class, RunAsMetaData>
/*    */ {
/*    */   public AbstractRunAsProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 44 */     super(finder);
/*    */   }
/*    */ 
/*    */   public RunAsMetaData create(Class element)
/*    */   {
/* 49 */     RunAs runAs = (RunAs)this.finder.getAnnotation(element, RunAs.class);
/* 50 */     if (runAs == null) {
/* 51 */       return null;
/*    */     }
/* 53 */     RunAsMetaData metaData = new RunAsMetaData();
/* 54 */     metaData.setRoleName(runAs.value());
/* 55 */     Descriptions descriptions = ProcessorUtils.getDescription("RunAs(" + runAs.value() + ") on class: " + element.getName());
/* 56 */     metaData.setDescriptions(descriptions);
/* 57 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.AbstractRunAsProcessor
 * JD-Core Version:    0.6.0
 */