/*     */ package org.jboss.metadata.annotation.creator;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import javax.ejb.EJB;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionImpl;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionsImpl;
/*     */ 
/*     */ public abstract class AbstractEJBProcessor<E extends AnnotatedElement> extends AbstractFinderUser
/*     */ {
/*     */   public AbstractEJBProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  46 */     super(finder);
/*     */   }
/*     */ 
/*     */   public void process(AnnotatedEJBReferencesMetaData refs, E element)
/*     */   {
/*  51 */     EJB annotation = (EJB)this.finder.getAnnotation(element, EJB.class);
/*  52 */     if (annotation == null) {
/*  53 */       return;
/*     */     }
/*  55 */     process(refs, element, annotation);
/*     */   }
/*     */ 
/*     */   protected void process(AnnotatedEJBReferencesMetaData refs, E element, EJB annotation)
/*     */   {
/*  60 */     AnnotatedEJBReferenceMetaData ref = createEJB(annotation, element);
/*  61 */     refs.add(ref);
/*     */   }
/*     */ 
/*     */   protected abstract String getName(E paramE);
/*     */ 
/*     */   protected abstract Class getType(E paramE);
/*     */ 
/*     */   protected AnnotatedEJBReferenceMetaData createEJB(EJB annotation, E element)
/*     */   {
/*  79 */     AnnotatedEJBReferenceMetaData ref = new AnnotatedEJBReferenceMetaData();
/*  80 */     if (annotation.name().length() > 0)
/*  81 */       ref.setEjbRefName(annotation.name());
/*     */     else
/*  83 */       ref.setEjbRefName(getName(element));
/*  84 */     if (annotation.beanInterface() != Object.class)
/*  85 */       ref.setBeanInterface(annotation.beanInterface());
/*     */     else
/*  87 */       ref.setBeanInterface(getType(element));
/*  88 */     if (annotation.description().length() > 0)
/*     */     {
/*  90 */       DescriptionImpl description = new DescriptionImpl();
/*  91 */       description.setDescription(annotation.description());
/*  92 */       DescriptionsImpl descriptions = new DescriptionsImpl();
/*  93 */       descriptions.add(description);
/*  94 */       ref.setDescriptions(descriptions);
/*     */     }
/*  96 */     if (annotation.beanName().length() > 0)
/*  97 */       ref.setLink(annotation.beanName());
/*  98 */     if (annotation.mappedName().length() > 0) {
/*  99 */       ref.setMappedName(annotation.mappedName());
/*     */     }
/* 101 */     return ref;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.AbstractEJBProcessor
 * JD-Core Version:    0.6.0
 */