/*     */ package org.jboss.metadata.annotation.creator;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ 
/*     */ public abstract class AbstractComponentProcessor<MD> extends AbstractFinderUser
/*     */ {
/*  56 */   private static Logger log = Logger.getLogger(AbstractComponentProcessor.class);
/*     */   protected Map<Class<?>, List<Processor<Object, Class<?>>>> typeProcessors;
/*     */   protected Map<Class<?>, List<Processor<Object, Field>>> fieldProcessors;
/*     */   protected Map<Class<?>, List<Processor<Object, Method>>> methodProcessors;
/*  65 */   protected Set<Class> boundedTypes = new HashSet();
/*     */ 
/*     */   public AbstractComponentProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  72 */     super(finder);
/*  73 */     this.typeProcessors = new HashMap();
/*  74 */     this.fieldProcessors = new HashMap();
/*  75 */     this.methodProcessors = new HashMap();
/*     */ 
/*  79 */     addMethodProcessor(new ResourceMethodProcessor(finder));
/*  80 */     addFieldProcessor(new ResourceFieldProcessor(finder));
/*  81 */     addTypeProcessor(new ResourceClassProcessor(finder));
/*  82 */     addTypeProcessor(new ResourcesClassProcessor(finder));
/*     */ 
/*  84 */     addMethodProcessor(new EJBMethodProcessor(finder));
/*  85 */     addFieldProcessor(new EJBFieldProcessor(finder));
/*  86 */     addTypeProcessor(new EJBClassProcessor(finder));
/*  87 */     addTypeProcessor(new EJBsClassProcessor(finder));
/*     */ 
/*  89 */     addFieldProcessor(new PersistenceContextFieldProcessor(finder));
/*  90 */     addMethodProcessor(new PersistenceContextMethodProcessor(finder));
/*  91 */     addTypeProcessor(new PersistenceContextClassProcessor(finder));
/*     */ 
/*  93 */     addMethodProcessor(new PostConstructMethodProcessor(finder));
/*  94 */     addMethodProcessor(new PreDestroyMethodProcessor(finder));
/*     */   }
/*     */ 
/*     */   public void addFieldProcessor(Processor processor)
/*     */   {
/*  99 */     Class processorType = getProcessorMetaDataType(processor);
/* 100 */     log.debug("addFieldProcessor: " + processor + ", for type: " + processorType);
/* 101 */     List processors = (List)this.fieldProcessors.get(processorType);
/* 102 */     if (processors == null)
/*     */     {
/* 104 */       processors = new ArrayList();
/* 105 */       this.fieldProcessors.put(processorType, processors);
/*     */     }
/* 107 */     processors.add(processor);
/*     */   }
/*     */ 
/*     */   public void addMethodProcessor(Processor processor)
/*     */   {
/* 112 */     Class processorType = getProcessorMetaDataType(processor);
/* 113 */     log.debug("addMethodProcessor: " + processor + ", for type: " + processorType);
/* 114 */     List processors = (List)this.methodProcessors.get(processorType);
/* 115 */     if (processors == null)
/*     */     {
/* 117 */       processors = new ArrayList();
/* 118 */       this.methodProcessors.put(processorType, processors);
/*     */     }
/* 120 */     processors.add(processor);
/*     */   }
/*     */ 
/*     */   public void addTypeProcessor(Processor processor) {
/* 124 */     Class processorType = getProcessorMetaDataType(processor);
/* 125 */     log.debug("addTypeProcessor: " + processor + ", for type: " + processorType);
/* 126 */     List processors = (List)this.typeProcessors.get(processorType);
/* 127 */     if (processors == null)
/*     */     {
/* 129 */       processors = new ArrayList();
/* 130 */       this.typeProcessors.put(processorType, processors);
/*     */     }
/* 132 */     processors.add(processor);
/*     */   }
/*     */ 
/*     */   public void process(EnvironmentRefsGroupMetaData metaData, Class<?> type)
/*     */   {
/* 143 */     processClass(metaData, type);
/*     */ 
/* 146 */     AnnotatedEJBReferencesMetaData aejbRefs = metaData.getAnnotatedEjbReferences();
/* 147 */     if (aejbRefs == null)
/*     */     {
/* 149 */       aejbRefs = new AnnotatedEJBReferencesMetaData();
/* 150 */       metaData.setAnnotatedEjbReferences(aejbRefs);
/*     */     }
/* 152 */     processClass(aejbRefs, type);
/*     */ 
/* 155 */     PersistenceContextReferencesMetaData pcRefs = metaData.getPersistenceContextRefs();
/* 156 */     if (pcRefs == null)
/*     */     {
/* 158 */       pcRefs = new PersistenceContextReferencesMetaData();
/* 159 */       metaData.setPersistenceContextRefs(pcRefs);
/*     */     }
/* 161 */     processClass(pcRefs, type);
/*     */ 
/* 163 */     PersistenceUnitReferencesMetaData puRefs = metaData.getPersistenceUnitRefs();
/* 164 */     if (puRefs == null)
/*     */     {
/* 166 */       puRefs = new PersistenceUnitReferencesMetaData();
/* 167 */       metaData.setPersistenceUnitRefs(puRefs);
/*     */     }
/* 169 */     processClass(puRefs, type);
/*     */ 
/* 171 */     ServiceReferencesMetaData wsRefs = metaData.getServiceReferences();
/* 172 */     if (wsRefs == null)
/*     */     {
/* 174 */       wsRefs = new ServiceReferencesMetaData();
/* 175 */       metaData.setServiceReferences(wsRefs);
/*     */     }
/* 177 */     processClass(wsRefs, type);
/*     */   }
/*     */ 
/*     */   public void process(MD metaData, Class<?> type)
/*     */   {
/* 186 */     processClass(metaData, type);
/*     */   }
/*     */ 
/*     */   protected <T> void processClass(T metaData, Class<?> cls)
/*     */   {
/* 200 */     Class type = metaData.getClass();
/* 201 */     boolean trace = log.isTraceEnabled();
/* 202 */     int processorCount = processClass(metaData, cls, type);
/* 203 */     if (trace) {
/* 204 */       log.trace("Found " + processorCount + " processors for type: " + type);
/*     */     }
/* 206 */     type = type.getSuperclass();
/* 207 */     while ((!this.boundedTypes.contains(type)) && (type != Object.class))
/*     */     {
/* 209 */       type = type.getSuperclass();
/*     */     }
/*     */ 
/* 212 */     if (type != Object.class)
/*     */     {
/* 214 */       if (trace)
/* 215 */         log.trace("Reprocessing class using bounded processor type: " + type);
/* 216 */       processClass(metaData, cls, type);
/*     */     }
/*     */   }
/*     */ 
/*     */   private <T> int processClass(T metaData, Class<?> cls, Class processorType) {
/* 221 */     boolean trace = log.isTraceEnabled();
/* 222 */     int processorCount = 0;
/* 223 */     if (trace) {
/* 224 */       log.trace("processClass for metaData: " + processorType + ", class: " + cls);
/*     */     }
/* 226 */     List tps = (List)this.typeProcessors.get(processorType);
/* 227 */     if (tps != null)
/*     */     {
/* 229 */       processorCount += tps.size();
/* 230 */       if (trace)
/* 231 */         log.trace("typeProcessors(" + tps.size() + ") for metaData: " + tps);
/* 232 */       for (Processor processor : tps)
/*     */       {
/* 234 */         processor.process(metaData, cls);
/*     */       }
/*     */       Class intf;
/* 237 */       for (intf : cls.getInterfaces())
/*     */       {
/* 239 */         for (Processor processor : tps)
/*     */         {
/* 241 */           processor.process(metaData, intf);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 246 */     List fps = (List)this.fieldProcessors.get(processorType);
/* 247 */     if (fps != null)
/*     */     {
/* 249 */       processorCount += fps.size();
/* 250 */       if (trace)
/* 251 */         log.trace("fieldProcessors(" + fps.size() + ") for metaData: " + fps);
/*     */       Field field;
/* 252 */       for (field : cls.getDeclaredFields())
/*     */       {
/* 254 */         for (Processor processor : fps)
/*     */         {
/* 256 */           processor.process(metaData, field);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 261 */     List mps = (List)this.methodProcessors.get(processorType);
/* 262 */     if (mps != null)
/*     */     {
/* 264 */       processorCount += mps.size();
/* 265 */       if (trace)
/* 266 */         log.trace("methodProcessors(" + mps.size() + ") for metaData: " + mps);
/*     */       Method method;
/* 267 */       for (method : cls.getDeclaredMethods())
/*     */       {
/* 269 */         if (trace)
/* 270 */           log.trace("process method " + method);
/* 271 */         for (Processor processor : mps)
/*     */         {
/* 273 */           processor.process(metaData, method);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 278 */     if ((cls.getSuperclass() != null) && (cls.getSuperclass() != Object.class))
/* 279 */       processorCount += processClass(metaData, cls.getSuperclass(), processorType);
/* 280 */     return processorCount;
/*     */   }
/*     */ 
/*     */   protected Class getProcessorMetaDataType(Processor processor)
/*     */   {
/* 293 */     Type[] interfaces = processor.getClass().getGenericInterfaces();
/* 294 */     Type processorType = null;
/* 295 */     for (Type t : interfaces)
/*     */     {
/* 297 */       ParameterizedType pt = (ParameterizedType)t;
/* 298 */       Type rawType = pt.getRawType();
/* 299 */       if ((!(rawType instanceof Class)) || (!((Class)rawType).getName().equals("org.jboss.metadata.annotation.creator.Processor")))
/*     */         continue;
/* 301 */       processorType = t;
/* 302 */       break;
/*     */     }
/*     */ 
/* 305 */     if (processorType == null) {
/* 306 */       throw new IllegalStateException("No generic Processor interface found on: " + processor);
/*     */     }
/*     */ 
/* 309 */     ParameterizedType pt = (ParameterizedType)processorType;
/* 310 */     Type t0 = pt.getActualTypeArguments()[0];
/* 311 */     Class t = null;
/* 312 */     if ((t0 instanceof Class)) {
/* 313 */       t = (Class)t0;
/* 314 */     } else if ((t0 instanceof TypeVariable))
/*     */     {
/* 316 */       TypeVariable tv = (TypeVariable)t0;
/* 317 */       t = (Class)tv.getBounds()[0];
/* 318 */       this.boundedTypes.add(t);
/*     */     }
/* 320 */     return t;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.AbstractComponentProcessor
 * JD-Core Version:    0.6.0
 */