/*     */ package org.jboss.metadata;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.w3c.dom.Document;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.SAXParseException;
/*     */ 
/*     */ public class XmlFileLoader
/*     */ {
/*  59 */   private static boolean defaultValidateDTDs = false;
/*  60 */   private static Logger log = Logger.getLogger(XmlFileLoader.class);
/*     */   private URLClassLoader classLoader;
/*     */   private ApplicationMetaData metaData;
/*     */   private boolean validateDTDs;
/*     */ 
/*     */   public static boolean getDefaultValidateDTDs()
/*     */   {
/*  68 */     return defaultValidateDTDs;
/*     */   }
/*     */ 
/*     */   public static void setDefaultValidateDTDs(boolean validate)
/*     */   {
/*  73 */     defaultValidateDTDs = validate;
/*     */   }
/*     */ 
/*     */   public XmlFileLoader()
/*     */   {
/*  80 */     this(defaultValidateDTDs);
/*     */   }
/*     */ 
/*     */   public XmlFileLoader(boolean validateDTDs)
/*     */   {
/*  85 */     this.validateDTDs = validateDTDs;
/*     */   }
/*     */ 
/*     */   public ApplicationMetaData getMetaData()
/*     */   {
/*  91 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(URLClassLoader cl)
/*     */   {
/*  99 */     this.classLoader = cl;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 109 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public boolean getValidateDTDs()
/*     */   {
/* 119 */     return this.validateDTDs;
/*     */   }
/*     */ 
/*     */   public void setValidateDTDs(boolean validate)
/*     */   {
/* 128 */     this.validateDTDs = validate;
/*     */   }
/*     */ 
/*     */   public ApplicationMetaData load(URL alternativeDD)
/*     */     throws Exception
/*     */   {
/* 143 */     URL ejbjarUrl = null;
/* 144 */     if (alternativeDD != null)
/*     */     {
/* 146 */       log.debug("Using alternativeDD: " + alternativeDD);
/* 147 */       ejbjarUrl = alternativeDD;
/*     */     }
/*     */     else
/*     */     {
/* 151 */       ejbjarUrl = getClassLoader().getResource("META-INF/ejb-jar.xml");
/*     */     }
/*     */ 
/* 154 */     if (ejbjarUrl == null)
/*     */     {
/* 156 */       throw new DeploymentException("no ejb-jar.xml found");
/*     */     }
/*     */ 
/* 160 */     JBossMetaData realMetaData = new JBossMetaData();
/* 161 */     this.metaData = new ApplicationMetaData(realMetaData);
/*     */ 
/* 163 */     Document ejbjarDocument = getDocumentFromURL(ejbjarUrl);
/*     */ 
/* 166 */     this.metaData.setUrl(ejbjarUrl);
/* 167 */     this.metaData.importEjbJarXml(ejbjarDocument.getDocumentElement());
/*     */ 
/* 173 */     URL defaultJbossUrl = Thread.currentThread().getContextClassLoader().getResource("standardjboss.xml");
/* 174 */     if (defaultJbossUrl == null)
/*     */     {
/* 176 */       throw new DeploymentException("no standardjboss.xml found");
/*     */     }
/*     */ 
/* 179 */     Document defaultJbossDocument = null;
/*     */     try
/*     */     {
/* 182 */       defaultJbossDocument = getDocumentFromURL(defaultJbossUrl);
/* 183 */       this.metaData.setUrl(defaultJbossUrl);
/* 184 */       this.metaData.importJbossXml(defaultJbossDocument.getDocumentElement());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 188 */       log.error("failed to load standardjboss.xml.  There could be a syntax error.", ex);
/* 189 */       throw ex;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 196 */       URL jbossUrl = getClassLoader().getResource("META-INF/jboss.xml");
/* 197 */       if (jbossUrl != null)
/*     */       {
/* 199 */         Document jbossDocument = getDocumentFromURL(jbossUrl);
/* 200 */         this.metaData.setUrl(jbossUrl);
/* 201 */         this.metaData.importJbossXml(jbossDocument.getDocumentElement());
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 206 */       log.error("failed to load jboss.xml.  There could be a syntax error.", ex);
/* 207 */       throw ex;
/*     */     }
/*     */ 
/* 210 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public static Document getDocument(URL url)
/*     */     throws DeploymentException
/*     */   {
/* 218 */     return getDocument(url, defaultValidateDTDs);
/*     */   }
/*     */ 
/*     */   public static Document getDocument(URL url, boolean validateDTDs)
/*     */     throws DeploymentException
/*     */   {
/* 228 */     XmlFileLoader loader = new XmlFileLoader(validateDTDs);
/* 229 */     return loader.getDocumentFromURL(url);
/*     */   }
/*     */ 
/*     */   public Document getDocumentFromURL(URL url)
/*     */     throws DeploymentException
/*     */   {
/* 241 */     InputStream is = null;
/*     */     try
/*     */     {
/* 244 */       is = url.openStream();
/* 245 */       return getDocument(is, url.toExternalForm());
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 249 */     throw new DeploymentException("Failed to obtain xml doc from URL", e);
/*     */   }
/*     */ 
/*     */   public Document getDocument(InputStream is, String inPath)
/*     */     throws DeploymentException
/*     */   {
/* 268 */     InputSource is2 = new InputSource(is);
/* 269 */     is2.setSystemId(inPath);
/* 270 */     Document doc = null;
/*     */     try
/*     */     {
/* 273 */       doc = getDocument(is2, inPath);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 281 */         if (is != null) {
/* 282 */           is.close();
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/* 289 */     return doc;
/*     */   }
/*     */ 
/*     */   public Document getDocument(InputSource is, String inPath)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 309 */       DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
/*     */ 
/* 312 */       docBuilderFactory.setValidating(this.validateDTDs);
/*     */ 
/* 316 */       docBuilderFactory.setNamespaceAware(true);
/*     */ 
/* 323 */       DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
/* 324 */       JBossEntityResolver lr = new JBossEntityResolver();
/* 325 */       LocalErrorHandler eh = new LocalErrorHandler(inPath, lr);
/* 326 */       docBuilder.setEntityResolver(lr);
/* 327 */       docBuilder.setErrorHandler(eh);
/*     */ 
/* 329 */       Document doc = docBuilder.parse(is);
/* 330 */       if ((this.validateDTDs) && (eh.hadError()))
/*     */       {
/* 332 */         throw new DeploymentException("Invalid XML: file=" + inPath, eh.getException());
/*     */       }
/* 334 */       return doc;
/*     */     }
/*     */     catch (DeploymentException e)
/*     */     {
/* 338 */       throw e;
/*     */     }
/*     */     catch (SAXParseException e)
/*     */     {
/* 342 */       String msg = "Invalid XML: file=" + inPath + "@" + e.getColumnNumber() + ":" + e.getLineNumber();
/* 343 */       throw new DeploymentException(msg, e);
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 347 */       throw new DeploymentException("Invalid XML: file=" + inPath, e);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 351 */     throw new DeploymentException("Invalid XML: file=" + inPath, e);
/*     */   }
/*     */ 
/*     */   private static class LocalErrorHandler
/*     */     implements ErrorHandler
/*     */   {
/*     */     private String theFileName;
/*     */     private JBossEntityResolver localResolver;
/*     */     private boolean error;
/*     */     private SAXParseException exception;
/*     */ 
/*     */     public LocalErrorHandler(String inFileName, JBossEntityResolver localResolver)
/*     */     {
/* 380 */       this.theFileName = inFileName;
/* 381 */       this.localResolver = localResolver;
/* 382 */       this.error = false;
/*     */     }
/*     */ 
/*     */     public void error(SAXParseException exception)
/*     */     {
/* 387 */       this.exception = exception;
/* 388 */       if (this.localResolver.isEntityResolved())
/*     */       {
/* 390 */         this.error = true;
/* 391 */         XmlFileLoader.log.error("XmlFileLoader: File " + this.theFileName + " process error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
/*     */       }
/*     */     }
/*     */ 
/*     */     public void fatalError(SAXParseException exception)
/*     */     {
/* 403 */       this.exception = exception;
/* 404 */       if (this.localResolver.isEntityResolved())
/*     */       {
/* 406 */         this.error = true;
/* 407 */         XmlFileLoader.log.error("XmlFileLoader: File " + this.theFileName + " process fatal error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
/*     */       }
/*     */     }
/*     */ 
/*     */     public void warning(SAXParseException exception)
/*     */     {
/* 419 */       this.exception = exception;
/* 420 */       if (this.localResolver.isEntityResolved())
/*     */       {
/* 422 */         this.error = true;
/* 423 */         XmlFileLoader.log.error("XmlFileLoader: File " + this.theFileName + " process warning. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
/*     */       }
/*     */     }
/*     */ 
/*     */     public SAXParseException getException()
/*     */     {
/* 435 */       return this.exception;
/*     */     }
/*     */ 
/*     */     public boolean hadError()
/*     */     {
/* 440 */       return this.error;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.XmlFileLoader
 * JD-Core Version:    0.6.0
 */