/*     */ package org.jboss.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
/*     */ 
/*     */ public class IorSecurityConfigMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3341898910508715334L;
/*     */   private TransportConfig transportConfig;
/*     */   private AsContext asContext;
/*     */   private SasContext sasContext;
/*     */ 
/*     */   public IorSecurityConfigMetaData()
/*     */   {
/*  71 */     this.transportConfig = new TransportConfig(null);
/*  72 */     this.asContext = new AsContext(null);
/*  73 */     this.sasContext = new SasContext(null);
/*     */   }
/*     */ 
/*     */   IorSecurityConfigMetaData(IORSecurityConfigMetaData securityConfigMetaData)
/*     */   {
/*  83 */     if (securityConfigMetaData == null)
/*  84 */       throw new IllegalArgumentException("Null security config metadata");
/*  85 */     this.transportConfig = new TransportConfig(securityConfigMetaData.getTransportConfig(), null);
/*  86 */     this.asContext = new AsContext(securityConfigMetaData.getAsContext(), null);
/*  87 */     this.sasContext = new SasContext(securityConfigMetaData.getSasContext(), null);
/*     */   }
/*     */ 
/*     */   public TransportConfig getTransportConfig()
/*     */   {
/*  97 */     return this.transportConfig;
/*     */   }
/*     */ 
/*     */   public void setTransportConfig(TransportConfig config)
/*     */   {
/* 107 */     this.transportConfig = config;
/*     */   }
/*     */ 
/*     */   public AsContext getAsContext()
/*     */   {
/* 117 */     return this.asContext;
/*     */   }
/*     */ 
/*     */   public void setAsContext(AsContext context)
/*     */   {
/* 127 */     this.asContext = context;
/*     */   }
/*     */ 
/*     */   public SasContext getSasContext()
/*     */   {
/* 137 */     return this.sasContext;
/*     */   }
/*     */ 
/*     */   public void setSasContext(SasContext context)
/*     */   {
/* 147 */     this.sasContext = context;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 153 */     return "[transport-config=" + this.transportConfig + ", as-context=" + this.asContext + ", sas-context=" + this.sasContext + "]";
/*     */   }
/*     */ 
/*     */   public class SasContext
/*     */   {
/*     */     public static final String CALLER_PROPAGATION_NONE = "NONE";
/*     */     public static final String CALLER_PROPAGATION_SUPPORTED = "SUPPORTED";
/*     */     private final String callerPropagation;
/*     */ 
/*     */     private SasContext()
/*     */     {
/* 460 */       this.callerPropagation = "NONE";
/*     */     }
/*     */ 
/*     */     private SasContext(IORSASContextMetaData sasContext)
/*     */     {
/* 470 */       if (sasContext == null)
/* 471 */         throw new IllegalArgumentException("Null sasContext");
/* 472 */       this.callerPropagation = sasContext.getCallerPropagation();
/*     */     }
/*     */ 
/*     */     public String getCallerPropagation()
/*     */     {
/* 482 */       return this.callerPropagation;
/*     */     }
/*     */ 
/*     */     public boolean isCallerPropagationSupported()
/*     */     {
/* 492 */       return "SUPPORTED".equalsIgnoreCase(this.callerPropagation);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 498 */       return "[caller-propagation=" + this.callerPropagation + "]";
/*     */     }
/*     */   }
/*     */ 
/*     */   public class AsContext
/*     */   {
/*     */     public static final String AUTH_METHOD_USERNAME_PASSWORD = "USERNAME_PASSWORD";
/*     */     public static final String AUTH_METHOD_NONE = "NONE";
/*     */     private final String authMethod;
/*     */     private final String realm;
/*     */     private final boolean required;
/*     */ 
/*     */     private AsContext()
/*     */     {
/* 380 */       this.authMethod = "USERNAME_PASSWORD";
/* 381 */       this.realm = "default";
/* 382 */       this.required = false;
/*     */     }
/*     */ 
/*     */     private AsContext(IORASContextMetaData asContext)
/*     */     {
/* 392 */       if (asContext == null)
/* 393 */         throw new IllegalArgumentException("Null asContext");
/* 394 */       this.authMethod = asContext.getAuthMethod();
/* 395 */       this.realm = asContext.getRealm();
/* 396 */       this.required = asContext.isRequired();
/*     */     }
/*     */ 
/*     */     public String getAuthMethod()
/*     */     {
/* 406 */       return this.authMethod;
/*     */     }
/*     */ 
/*     */     public String getRealm()
/*     */     {
/* 416 */       return this.realm;
/*     */     }
/*     */ 
/*     */     public boolean isRequired()
/*     */     {
/* 426 */       return this.required;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 432 */       return "[auth-method=" + this.authMethod + ", realm=" + this.realm + ", required=" + this.required + "]";
/*     */     }
/*     */   }
/*     */ 
/*     */   public class TransportConfig
/*     */   {
/*     */     public static final String INTEGRITY_NONE = "NONE";
/*     */     public static final String INTEGRITY_SUPPORTED = "SUPPORTED";
/*     */     public static final String INTEGRITY_REQUIRED = "REQUIRED";
/*     */     public static final String CONFIDENTIALITY_NONE = "NONE";
/*     */     public static final String CONFIDENTIALITY_SUPPORTED = "SUPPORTED";
/*     */     public static final String CONFIDENTIALITY_REQUIRED = "REQUIRED";
/*     */     public static final String DETECT_MISORDERING_NONE = "NONE";
/*     */     public static final String DETECT_MISORDERING_SUPPORTED = "SUPPORTED";
/*     */     public static final String DETECT_MISORDERING_REQUIRED = "REQUIRED";
/*     */     public static final String DETECT_REPLAY_NONE = "NONE";
/*     */     public static final String DETECT_REPLAY_SUPPORTED = "SUPPORTED";
/*     */     public static final String DETECT_REPLAY_REQUIRED = "REQUIRED";
/*     */     public static final String ESTABLISH_TRUST_IN_TARGET_NONE = "NONE";
/*     */     public static final String ESTABLISH_TRUST_IN_TARGET_SUPPORTED = "SUPPORTED";
/*     */     public static final String ESTABLISH_TRUST_IN_CLIENT_NONE = "NONE";
/*     */     public static final String ESTABLISH_TRUST_IN_CLIENT_SUPPORTED = "SUPPORTED";
/*     */     public static final String ESTABLISH_TRUST_IN_CLIENT_REQUIRED = "REQUIRED";
/*     */     private final String integrity;
/*     */     private final String confidentiality;
/*     */     private final String detectMisordering;
/*     */     private final String detectReplay;
/*     */     private final String establishTrustInTarget;
/*     */     private final String establishTrustInClient;
/*     */ 
/*     */     private TransportConfig()
/*     */     {
/* 234 */       this.integrity = "SUPPORTED";
/* 235 */       this.confidentiality = "SUPPORTED";
/* 236 */       this.establishTrustInTarget = "SUPPORTED";
/* 237 */       this.establishTrustInClient = "SUPPORTED";
/* 238 */       this.detectMisordering = "SUPPORTED";
/* 239 */       this.detectReplay = "SUPPORTED";
/*     */     }
/*     */ 
/*     */     private TransportConfig(IORTransportConfigMetaData tranportConfig)
/*     */     {
/* 249 */       if (tranportConfig == null)
/* 250 */         throw new IllegalArgumentException("Null transport config");
/* 251 */       this.integrity = tranportConfig.getIntegrity();
/* 252 */       this.confidentiality = tranportConfig.getIntegrity();
/* 253 */       this.establishTrustInClient = tranportConfig.getEstablishTrustInClient();
/* 254 */       this.establishTrustInTarget = tranportConfig.getEstablishTrustInTarget();
/* 255 */       this.detectReplay = tranportConfig.getDetectReplay();
/* 256 */       this.detectMisordering = tranportConfig.getDetectMisordering();
/*     */     }
/*     */ 
/*     */     public String getIntegrity()
/*     */     {
/* 266 */       return this.integrity;
/*     */     }
/*     */ 
/*     */     public String getConfidentiality()
/*     */     {
/* 276 */       return this.confidentiality;
/*     */     }
/*     */ 
/*     */     public String getDetectMisordering()
/*     */     {
/* 286 */       return this.detectMisordering;
/*     */     }
/*     */ 
/*     */     public String getDetectReplay()
/*     */     {
/* 296 */       return this.detectReplay;
/*     */     }
/*     */ 
/*     */     public String getEstablishTrustInTarget()
/*     */     {
/* 306 */       return this.establishTrustInTarget;
/*     */     }
/*     */ 
/*     */     public boolean isEstablishTrustInTargetSupported()
/*     */     {
/* 316 */       return "SUPPORTED".equalsIgnoreCase(this.establishTrustInTarget);
/*     */     }
/*     */ 
/*     */     public String getEstablishTrustInClient()
/*     */     {
/* 326 */       return this.establishTrustInClient;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 332 */       return "[integrity=" + this.integrity + ", confidentiality=" + this.confidentiality + ", establish-trust-in-target=" + this.establishTrustInTarget + ", establish-trust-in-client=" + this.establishTrustInClient + ", detect-misordering=" + this.detectMisordering + ", detect-replay=" + this.detectReplay + "]";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.IorSecurityConfigMetaData
 * JD-Core Version:    0.6.0
 */