/*    */ package org.jboss.metadata;
/*    */ 
/*    */ import javax.naming.Context;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.util.naming.Util;
/*    */ 
/*    */ public class EnvEntryBinder
/*    */ {
/*    */   public static void bindEnvEntry(Context ctx, EnvEntryMetaData entry)
/*    */     throws ClassNotFoundException, NamingException
/*    */   {
/* 38 */     ClassLoader loader = EnvEntryMetaData.class.getClassLoader();
/* 39 */     Class type = loader.loadClass(entry.getType());
/* 40 */     if (type == String.class)
/*    */     {
/* 42 */       Util.bind(ctx, entry.getName(), entry.getValue());
/*    */     }
/* 44 */     else if (type == Integer.class)
/*    */     {
/* 46 */       Util.bind(ctx, entry.getName(), new Integer(entry.getValue()));
/*    */     }
/* 48 */     else if (type == Long.class)
/*    */     {
/* 50 */       Util.bind(ctx, entry.getName(), new Long(entry.getValue()));
/*    */     }
/* 52 */     else if (type == Double.class)
/*    */     {
/* 54 */       Util.bind(ctx, entry.getName(), new Double(entry.getValue()));
/*    */     }
/* 56 */     else if (type == Float.class)
/*    */     {
/* 58 */       Util.bind(ctx, entry.getName(), new Float(entry.getValue()));
/*    */     }
/* 60 */     else if (type == Byte.class)
/*    */     {
/* 62 */       Util.bind(ctx, entry.getName(), new Byte(entry.getValue()));
/*    */     }
/* 64 */     else if (type == Character.class)
/*    */     {
/* 66 */       Object value = null;
/* 67 */       String input = entry.getValue();
/* 68 */       if ((input == null) || (input.length() == 0))
/*    */       {
/* 70 */         value = new Character('\000');
/*    */       }
/*    */       else
/*    */       {
/* 74 */         value = new Character(input.charAt(0));
/*    */       }
/* 76 */       Util.bind(ctx, entry.getName(), value);
/*    */     }
/* 78 */     else if (type == Short.class)
/*    */     {
/* 80 */       Util.bind(ctx, entry.getName(), new Short(entry.getValue()));
/*    */     }
/* 82 */     else if (type == Boolean.class)
/*    */     {
/* 84 */       Util.bind(ctx, entry.getName(), new Boolean(entry.getValue()));
/*    */     }
/*    */     else
/*    */     {
/* 89 */       Util.bind(ctx, entry.getName(), entry.getValue());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.EnvEntryBinder
 * JD-Core Version:    0.6.0
 */