/*     */ package org.jboss.messaging.util.prioritylinkedlist;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BasicPriorityLinkedList
/*     */   implements PriorityLinkedList
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(BasicPriorityLinkedList.class);
/*     */   protected LinkedList[] linkedLists;
/*     */   protected int priorities;
/*     */   protected int size;
/*     */ 
/*     */   public void dump()
/*     */   {
/*  56 */     log.debug("Dumping " + this);
/*  57 */     log.debug("Size:" + this.size);
/*  58 */     log.debug("===============");
/*     */ 
/*  60 */     for (int i = 0; i < this.linkedLists.length; i++)
/*     */     {
/*  62 */       log.debug("Priority:" + i);
/*  63 */       log.debug("----------------");
/*     */ 
/*  65 */       Iterator iter = this.linkedLists[i].iterator();
/*     */ 
/*  67 */       while (iter.hasNext())
/*     */       {
/*  69 */         log.debug("Ref: " + iter.next());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public BasicPriorityLinkedList(int priorities)
/*     */   {
/*  76 */     this.priorities = priorities;
/*     */ 
/*  78 */     initDeques();
/*     */   }
/*     */ 
/*     */   public void addFirst(Object obj, int priority)
/*     */   {
/*  83 */     this.linkedLists[priority].addFirst(obj);
/*     */ 
/*  85 */     this.size += 1;
/*     */   }
/*     */ 
/*     */   public void addLast(Object obj, int priority)
/*     */   {
/*  90 */     this.linkedLists[priority].addLast(obj);
/*     */ 
/*  92 */     this.size += 1;
/*     */   }
/*     */ 
/*     */   public Object removeFirst()
/*     */   {
/*  97 */     Object obj = null;
/*     */ 
/* 105 */     for (int i = this.priorities - 1; i >= 0; i--)
/*     */     {
/* 107 */       LinkedList ll = this.linkedLists[i];
/*     */ 
/* 109 */       if (ll.isEmpty())
/*     */         continue;
/* 111 */       obj = ll.removeFirst();
/* 112 */       break;
/*     */     }
/*     */ 
/* 117 */     if (obj != null)
/*     */     {
/* 119 */       this.size -= 1;
/*     */     }
/*     */ 
/* 122 */     return obj;
/*     */   }
/*     */ 
/*     */   public Object removeLast()
/*     */   {
/* 127 */     Object obj = null;
/*     */ 
/* 134 */     for (int i = 0; i < this.priorities; i++)
/*     */     {
/* 136 */       LinkedList ll = this.linkedLists[i];
/* 137 */       if (!ll.isEmpty())
/*     */       {
/* 139 */         obj = ll.removeLast();
/*     */       }
/* 141 */       if (obj != null)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 147 */     if (obj != null)
/*     */     {
/* 149 */       this.size -= 1;
/*     */     }
/*     */ 
/* 152 */     return obj;
/*     */   }
/*     */ 
/*     */   public Object peekFirst()
/*     */   {
/* 157 */     Object obj = null;
/*     */ 
/* 165 */     for (int i = this.priorities - 1; i >= 0; i--)
/*     */     {
/* 167 */       LinkedList ll = this.linkedLists[i];
/* 168 */       if (!ll.isEmpty())
/*     */       {
/* 170 */         obj = ll.getFirst();
/*     */       }
/* 172 */       if (obj != null)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 178 */     return obj;
/*     */   }
/*     */ 
/*     */   public List getAll()
/*     */   {
/* 183 */     List all = new ArrayList();
/* 184 */     for (int i = this.priorities - 1; i >= 0; i--)
/*     */     {
/* 186 */       LinkedList deque = this.linkedLists[i];
/* 187 */       all.addAll(deque);
/*     */     }
/* 189 */     return all;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 194 */     initDeques();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 199 */     return this.size;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 204 */     return this.size == 0;
/*     */   }
/*     */ 
/*     */   public ListIterator iterator()
/*     */   {
/* 209 */     return new PriorityLinkedListIterator(this.linkedLists);
/*     */   }
/*     */ 
/*     */   protected void initDeques()
/*     */   {
/* 214 */     this.linkedLists = new LinkedList[this.priorities];
/* 215 */     for (int i = 0; i < this.priorities; i++)
/*     */     {
/* 217 */       this.linkedLists[i] = new LinkedList();
/*     */     }
/*     */ 
/* 220 */     this.size = 0;
/*     */   }
/*     */ 
/*     */   class PriorityLinkedListIterator implements ListIterator
/*     */   {
/*     */     private LinkedList[] lists;
/*     */     private int index;
/*     */     private ListIterator currentIter;
/*     */ 
/*     */     PriorityLinkedListIterator(LinkedList[] lists)
/*     */     {
/* 234 */       this.lists = lists;
/*     */ 
/* 236 */       this.index = (lists.length - 1);
/*     */ 
/* 238 */       this.currentIter = lists[this.index].listIterator();
/*     */     }
/*     */ 
/*     */     public void add(Object arg0)
/*     */     {
/* 243 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 248 */       if (this.currentIter.hasNext())
/*     */       {
/* 250 */         return true;
/*     */       }
/* 252 */       while (this.index >= 0)
/*     */       {
/* 254 */         if ((this.index == 0) || (this.currentIter.hasNext()))
/*     */         {
/*     */           break;
/*     */         }
/* 258 */         this.index -= 1;
/* 259 */         this.currentIter = this.lists[this.index].listIterator();
/*     */       }
/* 261 */       return this.currentIter.hasNext();
/*     */     }
/*     */ 
/*     */     public boolean hasPrevious()
/*     */     {
/* 266 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public Object next()
/*     */     {
/* 271 */       if (!hasNext())
/*     */       {
/* 273 */         throw new NoSuchElementException();
/*     */       }
/* 275 */       return this.currentIter.next();
/*     */     }
/*     */ 
/*     */     public int nextIndex()
/*     */     {
/* 280 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public Object previous()
/*     */     {
/* 285 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public int previousIndex()
/*     */     {
/* 290 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 295 */       this.currentIter.remove();
/*     */ 
/* 297 */       BasicPriorityLinkedList.this.size -= 1;
/*     */     }
/*     */ 
/*     */     public void set(Object obj)
/*     */     {
/* 302 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.prioritylinkedlist.BasicPriorityLinkedList
 * JD-Core Version:    0.6.0
 */