/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class Util
/*     */ {
/*  47 */   public static Logger log = Logger.getLogger(Util.class);
/*     */ 
/*     */   public static String guidToString(Object o)
/*     */   {
/*  53 */     if (o == null)
/*     */     {
/*  55 */       return "null";
/*     */     }
/*  57 */     if (!(o instanceof String))
/*     */     {
/*  59 */       return o.toString();
/*     */     }
/*  61 */     String s = (String)o;
/*  62 */     int idx = s.lastIndexOf('-', s.lastIndexOf(45) - 1);
/*  63 */     if (idx < 0)
/*     */     {
/*  65 */       return s;
/*     */     }
/*  67 */     return "...-" + s.substring(idx + 1);
/*     */   }
/*     */ 
/*     */   public static String transactionIsolationToString(int level)
/*     */   {
/*  74 */     return level == 8 ? "SERIALIZABLE" : level == 4 ? "REPEATABLE_READ" : level == 2 ? "READ_COMMITTED" : level == 1 ? "READ_UNCOMMITTED" : level == 0 ? "NONE" : "UNKNOWN";
/*     */   }
/*     */ 
/*     */   public static Element stringToElement(String s)
/*     */     throws Exception
/*     */   {
/*  89 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*  90 */     DocumentBuilder parser = factory.newDocumentBuilder();
/*  91 */     Document doc = parser.parse(new InputSource(new StringReader(s)));
/*  92 */     return doc.getDocumentElement();
/*     */   }
/*     */ 
/*     */   public static String deliveryMode(int m)
/*     */   {
/*  97 */     if (m == 1)
/*     */     {
/*  99 */       return "NON_PERSISTENT";
/*     */     }
/* 101 */     if (m == 2)
/*     */     {
/* 103 */       return "PERSISTENT";
/*     */     }
/* 105 */     return "UNKNOWN";
/*     */   }
/*     */ 
/*     */   public static String acknowledgmentMode(int ack)
/*     */   {
/* 110 */     if (ack == 1)
/*     */     {
/* 112 */       return "AUTO_ACKNOWLEDGE";
/*     */     }
/* 114 */     if (ack == 2)
/*     */     {
/* 116 */       return "CLIENT_ACKNOWLEDGE";
/*     */     }
/* 118 */     if (ack == 3)
/*     */     {
/* 120 */       return "DUPS_OK_ACKNOWLEDGE";
/*     */     }
/* 122 */     if (ack == 0)
/*     */     {
/* 124 */       return "SESSION_TRANSACTED";
/*     */     }
/* 126 */     return "UNKNOWN";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.Util
 * JD-Core Version:    0.6.0
 */