/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ 
/*     */ public class StreamUtils
/*     */ {
/*     */   private static final int BUFFER_SIZE = 4096;
/*     */   public static final byte NULL = 0;
/*     */   public static final byte STRING = 1;
/*     */   public static final byte MAP = 2;
/*     */   public static final byte BYTE = 3;
/*     */   public static final byte SHORT = 4;
/*     */   public static final byte INT = 5;
/*     */   public static final byte LONG = 6;
/*     */   public static final byte FLOAT = 7;
/*     */   public static final byte DOUBLE = 8;
/*     */   public static final byte BOOLEAN = 9;
/*     */   public static final byte BYTES = 10;
/*     */   public static final byte LIST = 11;
/*     */   public static final byte SERIALIZABLE = 12;
/*     */   public static final byte DESTINATION = 13;
/*     */ 
/*     */   public static Object readObject(DataInputStream in, boolean longStrings)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  87 */     byte type = in.readByte();
/*  88 */     Object value = null;
/*  89 */     switch (type)
/*     */     {
/*     */     case 0:
/*  93 */       value = null;
/*  94 */       break;
/*     */     case 1:
/*  97 */       if (longStrings)
/*     */       {
/* 100 */         value = SafeUTF.instance.safeReadUTF(in);
/*     */       }
/*     */       else
/*     */       {
/* 105 */         value = in.readUTF();
/*     */       }
/* 107 */       break;
/*     */     case 13:
/* 110 */       value = JBossDestination.readDestination(in);
/* 111 */       break;
/*     */     case 2:
/* 115 */       value = readMap(in, false);
/* 116 */       break;
/*     */     case 3:
/* 119 */       value = new Byte(in.readByte());
/* 120 */       break;
/*     */     case 4:
/* 122 */       value = new Short(in.readShort());
/* 123 */       break;
/*     */     case 5:
/* 125 */       value = new Integer(in.readInt());
/* 126 */       break;
/*     */     case 6:
/* 128 */       value = new Long(in.readLong());
/* 129 */       break;
/*     */     case 7:
/* 131 */       value = new Float(in.readFloat());
/* 132 */       break;
/*     */     case 8:
/* 134 */       value = new Double(in.readDouble());
/* 135 */       break;
/*     */     case 9:
/* 137 */       value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
/* 138 */       break;
/*     */     case 10:
/* 140 */       int size = in.readInt();
/* 141 */       byte[] bytes = new byte[size];
/* 142 */       in.readFully(bytes);
/* 143 */       value = bytes;
/* 144 */       break;
/*     */     case 11:
/* 147 */       value = readList(in);
/* 148 */       break;
/*     */     case 12:
/* 152 */       ObjectInputStream ois = new ObjectInputStreamWithClassLoader(in);
/*     */ 
/* 154 */       value = ois.readObject();
/* 155 */       break;
/*     */     default:
/* 159 */       throw new IllegalStateException("Unknown type: " + type);
/*     */     }
/*     */ 
/* 162 */     return value;
/*     */   }
/*     */ 
/*     */   public static void writeObject(DataOutputStream out, Object object, boolean containerTypes, boolean longStrings)
/*     */     throws IOException
/*     */   {
/* 169 */     if (object == null)
/*     */     {
/* 171 */       out.writeByte(0);
/*     */     }
/* 173 */     else if ((object instanceof String))
/*     */     {
/* 175 */       out.writeByte(1);
/* 176 */       if (longStrings)
/*     */       {
/* 179 */         SafeUTF.instance.safeWriteUTF(out, (String)object);
/*     */       }
/*     */       else
/*     */       {
/* 184 */         out.writeUTF((String)object);
/*     */       }
/*     */     }
/* 187 */     else if ((object instanceof JBossDestination))
/*     */     {
/* 189 */       out.writeByte(13);
/* 190 */       JBossDestination.writeDestination(out, (JBossDestination)object);
/*     */     }
/* 192 */     else if ((containerTypes) && ((object instanceof Map)))
/*     */     {
/* 194 */       out.writeByte(2);
/* 195 */       writeMap(out, (Map)object, false);
/*     */     }
/* 197 */     else if ((object instanceof Integer))
/*     */     {
/* 199 */       out.writeByte(5);
/* 200 */       out.writeInt(((Integer)object).intValue());
/*     */     }
/* 202 */     else if ((object instanceof Boolean))
/*     */     {
/* 204 */       out.writeByte(9);
/* 205 */       out.writeBoolean(((Boolean)object).booleanValue());
/*     */     }
/* 207 */     else if ((object instanceof Byte))
/*     */     {
/* 209 */       out.writeByte(3);
/* 210 */       out.writeByte(((Byte)object).byteValue());
/*     */     }
/* 212 */     else if ((object instanceof Short))
/*     */     {
/* 214 */       out.writeByte(4);
/* 215 */       out.writeShort(((Short)object).shortValue());
/*     */     }
/* 217 */     else if ((object instanceof Long))
/*     */     {
/* 219 */       out.writeByte(6);
/* 220 */       out.writeLong(((Long)object).longValue());
/*     */     }
/* 222 */     else if ((object instanceof Float))
/*     */     {
/* 224 */       out.writeByte(7);
/* 225 */       out.writeFloat(((Float)object).floatValue());
/*     */     }
/* 227 */     else if ((object instanceof Double))
/*     */     {
/* 229 */       out.writeByte(8);
/* 230 */       out.writeDouble(((Double)object).doubleValue());
/*     */     }
/* 232 */     else if ((object instanceof byte[]))
/*     */     {
/* 234 */       out.writeByte(10);
/* 235 */       byte[] bytes = (byte[])(byte[])object;
/* 236 */       out.writeInt(bytes.length);
/* 237 */       out.write(bytes);
/*     */     }
/* 239 */     else if ((containerTypes) && ((object instanceof List)))
/*     */     {
/* 241 */       out.write(11);
/* 242 */       writeList(out, (List)object);
/*     */     }
/* 244 */     else if ((object instanceof Serializable))
/*     */     {
/* 246 */       out.writeByte(12);
/* 247 */       ObjectOutputStream oos = new ObjectOutputStream(out);
/*     */ 
/* 249 */       oos.writeObject(object);
/* 250 */       oos.flush();
/*     */     }
/*     */     else
/*     */     {
/* 254 */       throw new IllegalArgumentException("Don't know how to deal with object " + object);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void writeList(DataOutputStream out, List list) throws IOException
/*     */   {
/* 260 */     out.writeInt(list.size());
/* 261 */     Iterator iter = list.iterator();
/* 262 */     while (iter.hasNext())
/*     */     {
/* 264 */       Object value = iter.next();
/* 265 */       writeObject(out, value, false, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static ArrayList readList(DataInputStream in) throws ClassNotFoundException, IOException
/*     */   {
/* 271 */     int size = in.readInt();
/* 272 */     ArrayList list = new ArrayList(size);
/* 273 */     for (int i = 0; i < size; i++)
/*     */     {
/* 275 */       Object obj = readObject(in, false);
/* 276 */       list.add(obj);
/*     */     }
/* 278 */     return list;
/*     */   }
/*     */ 
/*     */   public static void writeMap(DataOutputStream out, Map map, boolean stringKeys) throws IOException
/*     */   {
/* 283 */     Set entrySet = map.entrySet();
/* 284 */     out.writeInt(entrySet.size());
/* 285 */     for (Iterator it = entrySet.iterator(); it.hasNext(); )
/*     */     {
/* 287 */       Map.Entry me = (Map.Entry)it.next();
/*     */ 
/* 290 */       if (stringKeys)
/*     */       {
/* 292 */         out.writeUTF((String)me.getKey());
/*     */       }
/*     */       else
/*     */       {
/* 296 */         writeObject(out, me.getKey(), false, false);
/*     */       }
/*     */ 
/* 300 */       writeObject(out, me.getValue(), false, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static HashMap readMap(DataInputStream in, boolean stringKeys) throws IOException, ClassNotFoundException
/*     */   {
/* 306 */     int size = in.readInt();
/* 307 */     HashMap m = new HashMap(size);
/* 308 */     for (int i = 0; i < size; i++)
/*     */     {
/*     */       Object key;
/*     */       Object key;
/* 311 */       if (stringKeys)
/*     */       {
/* 313 */         key = in.readUTF();
/*     */       }
/*     */       else
/*     */       {
/* 317 */         key = readObject(in, false);
/*     */       }
/*     */ 
/* 320 */       Object value = readObject(in, false);
/*     */ 
/* 322 */       m.put(key, value);
/*     */     }
/* 324 */     return m;
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(Streamable streamable) throws Exception
/*     */   {
/* 329 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
/*     */ 
/* 331 */     DataOutputStream daos = new DataOutputStream(baos);
/*     */ 
/* 333 */     streamable.write(daos);
/*     */ 
/* 335 */     daos.close();
/*     */ 
/* 337 */     return baos.toByteArray();
/*     */   }
/*     */ 
/*     */   public static void fromBytes(Streamable streamable, byte[] bytes) throws Exception
/*     */   {
/* 342 */     ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
/*     */ 
/* 344 */     DataInputStream dais = new DataInputStream(bais);
/*     */ 
/* 346 */     streamable.read(dais);
/*     */ 
/* 348 */     dais.close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.StreamUtils
 * JD-Core Version:    0.6.0
 */