/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class SafeUTF
/*     */ {
/*     */   private static final int CHUNK_SIZE = 16384;
/*     */   private static final byte NULL = 0;
/*     */   private static final byte NOT_NULL = 1;
/*  60 */   public static SafeUTF instance = new SafeUTF(16384);
/*     */   private int chunkSize;
/*     */   private int lastReadBufferSize;
/*     */ 
/*     */   public int getLastReadBufferSize()
/*     */   {
/*  68 */     return this.lastReadBufferSize;
/*     */   }
/*     */ 
/*     */   public SafeUTF(int chunkSize)
/*     */   {
/*  73 */     this.chunkSize = chunkSize;
/*     */   }
/*     */ 
/*     */   public void safeWriteUTF(DataOutputStream out, String str) throws IOException
/*     */   {
/*  78 */     if (str == null)
/*     */     {
/*  80 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/*  84 */       int len = str.length();
/*     */       short numChunks;
/*     */       short numChunks;
/*  88 */       if (len == 0)
/*     */       {
/*  90 */         numChunks = 0;
/*     */       }
/*     */       else
/*     */       {
/*  94 */         numChunks = (short)((len - 1) / this.chunkSize + 1);
/*     */       }
/*     */ 
/*  97 */       out.writeByte(1);
/*     */ 
/*  99 */       out.writeShort(numChunks);
/*     */ 
/* 101 */       int i = 0;
/* 102 */       while (len > 0)
/*     */       {
/* 104 */         int beginCopy = i * this.chunkSize;
/*     */ 
/* 106 */         int endCopy = len <= this.chunkSize ? beginCopy + len : beginCopy + this.chunkSize;
/*     */ 
/* 108 */         String theChunk = str.substring(beginCopy, endCopy);
/*     */ 
/* 110 */         out.writeUTF(theChunk);
/*     */ 
/* 112 */         len -= this.chunkSize;
/*     */ 
/* 114 */         i++;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String safeReadUTF(DataInputStream in) throws IOException
/*     */   {
/* 121 */     boolean isNull = in.readByte() == 0;
/*     */ 
/* 123 */     if (isNull)
/*     */     {
/* 125 */       return null;
/*     */     }
/*     */ 
/* 128 */     short numChunks = in.readShort();
/*     */ 
/* 130 */     int bufferSize = this.chunkSize * numChunks;
/*     */ 
/* 133 */     if (numChunks == 1)
/*     */     {
/* 141 */       int inSize = in.available();
/*     */ 
/* 143 */       if (inSize <= 0)
/*     */       {
/* 145 */         inSize = 256;
/*     */       }
/*     */ 
/* 148 */       bufferSize = Math.min(inSize, bufferSize);
/*     */ 
/* 150 */       this.lastReadBufferSize = bufferSize;
/*     */     }
/*     */ 
/* 153 */     StringBuffer buff = new StringBuffer(bufferSize);
/*     */ 
/* 155 */     for (int i = 0; i < numChunks; i++)
/*     */     {
/* 157 */       String s = in.readUTF();
/*     */ 
/* 159 */       buff.append(s);
/*     */     }
/*     */ 
/* 162 */     return buff.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.SafeUTF
 * JD-Core Version:    0.6.0
 */