/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.util.StringTokenizer;
/*     */ import javax.naming.Binding;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ 
/*     */ public class JNDIUtil
/*     */ {
/*     */   public static Context createContext(Context c, String path)
/*     */     throws NamingException
/*     */   {
/*  49 */     Context crtContext = c;
/*  50 */     for (StringTokenizer st = new StringTokenizer(path, "/"); st.hasMoreTokens(); )
/*     */     {
/*  52 */       String tok = st.nextToken();
/*     */       try
/*     */       {
/*  56 */         Object o = crtContext.lookup(tok);
/*  57 */         if (!(o instanceof Context))
/*     */         {
/*  59 */           throw new NamingException("Path " + path + " overwrites and already bound object");
/*     */         }
/*  61 */         crtContext = (Context)o;
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/*  68 */         crtContext = crtContext.createSubcontext(tok);
/*     */       }
/*     */     }
/*  70 */     return crtContext;
/*     */   }
/*     */ 
/*     */   public static void tearDownRecursively(Context c) throws Exception
/*     */   {
/*  75 */     for (NamingEnumeration ne = c.listBindings(""); ne.hasMore(); )
/*     */     {
/*  77 */       Binding b = (Binding)ne.next();
/*  78 */       String name = b.getName();
/*  79 */       Object object = b.getObject();
/*  80 */       if ((object instanceof Context))
/*     */       {
/*  82 */         tearDownRecursively((Context)object);
/*     */       }
/*  84 */       c.unbind(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void rebind(Context c, String jndiName, Object o)
/*     */     throws NamingException
/*     */   {
/*  96 */     Context context = c;
/*  97 */     String name = jndiName;
/*     */ 
/*  99 */     int idx = jndiName.lastIndexOf('/');
/* 100 */     if (idx != -1)
/*     */     {
/* 102 */       context = createContext(c, jndiName.substring(0, idx));
/* 103 */       name = jndiName.substring(idx + 1);
/*     */     }
/* 105 */     boolean failed = false;
/*     */     try
/*     */     {
/* 108 */       context.rebind(name, o);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 112 */       failed = true;
/*     */     }
/* 114 */     if (failed)
/*     */     {
/* 116 */       context.bind(name, o);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.JNDIUtil
 * JD-Core Version:    0.6.0
 */