/*     */ package org.jboss.messaging.core.jmx;
/*     */ 
/*     */ import java.util.Set;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.jms.server.JMSConditionFactory;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.selector.SelectorFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.ChannelFactory;
/*     */ import org.jboss.messaging.core.contract.ClusterNotifier;
/*     */ import org.jboss.messaging.core.contract.ConditionFactory;
/*     */ import org.jboss.messaging.core.contract.FilterFactory;
/*     */ import org.jboss.messaging.core.contract.MessageStore;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager;
/*     */ import org.jboss.messaging.core.impl.IDManager;
/*     */ import org.jboss.messaging.core.impl.jchannelfactory.MultiplexerChannelFactory;
/*     */ import org.jboss.messaging.core.impl.jchannelfactory.XMLChannelFactory;
/*     */ import org.jboss.messaging.core.impl.postoffice.MessagingPostOffice;
/*     */ import org.jboss.messaging.core.impl.tx.TransactionRepository;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.JMXAccessor;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class MessagingPostOfficeService extends JDBCServiceSupport
/*     */ {
/*     */   private boolean started;
/*     */   private Element controlChannelConfig;
/*     */   private Element dataChannelConfig;
/*     */   private ObjectName channelFactoryName;
/*     */   private String controlChannelName;
/*     */   private String dataChannelName;
/*     */   private String channelPartitionName;
/*     */   private ObjectName serverPeerObjectName;
/*     */   private String officeName;
/*  91 */   private long stateTimeout = 5000L;
/*     */ 
/*  93 */   private long castTimeout = 5000L;
/*     */   private String groupName;
/*     */   private boolean clustered;
/*  99 */   private int maxConcurrentReplications = 25;
/*     */   private MessagingPostOffice postOffice;
/*     */ 
/*     */   public MessagingComponent getInstance()
/*     */   {
/* 109 */     return this.postOffice;
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object)
/*     */     throws IllegalArgumentException
/*     */   {
/* 118 */     this.postOffice.addNotificationListener(listener, filter, object);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 124 */     this.postOffice.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 129 */     return this.postOffice.getNotificationInfo();
/*     */   }
/*     */ 
/*     */   public synchronized ObjectName getServerPeer()
/*     */   {
/* 137 */     return this.serverPeerObjectName;
/*     */   }
/*     */ 
/*     */   public synchronized void setServerPeer(ObjectName on)
/*     */   {
/* 142 */     if (this.started)
/*     */     {
/* 144 */       this.log.warn("Cannot set attribute when service is started");
/* 145 */       return;
/*     */     }
/* 147 */     this.serverPeerObjectName = on;
/*     */   }
/*     */ 
/*     */   public synchronized String getPostOfficeName()
/*     */   {
/* 152 */     return this.officeName;
/*     */   }
/*     */ 
/*     */   public synchronized void setPostOfficeName(String name)
/*     */   {
/* 157 */     if (this.started)
/*     */     {
/* 159 */       this.log.warn("Cannot set attribute when service is started");
/* 160 */       return;
/*     */     }
/* 162 */     this.officeName = name;
/*     */   }
/*     */ 
/*     */   public ObjectName getChannelFactoryName()
/*     */   {
/* 167 */     return this.channelFactoryName;
/*     */   }
/*     */ 
/*     */   public void setChannelFactoryName(ObjectName channelFactoryName)
/*     */   {
/* 172 */     if (this.started)
/*     */     {
/* 174 */       this.log.warn("Cannot set attribute when service is started");
/* 175 */       return;
/*     */     }
/* 177 */     this.channelFactoryName = channelFactoryName;
/*     */   }
/*     */ 
/*     */   public String getControlChannelName()
/*     */   {
/* 182 */     return this.controlChannelName;
/*     */   }
/*     */ 
/*     */   public void setControlChannelName(String controlChannelName)
/*     */   {
/* 187 */     if (this.started)
/*     */     {
/* 189 */       this.log.warn("Cannot set attribute when service is started");
/* 190 */       return;
/*     */     }
/* 192 */     this.controlChannelName = controlChannelName;
/*     */   }
/*     */ 
/*     */   public String getDataChannelName()
/*     */   {
/* 197 */     return this.dataChannelName;
/*     */   }
/*     */ 
/*     */   public void setDataChannelName(String dataChannelName)
/*     */   {
/* 202 */     if (this.started)
/*     */     {
/* 204 */       this.log.warn("Cannot set attribute when service is started");
/* 205 */       return;
/*     */     }
/* 207 */     this.dataChannelName = dataChannelName;
/*     */   }
/*     */ 
/*     */   public String getChannelPartitionName()
/*     */   {
/* 212 */     return this.channelPartitionName;
/*     */   }
/*     */ 
/*     */   public void setChannelPartitionName(String channelPartitionName)
/*     */   {
/* 217 */     if (this.started)
/*     */     {
/* 219 */       this.log.warn("Cannot set attribute when service is started");
/* 220 */       return;
/*     */     }
/* 222 */     this.channelPartitionName = channelPartitionName;
/*     */   }
/*     */ 
/*     */   public void setControlChannelConfig(Element config) throws Exception
/*     */   {
/* 227 */     if (this.started)
/*     */     {
/* 229 */       this.log.warn("Cannot set attribute when service is started");
/* 230 */       return;
/*     */     }
/* 232 */     this.controlChannelConfig = config;
/*     */   }
/*     */ 
/*     */   public Element getControlChannelConfig()
/*     */   {
/* 237 */     return this.controlChannelConfig;
/*     */   }
/*     */ 
/*     */   public void setDataChannelConfig(Element config) throws Exception
/*     */   {
/* 242 */     if (this.started)
/*     */     {
/* 244 */       this.log.warn("Cannot set attribute when service is started");
/* 245 */       return;
/*     */     }
/* 247 */     this.dataChannelConfig = config;
/*     */   }
/*     */ 
/*     */   public Element getDataChannelConfig()
/*     */   {
/* 252 */     return this.dataChannelConfig;
/*     */   }
/*     */ 
/*     */   public void setStateTimeout(long timeout)
/*     */   {
/* 257 */     if (this.started)
/*     */     {
/* 259 */       this.log.warn("Cannot set attribute when service is started");
/* 260 */       return;
/*     */     }
/* 262 */     this.stateTimeout = timeout;
/*     */   }
/*     */ 
/*     */   public long getStateTimeout()
/*     */   {
/* 267 */     return this.stateTimeout;
/*     */   }
/*     */ 
/*     */   public void setCastTimeout(long timeout)
/*     */   {
/* 272 */     if (this.started)
/*     */     {
/* 274 */       this.log.warn("Cannot set attribute when service is started");
/* 275 */       return;
/*     */     }
/* 277 */     this.castTimeout = timeout;
/*     */   }
/*     */ 
/*     */   public long getCastTimeout()
/*     */   {
/* 282 */     return this.castTimeout;
/*     */   }
/*     */ 
/*     */   public void setGroupName(String groupName)
/*     */   {
/* 287 */     this.groupName = groupName;
/*     */   }
/*     */ 
/*     */   public String getGroupName()
/*     */   {
/* 292 */     return this.groupName;
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 297 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   public void setClustered(boolean clustered)
/*     */   {
/* 302 */     if (this.started)
/*     */     {
/* 304 */       this.log.warn("Cannot set attribute when service is started");
/* 305 */       return;
/*     */     }
/* 307 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public int getMaxConcurrentReplications()
/*     */   {
/* 312 */     return this.maxConcurrentReplications;
/*     */   }
/*     */ 
/*     */   public void setMaxConcurrentReplications(int number)
/*     */   {
/* 317 */     this.maxConcurrentReplications = number;
/*     */   }
/*     */ 
/*     */   public String listBindings()
/*     */   {
/* 322 */     return this.postOffice.printBindingInformation();
/*     */   }
/*     */ 
/*     */   public Set getNodeIDView()
/*     */   {
/* 327 */     return this.postOffice.nodeIDView();
/*     */   }
/*     */ 
/*     */   protected synchronized void startService()
/*     */     throws Exception
/*     */   {
/* 338 */     if (this.started)
/*     */     {
/* 340 */       throw new IllegalStateException("Service is already started");
/*     */     }
/*     */ 
/* 343 */     super.startService();
/*     */     try
/*     */     {
/* 347 */       TransactionManager tm = getTransactionManagerReference();
/*     */ 
/* 349 */       ServerPeer serverPeer = (ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance");
/*     */ 
/* 351 */       MessageStore ms = serverPeer.getMessageStore();
/*     */ 
/* 353 */       PersistenceManager pm = serverPeer.getPersistenceManagerInstance();
/*     */ 
/* 355 */       TransactionRepository tr = serverPeer.getTxRepository();
/*     */ 
/* 357 */       IDManager idManager = serverPeer.getChannelIDManager();
/*     */ 
/* 359 */       int nodeId = serverPeer.getServerPeerID();
/*     */ 
/* 361 */       ClusterNotifier clusterNotifier = serverPeer.getClusterNotifier();
/*     */ 
/* 363 */       ConditionFactory cf = new JMSConditionFactory();
/*     */ 
/* 365 */       FilterFactory ff = new SelectorFactory();
/*     */ 
/* 367 */       if (this.clustered)
/*     */       {
/* 369 */         ChannelFactory jChannelFactory = null;
/*     */ 
/* 371 */         if (this.channelFactoryName != null)
/*     */         {
/* 373 */           Object info = null;
/*     */           try
/*     */           {
/* 376 */             info = this.server.getMBeanInfo(this.channelFactoryName);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*     */           }
/*     */ 
/* 385 */           if (info != null)
/*     */           {
/* 387 */             this.log.debug(this + " uses MultiplexerJChannelFactory");
/*     */ 
/* 389 */             jChannelFactory = new MultiplexerChannelFactory(this.server, this.channelFactoryName, this.channelPartitionName, this.controlChannelName, this.dataChannelName);
/*     */           }
/*     */           else
/*     */           {
/* 395 */             this.log.debug(this + " uses XMLJChannelFactory");
/* 396 */             jChannelFactory = new XMLChannelFactory(this.controlChannelConfig, this.dataChannelConfig);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 401 */           this.log.debug(this + " uses XMLJChannelFactory");
/* 402 */           jChannelFactory = new XMLChannelFactory(this.controlChannelConfig, this.dataChannelConfig);
/*     */         }
/*     */ 
/* 405 */         this.postOffice = new MessagingPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf, idManager, clusterNotifier, this.groupName, jChannelFactory, this.stateTimeout, this.castTimeout, serverPeer.isSupportsFailover(), this.maxConcurrentReplications);
/*     */       }
/*     */       else
/*     */       {
/* 419 */         this.postOffice = new MessagingPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf, idManager, clusterNotifier);
/*     */       }
/*     */ 
/* 427 */       this.postOffice.start();
/*     */ 
/* 429 */       this.started = true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 433 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 439 */     if (!this.started)
/*     */     {
/* 441 */       throw new IllegalStateException("Service is not started");
/*     */     }
/*     */ 
/* 444 */     super.stopService();
/*     */     try
/*     */     {
/* 448 */       this.postOffice.stop();
/*     */ 
/* 450 */       this.postOffice = null;
/*     */ 
/* 452 */       this.started = false;
/*     */ 
/* 454 */       this.log.debug(this + " stopped");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 458 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.jmx.MessagingPostOfficeService
 * JD-Core Version:    0.6.0
 */