/*     */ package org.jboss.messaging.core.jmx;
/*     */ 
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager;
/*     */ import org.jboss.messaging.core.impl.JDBCPersistenceManager;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ 
/*     */ public class JDBCPersistenceManagerService extends JDBCServiceSupport
/*     */ {
/*     */   private PersistenceManager persistenceManager;
/*     */   private boolean started;
/*     */   private boolean usingBatchUpdates;
/*  50 */   private boolean usingBinaryStream = true;
/*     */   private boolean usingTrailingByte;
/*  54 */   private int maxParams = 100;
/*     */ 
/*  56 */   private boolean supportsBlobOnSelect = true;
/*     */ 
/*     */   public MessagingComponent getInstance()
/*     */   {
/*  68 */     return this.persistenceManager;
/*     */   }
/*     */ 
/*     */   protected synchronized void startService()
/*     */     throws Exception
/*     */   {
/*  75 */     if (this.started)
/*     */     {
/*  77 */       throw new IllegalStateException("Service is already started");
/*     */     }
/*     */ 
/*  80 */     super.startService();
/*     */     try
/*     */     {
/*  84 */       TransactionManager tm = getTransactionManagerReference();
/*     */ 
/*  86 */       this.persistenceManager = new JDBCPersistenceManager(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, this.usingBatchUpdates, this.usingBinaryStream, this.usingTrailingByte, this.maxParams, this.supportsBlobOnSelect);
/*     */ 
/*  92 */       this.persistenceManager.start();
/*     */ 
/*  94 */       this.started = true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  98 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 104 */     if (!this.started)
/*     */     {
/* 106 */       throw new IllegalStateException("Service is not started");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 111 */       this.persistenceManager.stop();
/*     */ 
/* 113 */       this.persistenceManager = null;
/*     */ 
/* 115 */       this.started = false;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 119 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */ 
/* 122 */     this.log.debug(this + " stopped");
/*     */   }
/*     */ 
/*     */   public boolean isUsingBatchUpdates()
/*     */   {
/* 129 */     return this.usingBatchUpdates;
/*     */   }
/*     */ 
/*     */   public void setUsingBatchUpdates(boolean b)
/*     */   {
/* 134 */     this.usingBatchUpdates = b;
/*     */   }
/*     */ 
/*     */   public int getMaxParams()
/*     */   {
/* 139 */     return this.maxParams;
/*     */   }
/*     */ 
/*     */   public void setMaxParams(int maxParams)
/*     */   {
/* 144 */     this.maxParams = maxParams;
/*     */   }
/*     */ 
/*     */   public boolean isUsingBinaryStream()
/*     */   {
/* 149 */     return this.usingBinaryStream;
/*     */   }
/*     */ 
/*     */   public void setUsingBinaryStream(boolean b)
/*     */   {
/* 154 */     this.usingBinaryStream = b;
/*     */   }
/*     */ 
/*     */   public boolean isUsingTrailingByte()
/*     */   {
/* 159 */     return this.usingTrailingByte;
/*     */   }
/*     */ 
/*     */   public void setUsingTrailingByte(boolean b)
/*     */   {
/* 164 */     this.usingTrailingByte = b;
/*     */   }
/*     */ 
/*     */   public boolean isSupportsBlobOnSelect()
/*     */   {
/* 169 */     return this.supportsBlobOnSelect;
/*     */   }
/*     */ 
/*     */   public void setSupportsBlobOnSelect(boolean b)
/*     */   {
/* 174 */     this.supportsBlobOnSelect = b;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.jmx.JDBCPersistenceManagerService
 * JD-Core Version:    0.6.0
 */