/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import java.util.Map;
/*    */ import org.jboss.messaging.core.contract.Message;
/*    */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*    */ import org.jboss.messaging.util.StreamUtils;
/*    */ import org.jboss.messaging.util.Streamable;
/*    */ 
/*    */ class MessageHolder
/*    */   implements Streamable
/*    */ {
/*    */   private String routingKeyText;
/*    */   private Message message;
/*    */   private Map queueNameToNodeIdMap;
/*    */ 
/*    */   public MessageHolder()
/*    */   {
/*    */   }
/*    */ 
/*    */   MessageHolder(String routingKeyText, Message message, Map queueNameToNodeIdMap)
/*    */   {
/* 56 */     this.routingKeyText = routingKeyText;
/*    */ 
/* 58 */     this.message = message;
/*    */ 
/* 60 */     this.queueNameToNodeIdMap = queueNameToNodeIdMap;
/*    */   }
/*    */ 
/*    */   String getRoutingKey()
/*    */   {
/* 65 */     return this.routingKeyText;
/*    */   }
/*    */ 
/*    */   Message getMessage()
/*    */   {
/* 70 */     return this.message;
/*    */   }
/*    */ 
/*    */   Map getQueueNameToNodeIdMap()
/*    */   {
/* 75 */     return this.queueNameToNodeIdMap;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 80 */     this.routingKeyText = in.readUTF();
/*    */ 
/* 82 */     byte type = in.readByte();
/*    */ 
/* 84 */     this.message = MessageFactory.createMessage(type);
/* 85 */     this.message.read(in);
/*    */ 
/* 87 */     this.queueNameToNodeIdMap = ((Map)StreamUtils.readObject(in, false));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 92 */     out.writeUTF(this.routingKeyText);
/*    */ 
/* 94 */     out.writeByte(this.message.getType());
/* 95 */     this.message.write(out);
/*    */ 
/* 97 */     StreamUtils.writeObject(out, this.queueNameToNodeIdMap, true, false);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.MessageHolder
 * JD-Core Version:    0.6.0
 */