/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.messaging.util.StreamUtils;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ class MappingInfo
/*     */   implements Streamable
/*     */ {
/*     */   private int nodeId;
/*     */   private String conditionText;
/*     */   private String filterString;
/*     */   private long channelId;
/*     */   private boolean recoverable;
/*     */   private int maxSize;
/*     */   private String queueName;
/*     */   private boolean clustered;
/*     */   private int fullSize;
/*     */   private int pageSize;
/*     */   private int downCacheSize;
/*     */   private boolean allNodes;
/*     */   private long recoverDeliveriesTimeout;
/*     */ 
/*     */   MappingInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   MappingInfo(int nodeId, String queueName, String conditionText, String filterString, long channelId, boolean recoverable, boolean clustered, boolean allNodes)
/*     */   {
/*  78 */     this.nodeId = nodeId;
/*     */ 
/*  80 */     this.queueName = queueName;
/*     */ 
/*  82 */     this.conditionText = conditionText;
/*     */ 
/*  84 */     this.filterString = filterString;
/*     */ 
/*  86 */     this.channelId = channelId;
/*     */ 
/*  88 */     this.recoverable = recoverable;
/*     */ 
/*  90 */     this.clustered = clustered;
/*     */ 
/*  92 */     this.allNodes = allNodes;
/*     */   }
/*     */ 
/*     */   MappingInfo(int nodeId, String queueName, String conditionText, String filterString, long channelId, boolean recoverable, boolean clustered, boolean allNodes, int fullSize, int pageSize, int downCacheSize, int maxSize, long recoverDeliveriesTimeout)
/*     */   {
/* 100 */     this(nodeId, queueName, conditionText, filterString, channelId, recoverable, clustered, allNodes);
/*     */ 
/* 102 */     this.fullSize = fullSize;
/*     */ 
/* 104 */     this.pageSize = pageSize;
/*     */ 
/* 106 */     this.downCacheSize = downCacheSize;
/*     */ 
/* 108 */     this.maxSize = maxSize;
/*     */ 
/* 110 */     this.recoverDeliveriesTimeout = recoverDeliveriesTimeout;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 117 */     this.nodeId = in.readInt();
/*     */ 
/* 119 */     this.queueName = in.readUTF();
/*     */ 
/* 121 */     this.conditionText = in.readUTF();
/*     */ 
/* 123 */     this.filterString = ((String)StreamUtils.readObject(in, false));
/*     */ 
/* 125 */     this.channelId = in.readLong();
/*     */ 
/* 127 */     this.recoverable = in.readBoolean();
/*     */ 
/* 129 */     this.clustered = in.readBoolean();
/*     */ 
/* 131 */     this.allNodes = in.readBoolean();
/*     */ 
/* 133 */     this.fullSize = in.readInt();
/*     */ 
/* 135 */     this.pageSize = in.readInt();
/*     */ 
/* 137 */     this.downCacheSize = in.readInt();
/*     */ 
/* 139 */     this.maxSize = in.readInt();
/*     */ 
/* 141 */     this.recoverDeliveriesTimeout = in.readLong();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 146 */     out.writeInt(this.nodeId);
/*     */ 
/* 148 */     out.writeUTF(this.queueName);
/*     */ 
/* 150 */     out.writeUTF(this.conditionText);
/*     */ 
/* 152 */     StreamUtils.writeObject(out, this.filterString, false, false);
/*     */ 
/* 154 */     out.writeLong(this.channelId);
/*     */ 
/* 156 */     out.writeBoolean(this.recoverable);
/*     */ 
/* 158 */     out.writeBoolean(this.clustered);
/*     */ 
/* 160 */     out.writeBoolean(this.allNodes);
/*     */ 
/* 162 */     out.writeInt(this.fullSize);
/*     */ 
/* 164 */     out.writeInt(this.pageSize);
/*     */ 
/* 166 */     out.writeInt(this.downCacheSize);
/*     */ 
/* 168 */     out.writeInt(this.maxSize);
/*     */ 
/* 170 */     out.writeLong(this.recoverDeliveriesTimeout);
/*     */   }
/*     */ 
/*     */   int getNodeId()
/*     */   {
/* 175 */     return this.nodeId;
/*     */   }
/*     */ 
/*     */   String getQueueName()
/*     */   {
/* 180 */     return this.queueName;
/*     */   }
/*     */ 
/*     */   long getChannelId()
/*     */   {
/* 185 */     return this.channelId;
/*     */   }
/*     */ 
/*     */   String getConditionText()
/*     */   {
/* 190 */     return this.conditionText;
/*     */   }
/*     */ 
/*     */   boolean isRecoverable()
/*     */   {
/* 195 */     return this.recoverable;
/*     */   }
/*     */ 
/*     */   String getFilterString()
/*     */   {
/* 200 */     return this.filterString;
/*     */   }
/*     */ 
/*     */   boolean isClustered()
/*     */   {
/* 205 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   boolean isAllNodes()
/*     */   {
/* 210 */     return this.allNodes;
/*     */   }
/*     */ 
/*     */   int getFullSize()
/*     */   {
/* 215 */     return this.fullSize;
/*     */   }
/*     */ 
/*     */   int getPageSize()
/*     */   {
/* 220 */     return this.pageSize;
/*     */   }
/*     */ 
/*     */   int getDownCacheSize()
/*     */   {
/* 225 */     return this.downCacheSize;
/*     */   }
/*     */ 
/*     */   int getMaxSize()
/*     */   {
/* 230 */     return this.maxSize;
/*     */   }
/*     */ 
/*     */   long getRecoverDeliveriesTimeout()
/*     */   {
/* 235 */     return this.recoverDeliveriesTimeout;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.MappingInfo
 * JD-Core Version:    0.6.0
 */