/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ 
/*    */ class JoinClusterRequest extends ClusterRequest
/*    */ {
/*    */   private int nodeId;
/*    */   private PostOfficeAddressInfo info;
/*    */ 
/*    */   JoinClusterRequest(int nodeId, PostOfficeAddressInfo info)
/*    */   {
/* 30 */     this.nodeId = nodeId;
/*    */ 
/* 32 */     this.info = info;
/*    */   }
/*    */ 
/*    */   JoinClusterRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out)
/*    */     throws Exception
/*    */   {
/* 43 */     out.writeInt(this.nodeId);
/*    */ 
/* 45 */     this.info.write(out);
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 50 */     this.nodeId = in.readInt();
/*    */ 
/* 52 */     this.info = new PostOfficeAddressInfo();
/*    */ 
/* 54 */     this.info.read(in);
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 61 */     return "JoinClusterRequest[info=" + this.info + "]";
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office)
/*    */     throws Throwable
/*    */   {
/* 68 */     office.handleNodeJoined(this.nodeId, this.info);
/*    */ 
/* 70 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 75 */     return 1;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.JoinClusterRequest
 * JD-Core Version:    0.6.0
 */