/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ abstract class ClusterRequest
/*     */   implements Streamable
/*     */ {
/*     */   public static final int JOIN_CLUSTER_REQUEST = 1;
/*     */   public static final int LEAVE_CLUSTER_REQUEST = 2;
/*     */   public static final int BIND_REQUEST = 3;
/*     */   public static final int UNBIND_REQUEST = 4;
/*     */   public static final int MESSAGE_REQUEST = 5;
/*     */   public static final int PUT_REPLICANT_REQUEST = 6;
/*     */   public static final int REMOVE_REPLICANT_REQUEST = 7;
/*     */   public static final int REPLICATE_DELIVERY_REQUEST = 8;
/*     */   public static final int REPLICATE_DELIVERY_ACK_REQUEST = 9;
/*     */   public static final int REPLICATE_ACK_REQUEST = 10;
/*     */   public static final int ACK_ALL_REPLICATED_DELIVERIES_REQUEST = 11;
/*     */   public static final int ADD_ALL_REPLICATED_DELIVERIES_REQUEST = 12;
/*     */   public static final int GET_REPLICATED_DELIVERIES_REQUEST = 13;
/*     */   protected static final int NULL = 0;
/*     */   protected static final int NOT_NULL = 1;
/*     */ 
/*     */   static ClusterRequest createFromStream(DataInputStream dais)
/*     */     throws Exception
/*     */   {
/*  79 */     byte type = dais.readByte();
/*     */ 
/*  81 */     ClusterRequest request = null;
/*     */ 
/*  83 */     switch (type)
/*     */     {
/*     */     case 5:
/*  87 */       request = new MessageRequest();
/*  88 */       break;
/*     */     case 3:
/*  92 */       request = new BindRequest();
/*  93 */       break;
/*     */     case 4:
/*  97 */       request = new UnbindRequest();
/*  98 */       break;
/*     */     case 1:
/* 102 */       request = new JoinClusterRequest();
/* 103 */       break;
/*     */     case 2:
/* 107 */       request = new LeaveClusterRequest();
/* 108 */       break;
/*     */     case 6:
/* 112 */       request = new PutReplicantRequest();
/* 113 */       break;
/*     */     case 7:
/* 118 */       request = new RemoveReplicantRequest();
/* 119 */       break;
/*     */     case 8:
/* 123 */       request = new ReplicateDeliveryMessage();
/* 124 */       break;
/*     */     case 9:
/* 128 */       request = new ReplicateDeliveryAckMessage();
/* 129 */       break;
/*     */     case 10:
/* 133 */       request = new ReplicateAckMessage();
/* 134 */       break;
/*     */     case 11:
/* 138 */       request = new AckAllReplicatedDeliveriesMessage();
/* 139 */       break;
/*     */     case 12:
/* 143 */       request = new AddAllReplicatedDeliveriesMessage();
/* 144 */       break;
/*     */     case 13:
/* 148 */       request = new GetReplicatedDeliveriesRequest();
/* 149 */       break;
/*     */     default:
/* 153 */       throw new IllegalArgumentException("Invalid type: " + type);
/*     */     }
/*     */ 
/* 157 */     request.read(dais);
/*     */ 
/* 159 */     return request;
/*     */   }
/*     */ 
/*     */   public static void writeToStream(DataOutputStream daos, ClusterRequest request) throws Exception
/*     */   {
/* 164 */     daos.writeByte(request.getType());
/*     */ 
/* 166 */     request.write(daos);
/*     */   }
/*     */ 
/*     */   abstract Object execute(RequestTarget paramRequestTarget)
/*     */     throws Throwable;
/*     */ 
/*     */   abstract byte getType();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.ClusterRequest
 * JD-Core Version:    0.6.0
 */