/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class AddAllReplicatedDeliveriesMessage extends ClusterRequest
/*     */ {
/*     */   private int nodeID;
/*     */   private Map deliveries;
/*     */ 
/*     */   public AddAllReplicatedDeliveriesMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AddAllReplicatedDeliveriesMessage(int nodeID, Map deliveries)
/*     */   {
/*  52 */     this.nodeID = nodeID;
/*     */ 
/*  54 */     this.deliveries = deliveries;
/*     */   }
/*     */ 
/*     */   Object execute(RequestTarget office) throws Throwable
/*     */   {
/*  59 */     office.handleAddAllReplicatedDeliveries(this.nodeID, this.deliveries);
/*     */ 
/*  61 */     return null;
/*     */   }
/*     */ 
/*     */   byte getType()
/*     */   {
/*  66 */     return 12;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/*  71 */     this.nodeID = in.readInt();
/*     */ 
/*  73 */     int size = in.readInt();
/*     */ 
/*  75 */     this.deliveries = new HashMap(size);
/*     */ 
/*  77 */     for (int i = 0; i < size; i++)
/*     */     {
/*  79 */       String queueName = in.readUTF();
/*     */ 
/*  81 */       int size2 = in.readInt();
/*     */ 
/*  83 */       Map ids = new ConcurrentHashMap(size2);
/*     */ 
/*  85 */       for (int j = 0; j < size2; j++)
/*     */       {
/*  87 */         long id = in.readLong();
/*     */ 
/*  89 */         String sessionID = in.readUTF();
/*     */ 
/*  91 */         ids.put(new Long(id), sessionID);
/*     */       }
/*     */ 
/*  94 */       this.deliveries.put(queueName, ids);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 100 */     out.writeInt(this.nodeID);
/*     */ 
/* 102 */     out.writeInt(this.deliveries.size());
/*     */ 
/* 104 */     Iterator iter = this.deliveries.entrySet().iterator();
/*     */ 
/* 106 */     while (iter.hasNext())
/*     */     {
/* 108 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 110 */       String queueName = (String)entry.getKey();
/*     */ 
/* 112 */       out.writeUTF(queueName);
/*     */ 
/* 114 */       Map ids = (Map)entry.getValue();
/*     */ 
/* 116 */       out.writeInt(ids.size());
/*     */ 
/* 118 */       Iterator iter2 = ids.entrySet().iterator();
/*     */ 
/* 120 */       while (iter2.hasNext())
/*     */       {
/* 122 */         Map.Entry entry2 = (Map.Entry)iter2.next();
/*     */ 
/* 124 */         Long id = (Long)entry2.getKey();
/*     */ 
/* 126 */         String sessionID = (String)entry2.getValue();
/*     */ 
/* 128 */         out.writeLong(id.longValue());
/*     */ 
/* 130 */         out.writeUTF(sessionID);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.AddAllReplicatedDeliveriesMessage
 * JD-Core Version:    0.6.0
 */