/*     */ package org.jboss.messaging.core.impl.message;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.MessageStore;
/*     */ 
/*     */ public class SimpleMessageStore
/*     */   implements MessageStore
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(SimpleMessageStore.class);
/*     */   private Map<Long, Message> messages;
/*     */ 
/*     */   public SimpleMessageStore()
/*     */   {
/*  57 */     this.messages = new WeakHashMap();
/*     */ 
/*  59 */     log.debug(this + " initialized");
/*     */   }
/*     */ 
/*     */   public synchronized MessageReference reference(Message m)
/*     */   {
/*  68 */     Message message = (Message)this.messages.get(Long.valueOf(m.getMessageID()));
/*     */ 
/*  70 */     if (message == null)
/*     */     {
/*  72 */       this.messages.put(Long.valueOf(m.getMessageID()), m);
/*     */ 
/*  74 */       message = m;
/*     */     }
/*     */ 
/*  77 */     return message.createReference();
/*     */   }
/*     */ 
/*     */   public synchronized MessageReference reference(long messageID)
/*     */   {
/*  82 */     Message message = (Message)this.messages.get(Long.valueOf(messageID));
/*     */ 
/*  84 */     if (message == null)
/*     */     {
/*  86 */       return null;
/*     */     }
/*     */ 
/*  90 */     return message.createReference();
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/*  96 */     this.messages.clear();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 115 */     return "MemoryStore[" + System.identityHashCode(this) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.message.SimpleMessageStore
 * JD-Core Version:    0.6.0
 */