/*     */ package org.jboss.messaging.core.impl.message;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ 
/*     */ public class SimpleMessageReference
/*     */   implements MessageReference
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(SimpleMessageReference.class);
/*     */ 
/*  46 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  48 */   private long pagingOrder = -1L;
/*     */   private int deliveryCount;
/*     */   private long scheduledDeliveryTime;
/*     */   private Message message;
/*     */ 
/*     */   public SimpleMessageReference()
/*     */   {
/*  63 */     if (this.trace) log.trace("Creating using default constructor");
/*     */   }
/*     */ 
/*     */   public SimpleMessageReference(SimpleMessageReference other)
/*     */   {
/*  68 */     this.pagingOrder = other.pagingOrder;
/*     */ 
/*  70 */     this.deliveryCount = other.deliveryCount;
/*     */ 
/*  72 */     this.scheduledDeliveryTime = other.scheduledDeliveryTime;
/*     */ 
/*  74 */     this.message = other.message;
/*     */   }
/*     */ 
/*     */   protected SimpleMessageReference(Message message)
/*     */   {
/*  79 */     this.message = message;
/*     */   }
/*     */ 
/*     */   public MessageReference copy()
/*     */   {
/*  86 */     return new SimpleMessageReference(this);
/*     */   }
/*     */ 
/*     */   public int getDeliveryCount()
/*     */   {
/*  91 */     return this.deliveryCount;
/*     */   }
/*     */ 
/*     */   public void setDeliveryCount(int deliveryCount)
/*     */   {
/*  96 */     this.deliveryCount = deliveryCount;
/*     */   }
/*     */ 
/*     */   public long getScheduledDeliveryTime()
/*     */   {
/* 101 */     return this.scheduledDeliveryTime;
/*     */   }
/*     */ 
/*     */   public void setScheduledDeliveryTime(long scheduledDeliveryTime)
/*     */   {
/* 106 */     this.scheduledDeliveryTime = scheduledDeliveryTime;
/*     */   }
/*     */ 
/*     */   public Message getMessage()
/*     */   {
/* 111 */     return this.message;
/*     */   }
/*     */ 
/*     */   public long getPagingOrder()
/*     */   {
/* 116 */     return this.pagingOrder;
/*     */   }
/*     */ 
/*     */   public void setPagingOrder(long order)
/*     */   {
/* 121 */     this.pagingOrder = order;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 128 */     return "Reference[" + getMessage().getMessageID() + "]:" + (getMessage().isReliable() ? "RELIABLE" : "NON-RELIABLE");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.message.SimpleMessageReference
 * JD-Core Version:    0.6.0
 */