/*     */ package org.jboss.messaging.core.impl.message;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.util.StreamUtils;
/*     */ 
/*     */ public abstract class MessageSupport
/*     */   implements Message, Serializable
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(MessageSupport.class);
/*     */ 
/*  59 */   private boolean trace = log.isTraceEnabled();
/*     */   protected long messageID;
/*     */   protected boolean reliable;
/*     */   protected long expiration;
/*     */   protected long timestamp;
/*     */   protected Map headers;
/*     */   protected byte priority;
/*     */   protected transient Object payload;
/*     */   protected byte[] payloadAsByteArray;
/*     */   private volatile transient boolean persisted;
/*     */ 
/*     */   public MessageSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessageSupport(long messageID)
/*     */   {
/*  94 */     this(messageID, false, 0L, System.currentTimeMillis(), 4, null, null);
/*     */   }
/*     */ 
/*     */   public MessageSupport(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payloadAsByteArray)
/*     */   {
/* 104 */     this.messageID = messageID;
/* 105 */     this.reliable = reliable;
/* 106 */     this.expiration = expiration;
/* 107 */     this.timestamp = timestamp;
/* 108 */     this.priority = priority;
/* 109 */     if (headers == null)
/*     */     {
/* 111 */       this.headers = new HashMap();
/*     */     }
/*     */     else
/*     */     {
/* 115 */       this.headers = new HashMap(headers);
/*     */     }
/*     */ 
/* 118 */     this.payloadAsByteArray = payloadAsByteArray;
/*     */   }
/*     */ 
/*     */   protected MessageSupport(MessageSupport that)
/*     */   {
/* 128 */     this.messageID = that.messageID;
/* 129 */     this.reliable = that.reliable;
/* 130 */     this.expiration = that.expiration;
/* 131 */     this.timestamp = that.timestamp;
/* 132 */     this.headers = new HashMap(that.headers);
/* 133 */     this.priority = that.priority;
/* 134 */     this.payload = that.payload;
/* 135 */     this.payloadAsByteArray = that.payloadAsByteArray;
/*     */   }
/*     */ 
/*     */   public long getMessageID()
/*     */   {
/* 142 */     return this.messageID;
/*     */   }
/*     */ 
/*     */   public boolean isReliable()
/*     */   {
/* 147 */     return this.reliable;
/*     */   }
/*     */ 
/*     */   public long getExpiration()
/*     */   {
/* 152 */     return this.expiration;
/*     */   }
/*     */ 
/*     */   public void setExpiration(long expiration)
/*     */   {
/* 157 */     this.expiration = expiration;
/*     */   }
/*     */ 
/*     */   public long getTimestamp()
/*     */   {
/* 162 */     return this.timestamp;
/*     */   }
/*     */ 
/*     */   public Object putHeader(String name, Object value)
/*     */   {
/* 167 */     return this.headers.put(name, value);
/*     */   }
/*     */ 
/*     */   public Object getHeader(String name)
/*     */   {
/* 172 */     return this.headers.get(name);
/*     */   }
/*     */ 
/*     */   public Object removeHeader(String name)
/*     */   {
/* 177 */     return this.headers.remove(name);
/*     */   }
/*     */ 
/*     */   public boolean containsHeader(String name)
/*     */   {
/* 182 */     return this.headers.containsKey(name);
/*     */   }
/*     */ 
/*     */   public Map getHeaders()
/*     */   {
/* 187 */     return this.headers;
/*     */   }
/*     */ 
/*     */   public byte getPriority()
/*     */   {
/* 192 */     return this.priority;
/*     */   }
/*     */ 
/*     */   public void setPriority(byte priority)
/*     */   {
/* 197 */     this.priority = priority;
/*     */   }
/*     */ 
/*     */   public boolean isReference()
/*     */   {
/* 202 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized byte[] getPayloadAsByteArray()
/*     */   {
/* 207 */     if ((this.payloadAsByteArray == null) && (this.payload != null))
/*     */     {
/* 209 */       int BUFFER_SIZE = 2048;
/*     */       try
/*     */       {
/* 213 */         ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
/* 214 */         DataOutputStream daos = new DataOutputStream(bos);
/* 215 */         StreamUtils.writeObject(daos, this.payload, true, true);
/* 216 */         daos.close();
/* 217 */         this.payloadAsByteArray = bos.toByteArray();
/*     */ 
/* 221 */         this.payload = null;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 225 */         RuntimeException e2 = new RuntimeException(e.getMessage());
/* 226 */         e2.setStackTrace(e.getStackTrace());
/* 227 */         throw e2;
/*     */       }
/*     */     }
/* 230 */     return this.payloadAsByteArray;
/*     */   }
/*     */ 
/*     */   public synchronized Object getPayload()
/*     */   {
/* 235 */     if (this.payload != null)
/*     */     {
/* 237 */       return this.payload;
/*     */     }
/* 239 */     if (this.payloadAsByteArray != null)
/*     */     {
/* 241 */       ByteArrayInputStream bis = new ByteArrayInputStream(this.payloadAsByteArray);
/* 242 */       DataInputStream dis = new DataInputStream(bis);
/*     */       try
/*     */       {
/* 245 */         this.payload = StreamUtils.readObject(dis, true);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 249 */         RuntimeException e2 = new RuntimeException(e.getMessage());
/* 250 */         e2.setStackTrace(e.getStackTrace());
/* 251 */         throw e2;
/*     */       }
/*     */ 
/* 254 */       this.payloadAsByteArray = null;
/*     */ 
/* 256 */       return this.payload;
/*     */     }
/*     */ 
/* 260 */     return null;
/*     */   }
/*     */ 
/*     */   public void setPayload(Object payload)
/*     */   {
/* 266 */     this.payload = payload;
/*     */   }
/*     */ 
/*     */   public boolean isExpired()
/*     */   {
/* 271 */     if (this.expiration == 0L)
/*     */     {
/* 273 */       return false;
/*     */     }
/* 275 */     long overtime = System.currentTimeMillis() - this.expiration;
/* 276 */     if (overtime >= 0L)
/*     */     {
/* 279 */       if (this.trace)
/*     */       {
/* 281 */         log.trace(this + " expired by " + overtime + " ms");
/*     */       }
/*     */ 
/* 284 */       return true;
/*     */     }
/* 286 */     return false;
/*     */   }
/*     */ 
/*     */   public MessageReference createReference()
/*     */   {
/* 291 */     return new SimpleMessageReference(this);
/*     */   }
/*     */ 
/*     */   public boolean isPersisted()
/*     */   {
/* 296 */     return this.persisted;
/*     */   }
/*     */ 
/*     */   public void setPersisted(boolean persisted)
/*     */   {
/* 301 */     this.persisted = persisted;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 308 */     if (this == o)
/*     */     {
/* 310 */       return true;
/*     */     }
/* 312 */     if (!(o instanceof MessageSupport))
/*     */     {
/* 314 */       return false;
/*     */     }
/* 316 */     MessageSupport that = (MessageSupport)o;
/* 317 */     return that.messageID == this.messageID;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 322 */     return (int)(this.messageID >>> 32 ^ this.messageID);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 327 */     return "M[" + this.messageID + "]";
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/* 334 */     out.writeLong(this.messageID);
/*     */ 
/* 336 */     out.writeBoolean(this.reliable);
/*     */ 
/* 338 */     out.writeLong(this.expiration);
/*     */ 
/* 340 */     out.writeLong(this.timestamp);
/*     */ 
/* 342 */     StreamUtils.writeMap(out, this.headers, true);
/*     */ 
/* 344 */     out.writeByte(this.priority);
/*     */ 
/* 346 */     byte[] bytes = getPayloadAsByteArray();
/*     */ 
/* 348 */     if (bytes != null)
/*     */     {
/* 350 */       out.writeInt(bytes.length);
/*     */ 
/* 352 */       out.write(bytes);
/*     */     }
/*     */     else
/*     */     {
/* 356 */       out.writeInt(0);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/* 362 */     this.messageID = in.readLong();
/*     */ 
/* 364 */     this.reliable = in.readBoolean();
/*     */ 
/* 366 */     this.expiration = in.readLong();
/*     */ 
/* 368 */     this.timestamp = in.readLong();
/*     */ 
/* 370 */     this.headers = StreamUtils.readMap(in, true);
/*     */ 
/* 372 */     this.priority = in.readByte();
/*     */ 
/* 374 */     int length = in.readInt();
/*     */ 
/* 376 */     if (length == 0)
/*     */     {
/* 379 */       this.payloadAsByteArray = null;
/*     */     }
/*     */     else
/*     */     {
/* 383 */       this.payloadAsByteArray = new byte[length];
/*     */ 
/* 385 */       in.readFully(this.payloadAsByteArray);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.message.MessageSupport
 * JD-Core Version:    0.6.0
 */