/*     */ package org.jboss.messaging.core.impl.message;
/*     */ 
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.message.JBossBytesMessage;
/*     */ import org.jboss.jms.message.JBossMapMessage;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.JBossObjectMessage;
/*     */ import org.jboss.jms.message.JBossStreamMessage;
/*     */ import org.jboss.jms.message.JBossTextMessage;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ 
/*     */ public class MessageFactory
/*     */ {
/*     */   public static Message createMessage(byte type)
/*     */   {
/*  49 */     Message m = null;
/*     */ 
/*  51 */     if (type == 1)
/*     */     {
/*  53 */       m = new JBossMessage();
/*     */     }
/*  55 */     else if (type == 2)
/*     */     {
/*  57 */       m = new JBossObjectMessage();
/*     */     }
/*  59 */     else if (type == 3)
/*     */     {
/*  61 */       m = new JBossTextMessage();
/*     */     }
/*  63 */     else if (type == 4)
/*     */     {
/*  65 */       m = new JBossBytesMessage();
/*     */     }
/*  67 */     else if (type == 5)
/*     */     {
/*  69 */       m = new JBossMapMessage();
/*     */     }
/*  71 */     else if (type == 6)
/*     */     {
/*  73 */       m = new JBossStreamMessage();
/*     */     }
/*  75 */     else if (type == 127)
/*     */     {
/*  77 */       m = new CoreMessage();
/*     */     }
/*     */     else
/*     */     {
/*  81 */       throw new IllegalArgumentException("Invalid type " + type);
/*     */     }
/*     */ 
/*  84 */     return m;
/*     */   }
/*     */ 
/*     */   public static Message createMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payload, byte type)
/*     */   {
/* 100 */     Message m = null;
/*     */ 
/* 102 */     switch (type)
/*     */     {
/*     */     case 1:
/* 106 */       m = new JBossMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 108 */       break;
/*     */     case 2:
/* 112 */       m = new JBossObjectMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 114 */       break;
/*     */     case 3:
/* 118 */       m = new JBossTextMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 120 */       break;
/*     */     case 4:
/* 124 */       m = new JBossBytesMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 126 */       break;
/*     */     case 5:
/* 130 */       m = new JBossMapMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 132 */       break;
/*     */     case 6:
/* 136 */       m = new JBossStreamMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 138 */       break;
/*     */     case 127:
/* 142 */       m = new CoreMessage(messageID, reliable, expiration, timestamp, priority, headers, payload);
/*     */ 
/* 144 */       break;
/*     */     default:
/* 148 */       throw new IllegalArgumentException("Unknown type " + type);
/*     */     }
/*     */ 
/* 152 */     m.setPersisted(true);
/*     */ 
/* 154 */     return m;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.message.MessageFactory
 * JD-Core Version:    0.6.0
 */