/*     */ package org.jboss.messaging.core.impl.memory;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MemoryManager;
/*     */ 
/*     */ public class SimpleMemoryManager
/*     */   implements MemoryManager
/*     */ {
/*  38 */   private static final Logger log = Logger.getLogger(SimpleMemoryManager.class);
/*     */   private static final long DEFAULT_MEASURE_INTERVAL = 3000L;
/*     */   private static final int DEFAULT_FREE_MEMORY_PERCENT = 25;
/*     */   private Runtime runtime;
/*     */   private long measureInterval;
/*     */   private int freeMemoryPercent;
/*     */   private volatile boolean started;
/*     */   private Thread thread;
/*     */   private volatile boolean low;
/*     */ 
/*     */   public SimpleMemoryManager()
/*     */   {
/*  60 */     this.runtime = Runtime.getRuntime();
/*     */ 
/*  62 */     this.measureInterval = 3000L;
/*     */ 
/*  64 */     this.freeMemoryPercent = 25;
/*     */   }
/*     */ 
/*     */   public boolean isMemoryLow()
/*     */   {
/*  69 */     return this.low;
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */   {
/*  75 */     log.debug("Starting MemoryManager with MEASURE_INTERVAL: " + this.measureInterval + " FREE_MEMORY_PERCENT: " + this.freeMemoryPercent);
/*     */ 
/*  78 */     if (this.started)
/*     */     {
/*  81 */       return;
/*     */     }
/*     */ 
/*  84 */     this.started = true;
/*     */ 
/*  86 */     this.thread = new Thread(new MemoryRunnable(null));
/*     */ 
/*  88 */     this.thread.setDaemon(true);
/*     */ 
/*  90 */     this.thread.start();
/*     */   }
/*     */ 
/*     */   public synchronized void stop()
/*     */   {
/*  95 */     if (!this.started)
/*     */     {
/*  98 */       return;
/*     */     }
/*     */ 
/* 101 */     this.started = false;
/*     */ 
/* 103 */     this.thread.interrupt();
/*     */     try
/*     */     {
/* 107 */       this.thread.join();
/*     */     }
/*     */     catch (InterruptedException ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private class MemoryRunnable implements Runnable
/*     */   {
/*     */     private MemoryRunnable() {
/*     */     }
/*     */ 
/*     */     public void run() {
/*     */       while (true) {
/*     */         try {
/* 122 */           if ((SimpleMemoryManager.this.thread.isInterrupted()) && (!SimpleMemoryManager.this.started))
/*     */           {
/*     */             break;
/*     */           }
/* 126 */           Thread.sleep(SimpleMemoryManager.this.measureInterval);
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/* 130 */           if (SimpleMemoryManager.this.started) break label53; 
/*     */         }
/* 132 */         break;
/*     */ 
/* 136 */         label53: long freeMemory = SimpleMemoryManager.this.runtime.freeMemory();
/*     */ 
/* 138 */         long maxMemory = SimpleMemoryManager.this.runtime.maxMemory();
/*     */ 
/* 140 */         long totalMemory = SimpleMemoryManager.this.runtime.totalMemory();
/*     */ 
/* 142 */         long availableMemory = freeMemory + maxMemory - totalMemory;
/*     */ 
/* 144 */         if (100L * availableMemory / totalMemory <= SimpleMemoryManager.this.freeMemoryPercent)
/*     */         {
/* 147 */           SimpleMemoryManager.access$602(SimpleMemoryManager.this, true);
/*     */         }
/*     */         else
/*     */         {
/* 151 */           SimpleMemoryManager.access$602(SimpleMemoryManager.this, false);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.memory.SimpleMemoryManager
 * JD-Core Version:    0.6.0
 */