/*     */ package org.jboss.messaging.core.impl.clusterconnection;
/*     */ 
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.jms.client.JBossConnection;
/*     */ import org.jboss.jms.client.JBossSession;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.destination.JBossQueue;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public class MessageSucker
/*     */   implements MessageListener
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(MessageSucker.class);
/*     */ 
/*  57 */   private boolean trace = log.isTraceEnabled();
/*     */   private JBossConnection sourceConnection;
/*     */   private JBossConnection localConnection;
/*     */   private Queue localQueue;
/*     */   private SessionDelegate sourceSession;
/*     */   private SessionDelegate localSession;
/*     */   private ProducerDelegate producer;
/*     */   private volatile boolean started;
/*     */   private boolean xa;
/*     */   private TransactionManager tm;
/*     */   private boolean consuming;
/*     */   private ConsumerDelegate consumer;
/*     */   private boolean preserveOrdering;
/*     */ 
/*     */   public String toString()
/*     */   {
/*  85 */     return "MessageSucker:" + System.identityHashCode(this) + " queue:" + this.localQueue.getName();
/*     */   }
/*     */ 
/*     */   MessageSucker(Queue localQueue, JBossConnection sourceConnection, JBossConnection localConnection, boolean xa, boolean preserveOrdering)
/*     */   {
/*  91 */     if (this.trace) log.trace("Creating message sucker, localQueue:" + localQueue + " xa:" + xa + " preserveOrdering:" + preserveOrdering);
/*     */ 
/*  93 */     this.localQueue = localQueue;
/*     */ 
/*  95 */     this.sourceConnection = sourceConnection;
/*     */ 
/*  97 */     this.localConnection = localConnection;
/*     */ 
/*  99 */     this.xa = xa;
/*     */ 
/* 101 */     this.preserveOrdering = preserveOrdering;
/*     */ 
/* 103 */     if (xa)
/*     */     {
/* 105 */       this.tm = TransactionManagerLocator.getInstance().locate();
/*     */     }
/*     */   }
/*     */ 
/*     */   synchronized void start() throws Exception
/*     */   {
/* 111 */     if (this.started)
/*     */     {
/* 113 */       return;
/*     */     }
/*     */ 
/* 116 */     if (this.trace) log.trace(this + " starting");
/*     */ 
/* 118 */     if (!this.xa)
/*     */     {
/* 125 */       JBossSession sess = (JBossSession)this.sourceConnection.createSession(false, 2);
/*     */ 
/* 127 */       this.sourceSession = sess.getDelegate();
/*     */ 
/* 130 */       sess = (JBossSession)this.localConnection.createSession(false, 1);
/*     */ 
/* 132 */       this.localSession = sess.getDelegate();
/*     */     }
/*     */     else
/*     */     {
/* 136 */       JBossSession sess = (JBossSession)this.sourceConnection.createXASession();
/*     */ 
/* 138 */       this.sourceSession = sess.getDelegate();
/*     */ 
/* 140 */       sess = (JBossSession)this.localConnection.createXASession();
/*     */ 
/* 142 */       this.localSession = sess.getDelegate();
/*     */     }
/*     */ 
/* 145 */     JBossDestination dest = new JBossQueue(this.localQueue.getName(), true);
/*     */ 
/* 147 */     this.producer = this.localSession.createProducerDelegate(dest);
/*     */ 
/* 154 */     this.consumer = this.sourceSession.createConsumerDelegate(dest, null, false, null, false, false);
/*     */ 
/* 156 */     this.consumer.setMessageListener(this);
/*     */ 
/* 160 */     if (this.trace) log.trace(this + " Registering sucker");
/*     */ 
/* 162 */     this.localQueue.registerSucker(this);
/*     */ 
/* 164 */     this.started = true;
/*     */ 
/* 166 */     if (this.trace) log.trace(this + " Registered sucker");
/*     */   }
/*     */ 
/*     */   synchronized void stop()
/*     */   {
/* 171 */     if (!this.started)
/*     */     {
/* 173 */       return;
/*     */     }
/*     */ 
/* 176 */     setConsuming(false);
/*     */ 
/* 178 */     this.localQueue.unregisterSucker(this);
/*     */     try
/*     */     {
/* 182 */       this.sourceSession.close();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 191 */       this.localSession.close();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/*     */ 
/* 198 */     this.started = false;
/*     */   }
/*     */ 
/*     */   public String getQueueName()
/*     */   {
/* 203 */     return this.localQueue.getName();
/*     */   }
/*     */ 
/*     */   public synchronized void setConsuming(boolean consume)
/*     */   {
/* 208 */     if (this.trace) log.trace(this + " setConsuming " + consume);
/*     */ 
/*     */     try
/*     */     {
/* 212 */       if ((consume) && (!this.consuming))
/*     */       {
/* 216 */         this.consumer.changeRate(1.0F);
/*     */ 
/* 218 */         if (this.trace) log.trace(this + " sent changeRate(1) message");
/*     */ 
/* 220 */         this.consuming = true;
/*     */       }
/* 222 */       else if ((!consume) && (this.consuming))
/*     */       {
/* 226 */         this.consumer.changeRate(0.0F);
/*     */ 
/* 228 */         if (this.trace) log.trace(this + " sent changeRate(0) message");
/*     */ 
/* 230 */         this.consuming = false;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void onMessage(Message msg)
/*     */   {
/* 241 */     Transaction tx = null;
/*     */ 
/* 243 */     if (this.trace) log.trace(this + " sucked message " + msg);
/*     */ 
/*     */     try
/*     */     {
/* 247 */       boolean startTx = (this.xa) && (msg.getJMSDeliveryMode() == 2);
/*     */ 
/* 249 */       if (startTx)
/*     */       {
/* 253 */         if (this.trace) log.trace("Starting JTA transactions");
/*     */ 
/* 255 */         this.tm.begin();
/*     */ 
/* 257 */         tx = this.tm.getTransaction();
/*     */ 
/* 259 */         tx.enlistResource(this.sourceSession.getXAResource());
/*     */ 
/* 261 */         tx.enlistResource(this.localSession.getXAResource());
/*     */ 
/* 263 */         if (this.trace) log.trace("Started JTA transaction");
/*     */       }
/*     */ 
/* 266 */       if (this.preserveOrdering)
/*     */       {
/* 269 */         ((MessageProxy)msg).getMessage().putHeader("CLUSTER_SUCKED", "x");
/*     */       }
/*     */ 
/* 272 */       long timeToLive = msg.getJMSExpiration();
/* 273 */       if (timeToLive != 0L)
/*     */       {
/* 275 */         timeToLive -= System.currentTimeMillis();
/* 276 */         if (timeToLive <= 0L)
/*     */         {
/* 278 */           timeToLive = 1L;
/*     */         }
/*     */       }
/*     */ 
/* 282 */       this.producer.send(null, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive, true);
/*     */ 
/* 284 */       if (this.trace) log.trace(this + " forwarded message to queue");
/*     */ 
/* 286 */       if (startTx)
/*     */       {
/* 288 */         if (this.trace) log.trace("Committing JTA transaction");
/*     */ 
/* 290 */         tx.delistResource(this.sourceSession.getXAResource(), 67108864);
/*     */ 
/* 292 */         tx.delistResource(this.localSession.getXAResource(), 67108864);
/*     */ 
/* 294 */         this.tm.commit();
/*     */ 
/* 296 */         if (this.trace) log.trace("Committed JTA transaction");
/*     */       }
/*     */       else
/*     */       {
/* 300 */         msg.acknowledge();
/*     */ 
/* 302 */         if (this.trace) log.trace("Acknowledged message");
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 307 */       log.error("Failed to forward message", e);
/*     */       try
/*     */       {
/* 311 */         if (tx != null) this.tm.rollback();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 315 */         if (this.trace) log.trace("Failed to rollback tx", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.clusterconnection.MessageSucker
 * JD-Core Version:    0.6.0
 */