/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*     */ import org.jboss.messaging.core.contract.Distributor;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.Receiver;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ 
/*     */ public class RoundRobinDistributor
/*     */   implements Distributor
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(RoundRobinDistributor.class);
/*     */ 
/*  57 */   private boolean trace = log.isTraceEnabled();
/*     */   private ArrayList receivers;
/*     */   private int target;
/*     */   private volatile boolean makeCopy;
/*     */   private ArrayList receiversCopy;
/*     */ 
/*     */   public RoundRobinDistributor()
/*     */   {
/*  72 */     this.receivers = new ArrayList();
/*     */ 
/*  74 */     this.target = 0;
/*     */ 
/*  76 */     this.makeCopy = true;
/*     */   }
/*     */ 
/*     */   public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx)
/*     */   {
/*  83 */     if (this.makeCopy)
/*     */     {
/*  85 */       synchronized (this)
/*     */       {
/*  91 */         this.receiversCopy = new ArrayList(this.receivers);
/*     */ 
/*  93 */         if (this.target >= this.receiversCopy.size())
/*     */         {
/*  95 */           this.target = 0;
/*     */         }
/*     */ 
/*  98 */         this.makeCopy = false;
/*     */       }
/*     */     }
/*     */ 
/* 102 */     if (this.receiversCopy.isEmpty())
/*     */     {
/* 104 */       return null;
/*     */     }
/*     */ 
/* 107 */     Delivery del = null;
/*     */ 
/* 109 */     boolean selectorRejected = false;
/*     */ 
/* 111 */     int initial = this.target;
/*     */     while (true)
/*     */     {
/* 115 */       Receiver r = (Receiver)this.receiversCopy.get(this.target);
/*     */       try
/*     */       {
/* 119 */         Delivery d = r.handle(observer, ref, tx);
/*     */ 
/* 121 */         if (this.trace) log.trace("receiver " + r + " handled " + ref + " and returned " + d);
/*     */ 
/* 123 */         if (d != null)
/*     */         {
/* 125 */           if (d.isSelectorAccepted())
/*     */           {
/* 128 */             del = d;
/*     */ 
/* 130 */             incTarget();
/*     */ 
/* 132 */             break;
/*     */           }
/*     */ 
/* 136 */           selectorRejected = true;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 143 */         log.error("The receiver " + r + " is broken", t);
/*     */       }
/*     */ 
/* 146 */       incTarget();
/*     */ 
/* 149 */       if (this.target == initial)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 155 */     if ((del == null) && (selectorRejected))
/*     */     {
/* 157 */       del = new SimpleDelivery(null, null, false, false);
/*     */     }
/*     */ 
/* 160 */     return del;
/*     */   }
/*     */ 
/*     */   public synchronized boolean add(Receiver r)
/*     */   {
/* 165 */     if (this.receivers.contains(r))
/*     */     {
/* 167 */       return false;
/*     */     }
/*     */ 
/* 170 */     this.receivers.add(r);
/*     */ 
/* 172 */     this.makeCopy = true;
/*     */ 
/* 174 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(Receiver r)
/*     */   {
/* 179 */     boolean removed = this.receivers.remove(r);
/*     */ 
/* 181 */     if (removed)
/*     */     {
/* 183 */       this.makeCopy = true;
/*     */     }
/*     */ 
/* 186 */     return removed;
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 191 */     this.receivers.clear();
/*     */ 
/* 193 */     this.makeCopy = true;
/*     */   }
/*     */ 
/*     */   public synchronized boolean contains(Receiver r)
/*     */   {
/* 198 */     return this.receivers.contains(r);
/*     */   }
/*     */ 
/*     */   public synchronized Iterator iterator()
/*     */   {
/* 203 */     return this.receivers.iterator();
/*     */   }
/*     */ 
/*     */   public synchronized int getNumberOfReceivers()
/*     */   {
/* 208 */     return this.receivers.size();
/*     */   }
/*     */ 
/*     */   private void incTarget()
/*     */   {
/* 221 */     this.target += 1;
/*     */ 
/* 223 */     if (this.target == this.receiversCopy.size())
/*     */     {
/* 225 */       this.target = 0;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.RoundRobinDistributor
 * JD-Core Version:    0.6.0
 */