/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import org.jboss.jms.delegate.IDBlock;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager;
/*     */ 
/*     */ public class IDManager
/*     */   implements MessagingComponent
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(IDManager.class);
/*     */ 
/*  49 */   private boolean trace = log.isTraceEnabled();
/*     */   private boolean started;
/*     */   private String counterName;
/*     */   private int bigBlockSize;
/*     */   private long high;
/*     */   private long low;
/*     */   private PersistenceManager pm;
/*     */ 
/*     */   public IDManager(String counterName, int bigBlockSize, PersistenceManager pm)
/*     */     throws Exception
/*     */   {
/*  65 */     this.counterName = counterName;
/*  66 */     this.bigBlockSize = bigBlockSize;
/*  67 */     this.pm = pm;
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */     throws Exception
/*     */   {
/*  74 */     getNextBigBlock();
/*  75 */     this.started = true;
/*     */   }
/*     */ 
/*     */   public synchronized void stop() throws Exception
/*     */   {
/*  80 */     this.started = false;
/*     */   }
/*     */ 
/*     */   protected void getNextBigBlock()
/*     */     throws Exception
/*     */   {
/*  87 */     this.low = this.pm.reserveIDBlock(this.counterName, this.bigBlockSize);
/*  88 */     this.high = (this.low + this.bigBlockSize - 1L);
/*  89 */     if (this.trace) log.trace(this + " retrieved next block of size " + this.bigBlockSize + " from PersistenceManager, starting at " + this.low); 
/*     */   }
/*     */ 
/*     */   public synchronized IDBlock getIDBlock(int size)
/*     */     throws Exception
/*     */   {
/*  94 */     if (!this.started)
/*     */     {
/*  96 */       throw new IllegalStateException(this + " is not started");
/*     */     }
/*     */ 
/*  99 */     if (size <= 0)
/*     */     {
/* 101 */       throw new IllegalArgumentException("block size must be > 0");
/*     */     }
/*     */ 
/* 104 */     if (size > this.bigBlockSize)
/*     */     {
/* 106 */       throw new IllegalArgumentException("block size must be <= bigBlockSize");
/*     */     }
/*     */ 
/* 109 */     if (size > this.high - this.low + 1L)
/*     */     {
/* 111 */       getNextBigBlock();
/*     */     }
/*     */ 
/* 114 */     long low = this.low;
/*     */ 
/* 116 */     this.low += size;
/*     */ 
/* 118 */     return new IDBlock(low, this.low - 1L);
/*     */   }
/*     */ 
/*     */   public synchronized long getID() throws Exception
/*     */   {
/* 123 */     return getIDBlock(1).getLow();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 128 */     return "IDManager[" + this.counterName + ", " + this.low + "-" + this.high + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.IDManager
 * JD-Core Version:    0.6.0
 */