/*    */ package org.jboss.messaging.core.impl;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.Set;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.messaging.core.contract.ClusterNotification;
/*    */ import org.jboss.messaging.core.contract.ClusterNotificationListener;
/*    */ import org.jboss.messaging.core.contract.ClusterNotifier;
/*    */ import org.jboss.messaging.util.ConcurrentReaderHashSet;
/*    */ 
/*    */ public class DefaultClusterNotifier
/*    */   implements ClusterNotifier
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(DefaultClusterNotifier.class);
/*    */   private Set listeners;
/*    */ 
/*    */   public DefaultClusterNotifier()
/*    */   {
/* 51 */     this.listeners = new ConcurrentReaderHashSet();
/*    */   }
/*    */ 
/*    */   public void registerListener(ClusterNotificationListener listener)
/*    */   {
/* 56 */     if (this.listeners.contains(listener))
/*    */     {
/* 58 */       throw new IllegalStateException("Listener " + listener + " is already registered");
/*    */     }
/*    */ 
/* 61 */     this.listeners.add(listener);
/*    */   }
/*    */ 
/*    */   public void sendNotification(ClusterNotification notification)
/*    */   {
/* 66 */     Iterator iter = this.listeners.iterator();
/*    */ 
/* 68 */     while (iter.hasNext())
/*    */     {
/* 70 */       ClusterNotificationListener listener = (ClusterNotificationListener)iter.next();
/*    */ 
/* 72 */       listener.notify(notification);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void unregisterListener(ClusterNotificationListener listener)
/*    */   {
/* 78 */     if (!this.listeners.remove(listener))
/*    */     {
/* 80 */       throw new IllegalStateException("Listener " + listener + " is not registered");
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.DefaultClusterNotifier
 * JD-Core Version:    0.6.0
 */