/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*     */ import org.jboss.messaging.core.contract.Distributor;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.Receiver;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ 
/*     */ public class ClusterRoundRobinDistributor
/*     */   implements Distributor
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ClusterRoundRobinDistributor.class);
/*     */ 
/*  56 */   private boolean trace = log.isTraceEnabled();
/*     */   private Distributor localDistributor;
/*     */   private Distributor remoteDistributor;
/*     */ 
/*     */   public ClusterRoundRobinDistributor(Distributor local, Distributor remote)
/*     */   {
/*  66 */     this.localDistributor = local;
/*     */ 
/*  68 */     this.remoteDistributor = remote;
/*     */   }
/*     */ 
/*     */   public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx)
/*     */   {
/*  77 */     if (this.trace) log.trace(this + " first trying with local distributor");
/*     */ 
/*  79 */     Delivery del = this.localDistributor.handle(observer, ref, tx);
/*     */ 
/*  81 */     if (this.trace) log.trace(this + " local distributor returned " + del);
/*     */ 
/*  83 */     if (del == null)
/*     */     {
/*  87 */       if (this.trace) log.trace(this + " trying with remote distributor");
/*     */ 
/*  89 */       del = this.remoteDistributor.handle(observer, ref, tx);
/*     */ 
/*  91 */       if (this.trace) log.trace(this + " remote distributor returned " + del);
/*     */     }
/*     */ 
/*  94 */     return del;
/*     */   }
/*     */ 
/*     */   public synchronized boolean add(Receiver r)
/*     */   {
/* 100 */     throw new IllegalStateException("Not used!");
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(Receiver r)
/*     */   {
/* 106 */     throw new IllegalStateException("Not used!");
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 111 */     this.localDistributor.clear();
/*     */ 
/* 113 */     this.remoteDistributor.clear();
/*     */   }
/*     */ 
/*     */   public synchronized boolean contains(Receiver r)
/*     */   {
/* 118 */     return (this.localDistributor.contains(r)) || (this.remoteDistributor.contains(r));
/*     */   }
/*     */ 
/*     */   public synchronized Iterator iterator()
/*     */   {
/* 124 */     return this.localDistributor.iterator();
/*     */   }
/*     */ 
/*     */   public synchronized int getNumberOfReceivers()
/*     */   {
/* 129 */     return this.localDistributor.getNumberOfReceivers() + this.remoteDistributor.getNumberOfReceivers();
/*     */   }
/*     */ 
/*     */   public void addLocal(Receiver r)
/*     */   {
/* 136 */     this.localDistributor.add(r);
/*     */   }
/*     */ 
/*     */   public boolean removeLocal(Receiver r)
/*     */   {
/* 141 */     return this.localDistributor.remove(r);
/*     */   }
/*     */ 
/*     */   public void addRemote(Receiver r)
/*     */   {
/* 146 */     this.remoteDistributor.add(r);
/*     */   }
/*     */ 
/*     */   public boolean removeRemote(Receiver r)
/*     */   {
/* 151 */     return this.remoteDistributor.remove(r);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.ClusterRoundRobinDistributor
 * JD-Core Version:    0.6.0
 */