/*     */ package org.jboss.messaging.core.contract;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ 
/*     */ public abstract interface PersistenceManager extends MessagingComponent
/*     */ {
/*     */   public abstract void addReference(long paramLong, MessageReference paramMessageReference, Transaction paramTransaction)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void removeReference(long paramLong, MessageReference paramMessageReference, Transaction paramTransaction)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void updateDeliveryCount(long paramLong, MessageReference paramMessageReference)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract List retrievePreparedTransactions()
/*     */     throws Exception;
/*     */ 
/*     */   public abstract List getMessageChannelPairRefsForTx(long paramLong)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract List getMessageChannelPairAcksForTx(long paramLong)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void pageReferences(long paramLong, List paramList, boolean paramBoolean)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void removeDepagedReferences(long paramLong, List paramList)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void updatePageOrder(long paramLong, List paramList)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void updateReferencesNotPagedInRange(long paramLong1, long paramLong2, long paramLong3, long paramLong4)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract List getPagedReferenceInfos(long paramLong1, long paramLong2, int paramInt)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract InitialLoadInfo loadFromStart(long paramLong, int paramInt)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract void mergeTransactions(long paramLong1, long paramLong2)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract InitialLoadInfo mergeAndLoad(long paramLong1, long paramLong2, int paramInt, long paramLong3, long paramLong4)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract List getMessages(List paramList)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract long reserveIDBlock(String paramString, int paramInt)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract boolean referenceExists(long paramLong)
/*     */     throws Exception;
/*     */ 
/*     */   public static class InitialLoadInfo
/*     */   {
/*     */     private Long minPageOrdering;
/*     */     private Long maxPageOrdering;
/*     */     private List refInfos;
/*     */ 
/*     */     public InitialLoadInfo(Long minPageOrdering, Long maxPageOrdering, List refInfos)
/*     */     {
/* 155 */       this.minPageOrdering = minPageOrdering;
/* 156 */       this.maxPageOrdering = maxPageOrdering;
/* 157 */       this.refInfos = refInfos;
/*     */     }
/*     */ 
/*     */     public Long getMaxPageOrdering()
/*     */     {
/* 162 */       return this.maxPageOrdering;
/*     */     }
/*     */ 
/*     */     public Long getMinPageOrdering()
/*     */     {
/* 167 */       return this.minPageOrdering;
/*     */     }
/*     */ 
/*     */     public List getRefInfos()
/*     */     {
/* 172 */       return this.refInfos;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class ReferenceInfo
/*     */   {
/*     */     private long messageId;
/*     */     private int deliveryCount;
/*     */     private long scheduledDelivery;
/*     */ 
/*     */     public ReferenceInfo(long msgId, int deliveryCount, long scheduledDelivery)
/*     */     {
/* 122 */       this.messageId = msgId;
/*     */ 
/* 124 */       this.deliveryCount = deliveryCount;
/*     */ 
/* 126 */       this.scheduledDelivery = scheduledDelivery;
/*     */     }
/*     */ 
/*     */     public long getMessageId()
/*     */     {
/* 131 */       return this.messageId;
/*     */     }
/*     */ 
/*     */     public int getDeliveryCount()
/*     */     {
/* 136 */       return this.deliveryCount;
/*     */     }
/*     */ 
/*     */     public long getScheduledDelivery()
/*     */     {
/* 141 */       return this.scheduledDelivery;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class MessageChannelPair
/*     */   {
/*     */     private Message message;
/*     */     private long channelId;
/*     */ 
/*     */     public MessageChannelPair(Message message, long channelId)
/*     */     {
/*  96 */       this.message = message;
/*     */ 
/*  98 */       this.channelId = channelId;
/*     */     }
/*     */ 
/*     */     public Message getMessage()
/*     */     {
/* 103 */       return this.message;
/*     */     }
/*     */ 
/*     */     public long getChannelId()
/*     */     {
/* 108 */       return this.channelId;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.contract.PersistenceManager
 * JD-Core Version:    0.6.0
 */