/*     */ package org.jboss.managed.plugins.factory;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedOperation;
/*     */ import org.jboss.managed.api.ManagedOperation.Impact;
/*     */ import org.jboss.managed.api.ManagedParameter;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.api.annotation.AnnotationDefaults;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectRef;
/*     */ import org.jboss.managed.api.annotation.ManagementOperation;
/*     */ import org.jboss.managed.api.annotation.ManagementParameter;
/*     */ import org.jboss.managed.api.annotation.ManagementParameter.NULL_CONSTRAINTS;
/*     */ import org.jboss.managed.api.annotation.ManagementProperties;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty.NULL_CONSTRAINTS;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty.NULL_FIELDS_FACTORY;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty.NULL_PROPERTY_FACTORY;
/*     */ import org.jboss.managed.api.annotation.ManagementRuntimeRef;
/*     */ import org.jboss.managed.api.annotation.ManagementRuntimeRef.DEFAULT_NAME_TRANSFORMER;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedOperationImpl;
/*     */ import org.jboss.managed.plugins.ManagedParameterImpl;
/*     */ import org.jboss.managed.plugins.WritethroughManagedPropertyImpl;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.managed.spi.factory.ManagedObjectBuilder;
/*     */ import org.jboss.managed.spi.factory.ManagedObjectPopulator;
/*     */ import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulator;
/*     */ import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulatorFactory;
/*     */ import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
/*     */ import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulatorFactory;
/*     */ import org.jboss.managed.spi.factory.RuntimeComponentNameTransformer;
/*     */ import org.jboss.metatype.api.types.ArrayMetaType;
/*     */ import org.jboss.metatype.api.types.CollectionMetaType;
/*     */ import org.jboss.metatype.api.types.GenericMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*     */ import org.jboss.metatype.api.values.ArrayValueSupport;
/*     */ import org.jboss.metatype.api.values.CollectionValueSupport;
/*     */ import org.jboss.metatype.api.values.GenericValueSupport;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class AbstractManagedObjectFactory extends ManagedObjectFactory
/*     */   implements ManagedObjectBuilder, InstanceClassFactory<Serializable>, ManagedObjectPopulator<Serializable>
/*     */ {
/* 102 */   private static final Logger log = Logger.getLogger(AbstractManagedObjectFactory.class);
/*     */   private static final Configuration configuration;
/* 108 */   public static final GenericMetaType MANAGED_OBJECT_META_TYPE = new GenericMetaType(ManagedObject.class.getName(), ManagedObject.class.getName());
/*     */ 
/* 111 */   private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
/*     */ 
/* 114 */   private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
/*     */ 
/* 117 */   private Map<Class, ManagedObjectBuilder> builders = new WeakHashMap();
/*     */ 
/* 120 */   private Map<Class, InstanceClassFactory> instanceFactories = new WeakHashMap();
/*     */ 
/* 123 */   private Map<TypeInfo, RuntimeComponentNameTransformer> transformers = new WeakHashMap();
/*     */ 
/*     */   public <T extends Serializable> ManagedObject createManagedObject(Class<T> clazz)
/*     */   {
/* 139 */     if (clazz == null) {
/* 140 */       throw new IllegalArgumentException("Null class");
/*     */     }
/* 142 */     ManagedObject result = createSkeletonManagedObject(clazz);
/* 143 */     ManagedObjectPopulator populator = getPopulator(clazz);
/* 144 */     populator.createObject(result, clazz);
/*     */ 
/* 146 */     return result;
/*     */   }
/*     */ 
/*     */   public ManagedObject initManagedObject(Serializable object, String name, String nameType)
/*     */   {
/* 153 */     if (object == null) {
/* 154 */       throw new IllegalArgumentException("Null object");
/* 156 */     }Class clazz = object.getClass();
/* 157 */     InstanceClassFactory icf = getInstanceClassFactory(clazz);
/*     */     Class moClass;
/*     */     try { moClass = icf.getManagedObjectClass(object);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 165 */       return null;
/*     */     }
/* 167 */     ManagedObject result = createSkeletonManagedObject(moClass);
/* 168 */     if (result == null)
/*     */     {
/* 170 */       log.debug("Null ManagedObject created for: " + moClass);
/* 171 */       return null;
/*     */     }
/* 173 */     ManagedObjectPopulator populator = getPopulator(moClass);
/* 174 */     populator.populateManagedObject(result, object);
/*     */ 
/* 176 */     return result;
/*     */   }
/*     */ 
/*     */   public void setBuilder(Class<?> clazz, ManagedObjectBuilder builder)
/*     */   {
/* 182 */     synchronized (this.builders)
/*     */     {
/* 184 */       if (builder == null)
/* 185 */         this.builders.remove(clazz);
/*     */       else
/* 187 */         this.builders.put(clazz, builder);
/*     */     }
/*     */   }
/*     */ 
/*     */   public <T extends Serializable> void setInstanceClassFactory(Class<T> clazz, InstanceClassFactory<T> factory)
/*     */   {
/* 194 */     synchronized (this.instanceFactories)
/*     */     {
/* 196 */       if (factory == null)
/* 197 */         this.instanceFactories.remove(clazz);
/*     */       else
/* 199 */         this.instanceFactories.put(clazz, factory);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNameTransformers(Class<?> clazz, RuntimeComponentNameTransformer transformer)
/*     */   {
/* 205 */     TypeInfo type = configuration.getTypeInfo(clazz);
/* 206 */     setNameTransformers(type, transformer);
/*     */   }
/*     */ 
/*     */   public void setNameTransformers(TypeInfo type, RuntimeComponentNameTransformer transformer)
/*     */   {
/* 211 */     synchronized (this.transformers)
/*     */     {
/* 213 */       if (transformer == null)
/* 214 */         this.transformers.remove(type);
/*     */       else
/* 216 */         this.transformers.put(type, transformer);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class<? extends Serializable> getManagedObjectClass(Serializable instance)
/*     */   {
/* 226 */     return instance.getClass();
/*     */   }
/*     */ 
/*     */   protected <T extends Serializable> ManagedObject createSkeletonManagedObject(Class<T> clazz)
/*     */   {
/* 240 */     if (clazz == null) {
/* 241 */       throw new IllegalArgumentException("Null class");
/*     */     }
/* 243 */     ManagedObjectBuilder builder = getBuilder(clazz);
/* 244 */     return builder.buildManagedObject(clazz);
/*     */   }
/*     */ 
/*     */   public ManagedObject buildManagedObject(Class<? extends Serializable> clazz)
/*     */   {
/* 256 */     boolean trace = log.isTraceEnabled();
/* 257 */     BeanInfo beanInfo = configuration.getBeanInfo(clazz);
/* 258 */     ClassInfo classInfo = beanInfo.getClassInfo();
/*     */ 
/* 260 */     ManagementObject managementObject = (ManagementObject)classInfo.getUnderlyingAnnotation(ManagementObject.class);
/* 261 */     if (managementObject == null)
/*     */     {
/* 263 */       if (trace) {
/* 264 */         log.trace("No ManagementObject annotation, skipping ManagedObject for class: " + clazz);
/*     */       }
/* 266 */       return null;
/*     */     }
/*     */ 
/* 269 */     HashMap moAnnotations = new HashMap();
/* 270 */     moAnnotations.put(ManagementObject.class.getName(), managementObject);
/* 271 */     ManagementObjectID moID = (ManagementObjectID)classInfo.getUnderlyingAnnotation(ManagementObjectID.class);
/* 272 */     if (moID != null) {
/* 273 */       moAnnotations.put(ManagementObjectID.class.getName(), moID);
/*     */     }
/*     */ 
/* 276 */     boolean isRuntime = managementObject.isRuntime();
/* 277 */     String name = classInfo.getName();
/* 278 */     String nameType = null;
/* 279 */     String attachmentName = classInfo.getName();
/* 280 */     Class moFieldsFactory = null;
/* 281 */     Class moConstraintsFactory = null;
/* 282 */     Class moPropertyFactory = null;
/* 283 */     if (managementObject != null)
/*     */     {
/* 285 */       name = managementObject.name();
/* 286 */       if ((name.length() == 0) || (name.equals("%Generated%")))
/* 287 */         name = classInfo.getName();
/* 288 */       nameType = managementObject.type();
/* 289 */       if (nameType.length() == 0)
/* 290 */         nameType = null;
/* 291 */       attachmentName = managementObject.attachmentName();
/* 292 */       if (attachmentName.length() == 0) {
/* 293 */         attachmentName = classInfo.getName();
/*     */       }
/* 295 */       ManagementComponent mc = managementObject.componentType();
/* 296 */       if (!mc.equals(AnnotationDefaults.COMP_TYPE)) {
/* 297 */         moAnnotations.put(ManagementComponent.class.getName(), mc);
/*     */       }
/* 299 */       moFieldsFactory = managementObject.fieldsFactory();
/* 300 */       moConstraintsFactory = managementObject.constraintsFactory();
/* 301 */       moPropertyFactory = managementObject.propertyFactory();
/*     */     }
/*     */ 
/* 304 */     if (trace)
/*     */     {
/* 306 */       log.trace("Building MangedObject(name=" + name + ",nameType=" + nameType + ",attachmentName=" + attachmentName + ",isRuntime=" + isRuntime + ")");
/*     */     }
/*     */ 
/* 310 */     ManagementProperties propertyType = ManagementProperties.ALL;
/* 311 */     if (managementObject != null) {
/* 312 */       propertyType = managementObject.properties();
/*     */     }
/*     */ 
/* 315 */     Set properties = new HashSet();
/*     */ 
/* 317 */     Set propertyInfos = beanInfo.getProperties();
/* 318 */     if ((propertyInfos != null) && (!propertyInfos.isEmpty()))
/*     */     {
/* 320 */       for (PropertyInfo propertyInfo : propertyInfos)
/*     */       {
/* 323 */         if ("class".equals(propertyInfo.getName())) {
/*     */           continue;
/*     */         }
/* 326 */         ManagementProperty managementProperty = (ManagementProperty)propertyInfo.getUnderlyingAnnotation(ManagementProperty.class);
/* 327 */         ManagementObjectID id = (ManagementObjectID)propertyInfo.getUnderlyingAnnotation(ManagementObjectID.class);
/* 328 */         ManagementObjectRef ref = (ManagementObjectRef)propertyInfo.getUnderlyingAnnotation(ManagementObjectRef.class);
/* 329 */         ManagementRuntimeRef runtimeRef = (ManagementRuntimeRef)propertyInfo.getUnderlyingAnnotation(ManagementRuntimeRef.class);
/* 330 */         HashMap propAnnotations = new HashMap();
/* 331 */         if (managementProperty != null)
/* 332 */           propAnnotations.put(ManagementProperty.class.getName(), managementProperty);
/* 333 */         if (id != null)
/*     */         {
/* 335 */           propAnnotations.put(ManagementObjectID.class.getName(), id);
/*     */ 
/* 337 */           nameType = id.type();
/*     */         }
/* 339 */         if (ref != null)
/* 340 */           propAnnotations.put(ManagementObjectRef.class.getName(), ref);
/* 341 */         if (runtimeRef != null) {
/* 342 */           propAnnotations.put(ManagementRuntimeRef.class.getName(), runtimeRef);
/*     */         }
/*     */ 
/* 345 */         boolean includeProperty = propertyType == ManagementProperties.ALL;
/* 346 */         if (managementProperty != null) {
/* 347 */           includeProperty = !managementProperty.ignored();
/*     */         }
/* 349 */         if (includeProperty)
/*     */         {
/* 351 */           Fields fields = null;
/* 352 */           if (managementProperty != null)
/*     */           {
/* 354 */             Class factory = moFieldsFactory;
/* 355 */             if (factory == ManagementProperty.NULL_FIELDS_FACTORY.class)
/* 356 */               factory = managementProperty.fieldsFactory();
/* 357 */             if (factory != ManagementProperty.NULL_FIELDS_FACTORY.class)
/*     */             {
/*     */               try
/*     */               {
/* 361 */                 fields = (Fields)factory.newInstance();
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/* 365 */                 log.debug("Failed to created Fields", e);
/*     */               }
/*     */             }
/*     */           }
/* 369 */           if (fields == null) {
/* 370 */             fields = new DefaultFieldsImpl();
/*     */           }
/* 372 */           if ((propertyInfo instanceof Serializable))
/*     */           {
/* 374 */             Serializable info = (Serializable)Serializable.class.cast(propertyInfo);
/* 375 */             fields.setField("propertyInfo", info);
/*     */           }
/*     */ 
/* 378 */           String propertyName = propertyInfo.getName();
/* 379 */           if (managementProperty != null)
/* 380 */             propertyName = managementProperty.name();
/* 381 */           if (propertyName.length() == 0)
/* 382 */             propertyName = propertyInfo.getName();
/* 383 */           fields.setField("name", propertyName);
/*     */ 
/* 386 */           String mappedName = propertyInfo.getName();
/* 387 */           if (managementProperty != null)
/* 388 */             mappedName = managementProperty.mappedName();
/* 389 */           if (mappedName.length() == 0)
/* 390 */             mappedName = propertyInfo.getName();
/* 391 */           fields.setField("mappedName", mappedName);
/*     */ 
/* 393 */           String description = "%Generated%";
/* 394 */           if (managementProperty != null)
/* 395 */             description = managementProperty.description();
/* 396 */           if (description.equals("%Generated%"))
/* 397 */             description = propertyName;
/* 398 */           fields.setField("description", description);
/*     */ 
/* 400 */           if (trace)
/*     */           {
/* 402 */             log.trace("Building MangedProperty(name=" + propertyName + ",mappedName=" + mappedName + ") ,annotations=" + propAnnotations);
/*     */           }
/*     */ 
/* 407 */           boolean mandatory = false;
/* 408 */           if (managementProperty != null)
/* 409 */             mandatory = managementProperty.mandatory();
/* 410 */           if (mandatory) {
/* 411 */             fields.setField("mandatory", Boolean.TRUE);
/*     */           }
/* 413 */           boolean managed = false;
/* 414 */           if (managementProperty != null)
/* 415 */             managed = managementProperty.managed();
/*     */           MetaType metaType;
/*     */           MetaType metaType;
/* 418 */           if (managed)
/*     */           {
/* 420 */             TypeInfo typeInfo = propertyInfo.getType();
/*     */             MetaType metaType;
/* 421 */             if (typeInfo.isArray()) {
/* 422 */               metaType = new ArrayMetaType(1, MANAGED_OBJECT_META_TYPE);
/*     */             }
/*     */             else
/*     */             {
/*     */               MetaType metaType;
/* 423 */               if (typeInfo.isCollection())
/* 424 */                 metaType = new CollectionMetaType(typeInfo.getName(), MANAGED_OBJECT_META_TYPE);
/*     */               else
/* 426 */                 metaType = MANAGED_OBJECT_META_TYPE;
/*     */             }
/*     */           }
/*     */           else {
/* 430 */             metaType = this.metaTypeFactory.resolve(propertyInfo.getType());
/*     */           }
/* 432 */           fields.setField("metaType", metaType);
/* 433 */           if (!propAnnotations.isEmpty()) {
/* 434 */             fields.setField("annotations", propAnnotations);
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 439 */             Class factoryClass = moConstraintsFactory;
/* 440 */             if (factoryClass == ManagementProperty.NULL_CONSTRAINTS.class)
/*     */             {
/* 442 */               if (managementProperty != null)
/* 443 */                 factoryClass = managementProperty.constraintsFactory();
/*     */             }
/* 445 */             ManagedPropertyConstraintsPopulatorFactory factory = (ManagedPropertyConstraintsPopulatorFactory)factoryClass.newInstance();
/* 446 */             ManagedPropertyConstraintsPopulator populator = factory.newInstance();
/* 447 */             if (populator != null)
/* 448 */               populator.populateManagedProperty(clazz, propertyInfo, fields);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 452 */             log.debug("Failed to populate constraints for: " + propertyInfo, e);
/*     */           }
/*     */ 
/* 455 */           ManagedProperty property = null;
/* 456 */           if (managementProperty != null)
/*     */           {
/* 458 */             Class factory = moPropertyFactory;
/* 459 */             if (factory == ManagementProperty.NULL_PROPERTY_FACTORY.class)
/* 460 */               factory = managementProperty.propertyFactory();
/* 461 */             if (factory != ManagementProperty.NULL_PROPERTY_FACTORY.class) {
/* 462 */               property = getManagedProperty(factory, fields);
/*     */             }
/*     */           }
/*     */ 
/* 466 */           if (property == null)
/* 467 */             property = createDefaultManagedProperty(fields);
/* 468 */           properties.add(property);
/*     */         }
/* 470 */         else if (trace) {
/* 471 */           log.trace("Ignoring property: " + propertyInfo);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 478 */     Set operations = new HashSet();
/*     */ 
/* 480 */     Set methodInfos = beanInfo.getMethods();
/* 481 */     if ((methodInfos != null) && (!methodInfos.isEmpty()))
/*     */     {
/* 483 */       for (MethodInfo methodInfo : methodInfos)
/*     */       {
/* 485 */         ManagementOperation managementOp = (ManagementOperation)methodInfo.getUnderlyingAnnotation(ManagementOperation.class);
/* 486 */         if (managementOp == null) {
/*     */           continue;
/*     */         }
/* 489 */         ManagedOperation op = getManagedOperation(methodInfo, managementOp);
/* 490 */         operations.add(op);
/*     */       }
/*     */     }
/*     */ 
/* 494 */     ManagedObjectImpl result = new ManagedObjectImpl(name, properties);
/* 495 */     result.setAnnotations(moAnnotations);
/* 496 */     if (nameType != null)
/* 497 */       result.setNameType(nameType);
/* 498 */     if (attachmentName != null)
/* 499 */       result.setAttachmentName(attachmentName);
/* 500 */     if (operations.size() > 0)
/* 501 */       result.setOperations(operations);
/* 502 */     for (ManagedProperty property : properties)
/* 503 */       property.setManagedObject(result);
/* 504 */     return result;
/*     */   }
/*     */ 
/*     */   protected ManagedProperty createDefaultManagedProperty(Fields fields)
/*     */   {
/* 516 */     return new WritethroughManagedPropertyImpl(fields, this.metaValueFactory, this);
/*     */   }
/*     */ 
/*     */   public void createObject(ManagedObject managedObject, Class<? extends Serializable> clazz)
/*     */   {
/* 521 */     if (managedObject == null) {
/* 522 */       throw new IllegalArgumentException("Null managed object");
/*     */     }
/* 524 */     if (!(managedObject instanceof ManagedObjectImpl)) {
/* 525 */       throw new IllegalStateException("Unable to create object " + managedObject.getClass().getName());
/*     */     }
/* 527 */     ManagedObjectImpl managedObjectImpl = (ManagedObjectImpl)managedObject;
/* 528 */     Serializable object = createUnderlyingObject(managedObjectImpl, clazz);
/* 529 */     populateManagedObject(managedObject, object);
/*     */   }
/*     */ 
/*     */   public void populateManagedObject(ManagedObject managedObject, Serializable object)
/*     */   {
/* 534 */     if (!(managedObject instanceof ManagedObjectImpl)) {
/* 535 */       throw new IllegalStateException("Unable to populate managed object " + managedObject.getClass().getName());
/*     */     }
/* 537 */     ManagedObjectImpl managedObjectImpl = (ManagedObjectImpl)managedObject;
/* 538 */     managedObjectImpl.setAttachment(object);
/* 539 */     populateValues(managedObjectImpl, object);
/*     */   }
/*     */ 
/*     */   protected Serializable createUnderlyingObject(ManagedObjectImpl managedObject, Class<? extends Serializable> clazz)
/*     */   {
/* 551 */     BeanInfo beanInfo = configuration.getBeanInfo(clazz);
/*     */     try
/*     */     {
/* 554 */       Object result = beanInfo.newInstance();
/* 555 */       return (Serializable)Serializable.class.cast(result);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 559 */     throw new RuntimeException("Unable to create new object for " + managedObject + " clazz=" + clazz, t);
/*     */   }
/*     */ 
/*     */   protected void populateValues(ManagedObjectImpl managedObject, Serializable object) {
/* 572 */     InstanceClassFactory icf = getInstanceClassFactory(object.getClass());
/*     */     Class moClass;
/*     */     try {
/* 576 */       moClass = icf.getManagedObjectClass(object);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 580 */       throw new IllegalStateException(e);
/*     */     }
/* 582 */     BeanInfo beanInfo = configuration.getBeanInfo(moClass);
/*     */ 
/* 584 */     Object componentName = null;
/* 585 */     Map properties = managedObject.getProperties();
/* 586 */     if ((properties != null) && (properties.size() > 0))
/*     */     {
/* 588 */       for (ManagedProperty property : properties.values())
/*     */       {
/* 590 */         MetaValue value = icf.getValue(beanInfo, property, object);
/* 591 */         if (value != null) {
/* 592 */           property.setField("value", value);
/*     */         }
/*     */ 
/* 596 */         Map annotations = property.getAnnotations();
/* 597 */         if (annotations == null)
/*     */           continue;
/* 599 */         ManagementObjectID id = (ManagementObjectID)annotations.get(ManagementObjectID.class.getName());
/* 600 */         if (id != null)
/*     */         {
/* 602 */           if ((value == null) || (!value.getMetaType().isSimple()))
/*     */           {
/* 604 */             log.warn("Cannot create String name from non-Simple property: " + property + ", value=" + value);
/*     */ 
/* 606 */             continue;
/*     */           }
/* 608 */           SimpleValue svalue = (SimpleValue)value;
/* 609 */           String name = "" + svalue.getValue();
/* 610 */           managedObject.setName(name);
/*     */         }
/* 612 */         ManagementRuntimeRef runtimeRef = (ManagementRuntimeRef)annotations.get(ManagementRuntimeRef.class.getName());
/* 613 */         if (runtimeRef != null)
/*     */         {
/* 615 */           componentName = icf.getComponentName(beanInfo, property, object, value);
/*     */ 
/* 617 */           if ((componentName == null) && (icf != this))
/* 618 */             componentName = getComponentName(beanInfo, property, object, value);
/*     */         }
/*     */       }
/*     */     }
/* 622 */     if (componentName == null) {
/* 623 */       componentName = icf.getComponentName(null, null, object, null);
/*     */     }
/* 625 */     managedObject.setComponentName(componentName);
/*     */   }
/*     */ 
/*     */   protected String getPropertyName(ManagedProperty property)
/*     */   {
/* 637 */     String name = property.getMappedName();
/* 638 */     if (name == null)
/* 639 */       property.getName();
/* 640 */     return name;
/*     */   }
/*     */ 
/*     */   public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value)
/*     */   {
/* 645 */     if ((beanInfo != null) && (property != null) && (value != null))
/*     */     {
/* 647 */       String name = getPropertyName(property);
/* 648 */       PropertyInfo propertyInfo = beanInfo.getProperty(name);
/*     */ 
/* 650 */       ManagementRuntimeRef componentRef = (ManagementRuntimeRef)propertyInfo.getUnderlyingAnnotation(ManagementRuntimeRef.class);
/* 651 */       if (componentRef != null)
/*     */       {
/* 653 */         Object original = this.metaValueFactory.unwrap(value, propertyInfo.getType());
/*     */         try
/*     */         {
/* 656 */           Class tClass = componentRef.transformer();
/*     */           RuntimeComponentNameTransformer transformer;
/*     */           RuntimeComponentNameTransformer transformer;
/* 658 */           if (tClass != ManagementRuntimeRef.DEFAULT_NAME_TRANSFORMER.class)
/* 659 */             transformer = getComponentNameTransformer(configuration.getTypeInfo(tClass));
/*     */           else {
/* 661 */             transformer = getComponentNameTransformer(propertyInfo.getType());
/*     */           }
/* 663 */           return transformer != null ? transformer.transform(original) : original;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 667 */           throw new UndeclaredThrowableException(t);
/*     */         }
/*     */       }
/*     */     }
/* 671 */     return null;
/*     */   }
/*     */ 
/*     */   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, Serializable object) {
/* 684 */     String name = getPropertyName(property);
/* 685 */     PropertyInfo propertyInfo = beanInfo.getProperty(name);
/*     */     Object value;
/*     */     try {
/* 690 */       value = propertyInfo.get(object);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 694 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 698 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 702 */       throw new RuntimeException("Error getting property " + name + " for " + object.getClass().getName(), t);
/*     */     }
/*     */ 
/* 705 */     if (value == null) {
/* 706 */       return null;
/*     */     }
/* 708 */     MetaType propertyType = property.getMetaType();
/* 709 */     if (MANAGED_OBJECT_META_TYPE == propertyType)
/*     */     {
/* 711 */       if (!(value instanceof Serializable)) {
/* 712 */         throw new IllegalStateException("Object is not serializable: " + value.getClass().getName());
/*     */       }
/* 714 */       ManagementObjectRef ref = (ManagementObjectRef)property.getAnnotations().get(ManagementObjectRef.class.getName());
/* 715 */       String moName = ref != null ? ref.name() : value.getClass().getName();
/* 716 */       String moNameType = ref != null ? ref.type() : "";
/* 717 */       ManagedObject mo = initManagedObject((Serializable)value, moName, moNameType);
/* 718 */       return new GenericValueSupport(MANAGED_OBJECT_META_TYPE, mo);
/*     */     }
/* 720 */     if (propertyType.isArray())
/*     */     {
/* 722 */       ArrayMetaType arrayType = (ArrayMetaType)ArrayMetaType.class.cast(propertyType);
/* 723 */       if (MANAGED_OBJECT_META_TYPE == arrayType.getElementType())
/*     */       {
/* 725 */         Collection cvalue = getAsCollection(value);
/*     */ 
/* 727 */         ArrayMetaType moType = new ArrayMetaType(1, MANAGED_OBJECT_META_TYPE);
/* 728 */         ArrayValueSupport moArrayValue = new ArrayValueSupport(moType);
/* 729 */         List tmp = new ArrayList();
/* 730 */         for (Iterator i$ = cvalue.iterator(); i$.hasNext(); ) { Object element = i$.next();
/*     */ 
/* 732 */           ManagedObject mo = initManagedObject((Serializable)element, null, null);
/* 733 */           tmp.add(new GenericValueSupport(MANAGED_OBJECT_META_TYPE, mo));
/*     */         }
/* 735 */         GenericValueSupport[] mos = new GenericValueSupport[tmp.size()];
/* 736 */         moArrayValue.setValue(tmp.toArray(mos));
/* 737 */         return moArrayValue;
/*     */       }
/*     */     }
/* 740 */     else if (propertyType.isCollection())
/*     */     {
/* 742 */       CollectionMetaType collectionType = (CollectionMetaType)CollectionMetaType.class.cast(propertyType);
/* 743 */       if (MANAGED_OBJECT_META_TYPE == collectionType.getElementType())
/*     */       {
/* 745 */         Collection cvalue = getAsCollection(value);
/* 746 */         List tmp = new ArrayList();
/* 747 */         for (Iterator i$ = cvalue.iterator(); i$.hasNext(); ) { Object element = i$.next();
/*     */ 
/* 749 */           ManagedObject mo = initManagedObject((Serializable)element, null, null);
/* 750 */           tmp.add(new GenericValueSupport(MANAGED_OBJECT_META_TYPE, mo));
/*     */         }
/* 752 */         GenericValueSupport[] mos = new GenericValueSupport[tmp.size()];
/* 753 */         CollectionMetaType moType = new CollectionMetaType(propertyType.getClassName(), MANAGED_OBJECT_META_TYPE);
/* 754 */         return new CollectionValueSupport(moType, (MetaValue[])tmp.toArray(mos));
/*     */       }
/*     */     }
/*     */ 
/* 758 */     return this.metaValueFactory.create(value, propertyInfo.getType());
/*     */   }
/*     */ 
/*     */   public void setValue(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value)
/*     */   {
/* 771 */     String name = getPropertyName(property);
/* 772 */     PropertyInfo propertyInfo = beanInfo.getProperty(name);
/*     */ 
/* 774 */     Object plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
/*     */     try
/*     */     {
/* 777 */       propertyInfo.set(object, plainValue);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 781 */       throw new UndeclaredThrowableException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ManagedOperation getManagedOperation(MethodInfo methodInfo, ManagementOperation opAnnotation)
/*     */   {
/* 793 */     String name = methodInfo.getName();
/* 794 */     String description = opAnnotation.description();
/* 795 */     ManagedOperation.Impact impact = opAnnotation.impact();
/* 796 */     ManagementParameter[] params = opAnnotation.params();
/* 797 */     ParameterInfo[] paramInfo = methodInfo.getParameters();
/* 798 */     TypeInfo returnInfo = methodInfo.getReturnType();
/* 799 */     MetaType returnType = this.metaTypeFactory.resolve(returnInfo);
/* 800 */     ArrayList mparams = new ArrayList();
/* 801 */     Class opConstraintsFactor = opAnnotation.constraintsFactory();
/*     */ 
/* 803 */     if (paramInfo != null)
/*     */     {
/* 805 */       for (int i = 0; i < paramInfo.length; i++)
/*     */       {
/* 807 */         ParameterInfo pinfo = paramInfo[i];
/* 808 */         String pname = pinfo.getName();
/* 809 */         String pdescription = null;
/* 810 */         ManagementParameter mpa = null;
/*     */ 
/* 812 */         if (i < params.length)
/*     */         {
/* 814 */           mpa = params[i];
/* 815 */           if (!mpa.name().equals(""))
/* 816 */             pname = mpa.name();
/* 817 */           if (!mpa.description().equals("")) {
/* 818 */             pdescription = mpa.description();
/*     */           }
/*     */         }
/* 821 */         if (pname == null)
/* 822 */           pname = "arg#" + i;
/* 823 */         Fields fields = new DefaultFieldsImpl(pname);
/* 824 */         if (pdescription != null)
/* 825 */           fields.setField("description", pdescription);
/* 826 */         MetaType metaType = this.metaTypeFactory.resolve(pinfo.getParameterType());
/* 827 */         fields.setField("metaType", metaType);
/*     */         try
/*     */         {
/* 831 */           Class factoryClass = opConstraintsFactor;
/* 832 */           if (factoryClass == ManagementParameter.NULL_CONSTRAINTS.class)
/*     */           {
/* 834 */             if (mpa != null)
/* 835 */               factoryClass = mpa.constraintsFactory();
/*     */           }
/* 837 */           ManagedParameterConstraintsPopulatorFactory factory = (ManagedParameterConstraintsPopulatorFactory)factoryClass.newInstance();
/* 838 */           ManagedParameterConstraintsPopulator populator = factory.newInstance();
/* 839 */           if (populator != null)
/* 840 */             populator.populateManagedParameter(name, pinfo, fields);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 844 */           log.debug("Failed to populate constraints for: " + pinfo, e);
/*     */         }
/*     */ 
/* 847 */         ManagedParameterImpl mp = new ManagedParameterImpl(fields);
/* 848 */         mparams.add(mp);
/*     */       }
/*     */     }
/* 851 */     ManagedParameter[] parameters = new ManagedParameter[mparams.size()];
/* 852 */     mparams.toArray(parameters);
/*     */ 
/* 854 */     return new ManagedOperationImpl(name, description, impact, parameters, returnType);
/*     */   }
/*     */ 
/*     */   protected ManagedObjectBuilder getBuilder(Class<?> clazz)
/*     */   {
/* 865 */     synchronized (this.builders)
/*     */     {
/* 867 */       ManagedObjectBuilder builder = (ManagedObjectBuilder)this.builders.get(clazz);
/* 868 */       if (builder != null)
/* 869 */         return builder;
/*     */     }
/* 871 */     return this;
/*     */   }
/*     */ 
/*     */   public <T extends Serializable> InstanceClassFactory<T> getInstanceClassFactory(Class<T> clazz)
/*     */   {
/* 883 */     synchronized (this.instanceFactories)
/*     */     {
/* 885 */       InstanceClassFactory factory = (InstanceClassFactory)this.instanceFactories.get(clazz);
/* 886 */       if (factory != null)
/* 887 */         return factory;
/*     */     }
/* 889 */     return this;
/*     */   }
/*     */ 
/*     */   protected RuntimeComponentNameTransformer getComponentNameTransformer(TypeInfo type)
/*     */     throws Throwable
/*     */   {
/* 901 */     synchronized (this.transformers)
/*     */     {
/* 903 */       RuntimeComponentNameTransformer transformer = (RuntimeComponentNameTransformer)this.transformers.get(type);
/* 904 */       if (transformer != null) {
/* 905 */         return transformer;
/*     */       }
/* 907 */       TypeInfo rcntType = configuration.getTypeInfo(RuntimeComponentNameTransformer.class);
/* 908 */       if (rcntType.isAssignableFrom(type))
/*     */       {
/* 910 */         BeanInfo beanInfo = configuration.getBeanInfo(type);
/* 911 */         RuntimeComponentNameTransformer newTransformer = (RuntimeComponentNameTransformer)beanInfo.newInstance();
/* 912 */         this.transformers.put(type, newTransformer);
/* 913 */         return newTransformer;
/*     */       }
/*     */ 
/* 916 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ManagedObjectPopulator<Serializable> getPopulator(Class<?> clazz)
/*     */   {
/* 929 */     ManagedObjectBuilder builder = getBuilder(clazz);
/* 930 */     if ((builder instanceof ManagedObjectPopulator))
/* 931 */       return (ManagedObjectPopulator)builder;
/* 932 */     return this;
/*     */   }
/*     */ 
/*     */   protected Collection getAsCollection(Object value)
/*     */   {
/* 937 */     if (value.getClass().isArray())
/* 938 */       return Arrays.asList(new Object[] { value });
/* 939 */     if ((value instanceof Collection))
/* 940 */       return (Collection)Collection.class.cast(value);
/* 941 */     return null;
/*     */   }
/*     */ 
/*     */   protected ManagedProperty getManagedProperty(Class<? extends ManagedProperty> factory, Fields fields)
/*     */   {
/* 952 */     ManagedProperty property = null;
/*     */     try
/*     */     {
/* 955 */       Class[] sig = { Fields.class };
/* 956 */       Constructor ctor = factory.getConstructor(sig);
/* 957 */       Object[] args = { fields };
/* 958 */       property = (ManagedProperty)ctor.newInstance(args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 962 */       log.debug("Failed to create ManagedProperty", e);
/*     */     }
/* 964 */     return property;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 127 */     configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Configuration run()
/*     */       {
/* 131 */         return new PropertyConfiguration();
/*     */       }
/*     */     });
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.factory.AbstractManagedObjectFactory
 * JD-Core Version:    0.6.0
 */